/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.refiner.precision;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;

public interface ConstraintsPrecision
extends Precision {
    public boolean isTracked(Constraint var1, CFANode var2);

    public ConstraintsPrecision join(ConstraintsPrecision var1);

    public ConstraintsPrecision withIncrement(Increment var1);

    public static class Increment {
        private Multimap<CFANode, Constraint> trackedLocally = HashMultimap.create();
        private Multimap<String, Constraint> trackedInFunction = HashMultimap.create();
        private Set<Constraint> trackedGlobally = new HashSet<Constraint>();

        private Increment(Multimap<CFANode, Constraint> pTrackedLocally, Multimap<String, Constraint> pTrackedInFunction, Set<Constraint> pTrackedGlobally) {
            this.trackedLocally = pTrackedLocally;
            this.trackedInFunction = pTrackedInFunction;
            this.trackedGlobally = pTrackedGlobally;
        }

        public Set<Constraint> getTrackedGlobally() {
            return this.trackedGlobally;
        }

        public Multimap<String, Constraint> getTrackedInFunction() {
            return this.trackedInFunction;
        }

        public Multimap<CFANode, Constraint> getTrackedLocally() {
            return this.trackedLocally;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ConstraintsPrecision.Increment[");
            if (!this.trackedLocally.isEmpty()) {
                sb.append("\n\tTracked locally:\n");
                sb.append(this.trackedLocally.toString());
            }
            if (!this.trackedInFunction.isEmpty()) {
                sb.append("\n\tTracked in function:\n");
                sb.append(this.trackedInFunction.toString());
            }
            if (!this.trackedGlobally.isEmpty()) {
                sb.append("\n\tTracked globally:\n");
                sb.append(this.trackedGlobally.toString());
            }
            sb.append("]");
            return sb.toString();
        }

        public static class Builder {
            private Multimap<CFANode, Constraint> trackedLocally = HashMultimap.create();
            private Multimap<String, Constraint> trackedInFunction = HashMultimap.create();
            private Set<Constraint> trackedGlobally = new HashSet<Constraint>();

            private Builder() {
            }

            @CanIgnoreReturnValue
            public Builder locallyTracked(CFANode pNode, Constraint pConstraint) {
                this.trackedLocally.put((Object)pNode, (Object)pConstraint);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder locallyTracked(CFANode pNode, Collection<Constraint> pConstraints) {
                this.trackedLocally.putAll((Object)pNode, pConstraints);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder locallyTracked(Multimap<CFANode, Constraint> pTrackedLocally) {
                this.trackedLocally.putAll(pTrackedLocally);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder functionWiseTracked(String pFunctionName, Constraint pConstraint) {
                this.trackedInFunction.put((Object)pFunctionName, (Object)pConstraint);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder functionWiseTracked(Multimap<String, Constraint> pTrackedFunctionWise) {
                this.trackedInFunction.putAll(pTrackedFunctionWise);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder globallyTracked(Constraint pConstraint) {
                this.trackedGlobally.add(pConstraint);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder globallyTracked(Set<Constraint> pTrackedGlobally) {
                this.trackedGlobally.addAll(pTrackedGlobally);
                return this;
            }

            public Increment build() {
                return new Increment(this.trackedLocally, this.trackedInFunction, this.trackedGlobally);
            }
        }
    }
}

