/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.refiner.precision;

import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;

final class LocationBasedConstraintsPrecision
implements ConstraintsPrecision {
    private static final LocationBasedConstraintsPrecision EMPTY = new LocationBasedConstraintsPrecision();
    private Set<CFANode> trackedLocations;

    private LocationBasedConstraintsPrecision() {
        this.trackedLocations = new HashSet<CFANode>();
    }

    private LocationBasedConstraintsPrecision(LocationBasedConstraintsPrecision pOther) {
        this.trackedLocations = pOther.trackedLocations;
    }

    public static ConstraintsPrecision getEmptyPrecision() {
        return EMPTY;
    }

    @Override
    public boolean isTracked(Constraint pConstraint, CFANode pLocation) {
        return this.trackedLocations.contains(pLocation);
    }

    @Override
    public LocationBasedConstraintsPrecision join(ConstraintsPrecision pOther) {
        assert (pOther instanceof LocationBasedConstraintsPrecision);
        LocationBasedConstraintsPrecision that = (LocationBasedConstraintsPrecision)pOther;
        LocationBasedConstraintsPrecision newPrec = new LocationBasedConstraintsPrecision(this);
        newPrec.trackedLocations.addAll(that.trackedLocations);
        return newPrec;
    }

    @Override
    public LocationBasedConstraintsPrecision withIncrement(ConstraintsPrecision.Increment pIncrement) {
        assert (pIncrement.getTrackedGlobally().isEmpty());
        assert (pIncrement.getTrackedInFunction().isEmpty());
        LocationBasedConstraintsPrecision newPrec = new LocationBasedConstraintsPrecision(this);
        newPrec.trackedLocations.addAll(pIncrement.getTrackedLocally().keySet());
        return newPrec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationBasedConstraintsPrecision that = (LocationBasedConstraintsPrecision)o;
        return this.trackedLocations.equals(that.trackedLocations);
    }

    public int hashCode() {
        return this.trackedLocations.hashCode();
    }

    public String toString() {
        return "LocationBasedConstraintsPrecision{" + this.trackedLocations + "}";
    }
}

