/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.refiner.precision;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintBasedConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.LocationBasedConstraintsPrecision;

@Options(prefix="cpa.constraints.refinement")
public class RefinableConstraintsPrecision
implements ConstraintsPrecision {
    @Option(description="Type of precision to use. Has to be LOCATION if PredicateExtractionRefiner is used.", toUppercase=true)
    private PrecisionType precisionType = PrecisionType.CONSTRAINTS;
    private final ConstraintsPrecision delegate;

    public RefinableConstraintsPrecision(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        switch (this.precisionType) {
            case CONSTRAINTS: {
                this.delegate = ConstraintBasedConstraintsPrecision.getEmptyPrecision();
                break;
            }
            case LOCATION: {
                this.delegate = LocationBasedConstraintsPrecision.getEmptyPrecision();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled precision type " + this.precisionType));
            }
        }
    }

    private RefinableConstraintsPrecision(ConstraintsPrecision pDelegate) {
        this.delegate = pDelegate;
    }

    @Override
    public boolean isTracked(Constraint pConstraint, CFANode pLocation) {
        return this.delegate.isTracked(pConstraint, pLocation);
    }

    @Override
    public ConstraintsPrecision join(ConstraintsPrecision pOther) {
        assert (pOther instanceof RefinableConstraintsPrecision);
        ConstraintsPrecision otherDelegate = ((RefinableConstraintsPrecision)pOther).delegate;
        return new RefinableConstraintsPrecision(this.delegate.join(otherDelegate));
    }

    @Override
    public ConstraintsPrecision withIncrement(ConstraintsPrecision.Increment pIncrement) {
        return new RefinableConstraintsPrecision(this.delegate.withIncrement(pIncrement));
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        int result = this.precisionType.hashCode();
        result = 31 * result + this.delegate.hashCode();
        return result;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static enum PrecisionType {
        CONSTRAINTS,
        LOCATION;

    }
}

