/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.util;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.ConstraintTrivialityChecker;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicValues;

@Options(prefix="cpa.constraints")
public class StateSimplifier {
    @Option(description="Whether to remove trivial constraints from constraints states during simplification", secure=true)
    private boolean removeTrivial = false;
    @Option(description="Whether to remove constraints that can't add any more information toanalysis during simplification", secure=true)
    private boolean removeOutdated = true;
    private final ConstraintsStatistics stats;

    public StateSimplifier(Configuration pConfig, ConstraintsStatistics pStats) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.stats = pStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintsState simplify(ConstraintsState pState, ValueAnalysisState pValueState) {
        ConstraintsState newState = pState.copyOf();
        if (this.removeTrivial) {
            try {
                this.stats.trivialRemovalTime.start();
                this.removeTrivialConstraints(pState);
            }
            finally {
                this.stats.trivialRemovalTime.stop();
            }
        }
        if (this.removeOutdated) {
            try {
                this.stats.outdatedRemovalTime.start();
                this.removeOutdatedConstraints(pState, pValueState);
            }
            finally {
                this.stats.outdatedRemovalTime.stop();
            }
        }
        return newState;
    }

    public void removeTrivialConstraints(ConstraintsState pState) {
        int sizeBefore = pState.size();
        pState.removeIf(this::isTrivial);
        this.stats.removedTrivial.setNextValue(sizeBefore - pState.size());
    }

    private boolean isTrivial(Constraint pConstraint) {
        ConstraintTrivialityChecker trivialityChecker = new ConstraintTrivialityChecker();
        return pConstraint.accept(trivialityChecker);
    }

    public void removeOutdatedConstraints(ConstraintsState pState, ValueAnalysisState pValueState) {
        int sizeBefore = pState.size();
        Map<ActivityInfo, Set<ActivityInfo>> symIdActivity = this.getInitialActivityMap(pState);
        Set<SymbolicIdentifier> symbolicValues = this.getExistingSymbolicIds(pValueState);
        block4: for (Map.Entry<ActivityInfo, Set<ActivityInfo>> e : symIdActivity.entrySet()) {
            ActivityInfo s = e.getKey();
            SymbolicIdentifier currId = s.getIdentifier();
            switch (s.getActivity()) {
                case DELETED: {
                    pState.removeAll(s.getUsingConstraints());
                    break;
                }
                case ACTIVE: 
                case UNUSED: {
                    boolean canBeRemoved;
                    if (symbolicValues.contains(currId)) continue block4;
                    if (s.getUsingConstraints().size() < 2) {
                        canBeRemoved = true;
                    } else {
                        s.disable();
                        HashSet<ActivityInfo> parent = new HashSet<ActivityInfo>();
                        parent.add(s);
                        canBeRemoved = this.removeOutdatedConstraints0(symIdActivity, symbolicValues, e.getValue(), parent);
                    }
                    if (!canBeRemoved) continue block4;
                    s.markDeleted();
                    pState.removeAll(s.getUsingConstraints());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled activity type: " + s.getActivity()));
                }
            }
        }
        this.stats.removedOutdated.setNextValue(sizeBefore - pState.size());
    }

    private boolean removeOutdatedConstraints0(Map<ActivityInfo, Set<ActivityInfo>> pSymIdActivity, Set<SymbolicIdentifier> pExistingValues, Set<ActivityInfo> targets, Set<ActivityInfo> parents) {
        block5: for (ActivityInfo t : targets) {
            if (pExistingValues.contains(t.getIdentifier())) {
                return false;
            }
            if (t.getActivity() == Activity.ACTIVE) {
                t.disable();
            }
            switch (t.getActivity()) {
                case ACTIVE: {
                    return false;
                }
                case DELETED: {
                    continue block5;
                }
                case UNUSED: {
                    Set<ActivityInfo> dependents = pSymIdActivity.get(t);
                    dependents.removeAll(parents);
                    Iterables.removeIf(dependents, pActivityInfo -> pActivityInfo.getActivity() == Activity.DELETED);
                    if (dependents.isEmpty()) {
                        t.markDeleted();
                        return true;
                    }
                    parents.add(t);
                    boolean success = this.removeOutdatedConstraints0(pSymIdActivity, pExistingValues, dependents, parents);
                    if (!success) {
                        return false;
                    }
                    t.markDeleted();
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unhandled state of ActivityInfo: " + t.getActivity()));
        }
        assert (this.allDeleted(targets));
        return true;
    }

    private boolean allDeleted(Set<ActivityInfo> pInfos) {
        for (ActivityInfo i : pInfos) {
            if (i.getActivity() == Activity.DELETED) continue;
            return false;
        }
        return true;
    }

    private Set<SymbolicIdentifier> getExistingSymbolicIds(ValueAnalysisState pValueState) {
        return (Set)FluentIterable.from(pValueState.getConstants()).transform(e -> ((ValueAnalysisState.ValueAndType)e.getValue()).getValue()).filter(SymbolicValue.class).transformAndConcat(SymbolicValues::getContainedSymbolicIdentifiers).copyInto(new HashSet());
    }

    private Map<ActivityInfo, Set<ActivityInfo>> getInitialActivityMap(ConstraintsState pState) {
        HashMap<ActivityInfo, Set<ActivityInfo>> activityMap = new HashMap<ActivityInfo, Set<ActivityInfo>>();
        for (Constraint c : pState) {
            Collection<SymbolicIdentifier> usedIdentifiers = SymbolicValues.getContainedSymbolicIdentifiers(c);
            for (SymbolicIdentifier i : usedIdentifiers) {
                HashSet<SymbolicIdentifier> otherIdentifiers = new HashSet<SymbolicIdentifier>(usedIdentifiers);
                otherIdentifiers.remove(i);
                Set<ActivityInfo> dependents = this.createActivitySet(otherIdentifiers, c);
                ActivityInfo currActivityInfo = ActivityInfo.getInfo(i, c);
                Set existingDependents = (Set)activityMap.get(currActivityInfo);
                if (existingDependents == null) {
                    activityMap.put(currActivityInfo, dependents);
                    continue;
                }
                existingDependents.addAll(dependents);
            }
        }
        return activityMap;
    }

    private Set<ActivityInfo> createActivitySet(Set<SymbolicIdentifier> pIdentifiers, Constraint pUsingConstraint) {
        HashSet<ActivityInfo> activitySet = new HashSet<ActivityInfo>();
        for (SymbolicIdentifier i : pIdentifiers) {
            activitySet.add(ActivityInfo.getInfo(i, pUsingConstraint));
        }
        return activitySet;
    }

    private static final class ActivityInfo {
        private static final Map<SymbolicIdentifier, ActivityInfo> infos = new HashMap<SymbolicIdentifier, ActivityInfo>();
        private final SymbolicIdentifier identifier;
        private Set<Constraint> usingConstraints;
        private Activity activity;

        static ActivityInfo getInfo(SymbolicIdentifier pIdentifier, Constraint pConstraint) {
            if (infos.containsKey(pIdentifier)) {
                ActivityInfo info = infos.get(pIdentifier);
                info.usingConstraints.add(pConstraint);
                info.enable();
                return info;
            }
            ActivityInfo info = new ActivityInfo(pIdentifier, pConstraint);
            infos.put(pIdentifier, info);
            return info;
        }

        private ActivityInfo(SymbolicIdentifier pIdentifier, Constraint pConstraint) {
            this.identifier = pIdentifier;
            this.activity = Activity.ACTIVE;
            this.usingConstraints = new HashSet<Constraint>();
            this.usingConstraints.add(pConstraint);
        }

        public SymbolicIdentifier getIdentifier() {
            return this.identifier;
        }

        public Set<Constraint> getUsingConstraints() {
            return this.usingConstraints;
        }

        public Activity getActivity() {
            return this.activity;
        }

        public void disable() {
            this.activity = Activity.UNUSED;
        }

        public void enable() {
            this.activity = Activity.ACTIVE;
        }

        public void markDeleted() {
            this.activity = Activity.DELETED;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActivityInfo that = (ActivityInfo)o;
            return SymbolicValues.representSameSymbolicMeaning(this.identifier, that.identifier);
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }
    }

    private static enum Activity {
        ACTIVE,
        UNUSED,
        DELETED;

    }
}

