/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.constraints.util;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.constraints.util.StateSimplifier;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class StateSimplifierTest {
    private final MachineModel machineModel = MachineModel.LINUX32;
    private final StateSimplifier simplifier;
    private final SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
    private final Type defaultNumericType = CNumericTypes.INT;
    private final SymbolicExpression number = this.factory.asConstant(new NumericValue(5), this.defaultNumericType);
    private final MemoryLocation memLoc1 = MemoryLocation.forIdentifier("id1");
    private final SymbolicExpression group1Id1 = this.factory.asConstant(this.factory.newIdentifier(this.memLoc1), this.defaultNumericType);
    private final SymbolicExpression group1Id2 = this.factory.asConstant(this.factory.newIdentifier(this.memLoc1), this.defaultNumericType);
    private final SymbolicExpression group2Id1 = this.factory.asConstant(this.factory.newIdentifier(this.memLoc1), this.defaultNumericType);
    private final SymbolicExpression group2Id2 = this.factory.asConstant(this.factory.newIdentifier(this.memLoc1), this.defaultNumericType);
    private final Constraint group1Constraint1 = (Constraint)((Object)this.factory.greaterThanOrEqual(this.group1Id1, this.group1Id2, this.defaultNumericType, this.defaultNumericType));
    private final Constraint group1Constraint2 = (Constraint)((Object)this.factory.lessThanOrEqual(this.group1Id2, this.group1Id1, this.defaultNumericType, this.defaultNumericType));
    private final Constraint group2Constraint1 = (Constraint)((Object)this.factory.lessThan(this.group2Id1, this.number, this.defaultNumericType, this.defaultNumericType));
    private final Constraint group2Constraint2 = (Constraint)((Object)this.factory.lessThan(this.group2Id2, this.group2Id1, this.defaultNumericType, this.defaultNumericType));
    private final MemoryLocation group1MemLoc1 = MemoryLocation.forIdentifier("a");
    private final MemoryLocation group1MemLoc2 = MemoryLocation.forIdentifier("b");
    private final MemoryLocation group2MemLoc1 = MemoryLocation.forIdentifier("c");
    private final MemoryLocation group2MemLoc2 = MemoryLocation.forIdentifier("d");

    public StateSimplifierTest() throws InvalidConfigurationException {
        Configuration config = Configuration.builder().setOption("cpa.constraints.removeTrivial", "true").build();
        this.simplifier = new StateSimplifier(config, new ConstraintsStatistics());
    }

    @Test
    public void testRemoveOutdatedConstraints_allConstraintsOutdated() {
        ValueAnalysisState initialValueState = new ValueAnalysisState(this.machineModel);
        ConstraintsState constraintsState = this.getSampleConstraints();
        this.simplifier.removeOutdatedConstraints(constraintsState, initialValueState);
        Truth.assertThat((Iterable)constraintsState).isEmpty();
    }

    @Test
    public void testRemoveOutdatedConstraints_group1ConstraintOutdated() {
        ValueAnalysisState valueState = this.getCompleteValueState();
        valueState.forget(this.group1MemLoc1);
        valueState.forget(this.group2MemLoc1);
        ConstraintsState constraintsState = this.getSampleConstraints();
        this.simplifier.removeOutdatedConstraints(constraintsState, valueState);
        Truth.assertThat((Boolean)this.group2ConstraintsExist(constraintsState)).isTrue();
    }

    private boolean group2ConstraintsExist(ConstraintsState pNewState) {
        return pNewState.contains(this.group2Constraint1) && pNewState.contains(this.group2Constraint2);
    }

    @Test
    public void testRemoveOutdatedConstraints_allButOneConstraintsOutdated() {
        ValueAnalysisState valueState = this.getCompleteValueState();
        valueState.forget(this.group1MemLoc1);
        valueState.forget(this.group1MemLoc2);
        valueState.forget(this.group2MemLoc2);
        ConstraintsState constraintsState = this.getSampleConstraints();
        this.simplifier.removeOutdatedConstraints(constraintsState, valueState);
        Truth.assertThat((Iterable)constraintsState).hasSize(1);
        Truth.assertThat((Iterable)constraintsState).contains((Object)this.group2Constraint1);
    }

    private ConstraintsState getSampleConstraints() {
        ConstraintsState state = new ConstraintsState();
        state.add(this.group1Constraint1);
        state.add(this.group1Constraint2);
        state.add(this.group2Constraint1);
        state.add(this.group2Constraint2);
        return state;
    }

    private ValueAnalysisState getCompleteValueState() {
        ValueAnalysisState state = new ValueAnalysisState(this.machineModel);
        state.assignConstant(this.group1MemLoc1, (Value)this.group1Id1, this.defaultNumericType);
        state.assignConstant(this.group1MemLoc2, (Value)this.group1Id2, this.defaultNumericType);
        state.assignConstant(this.group2MemLoc1, (Value)this.group2Id1, this.defaultNumericType);
        state.assignConstant(this.group2MemLoc2, (Value)this.group2Id2, this.defaultNumericType);
        return state;
    }
}

