/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.coverage;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonAbstractState;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.coverage.CoverageStatistics;
import org.sosy_lab.cpachecker.cpa.coverage.CoverageTransferRelation;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;

public class CoverageCPA
implements ConfigurableProgramAnalysis,
StatisticsProvider {
    private final TransferRelation transfer;
    private final AbstractDomain domain;
    private final StopOperator stop;
    private final Statistics stats;
    private static final CoverageData cov = new CoverageData();

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(CoverageCPA.class);
    }

    public CoverageCPA(Configuration pConfig, LogManager pLogger, CFA pCFA) throws InvalidConfigurationException {
        cov.putCFA(pCFA);
        this.domain = new FlatLatticeDomain(SingletonAbstractState.INSTANCE);
        this.stop = new StopSepOperator(this.domain);
        this.transfer = new CoverageTransferRelation(cov);
        this.stats = new CoverageStatistics(pConfig, pLogger, cov);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) {
        return SingletonAbstractState.INSTANCE;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }
}

