/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.coverage;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;
import org.sosy_lab.cpachecker.util.coverage.CoverageReportGcov;
import org.sosy_lab.cpachecker.util.coverage.CoverageReportStdoutSummary;

@Options
public class CoverageStatistics
implements Statistics {
    @Option(secure=true, name="coverage.file", description="print coverage info to file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path outputCoverageFile = Path.of("coverage.info", new String[0]);
    private final LogManager logger;
    private final CoverageData cov;

    public CoverageStatistics(Configuration pConfig, LogManager pLogger, CoverageData pCov) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.cov = pCov;
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        CoverageReportStdoutSummary.write(this.cov, pOut);
        if (this.outputCoverageFile != null) {
            try (Writer w = IO.openOutputFile((Path)this.outputCoverageFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                CoverageReportGcov.write(this.cov, w);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write coverage information to file");
            }
        }
    }

    @Override
    public String getName() {
        return "Code Coverage (Mode: Transfer)";
    }
}

