/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.coverage;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;

public class CoverageTransferRelation
extends SingleEdgeTransferRelation {
    private final CoverageData cov;

    public CoverageTransferRelation(CoverageData pCov) {
        this.cov = (CoverageData)Preconditions.checkNotNull((Object)pCov);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        this.handleEdge(pCfaEdge);
        return Collections.singleton(pElement);
    }

    private void handleEdge(CFAEdge pEdge) {
        this.cov.addVisitedEdge(pEdge);
        if (pEdge.getPredecessor() instanceof FunctionEntryNode) {
            this.cov.addVisitedFunction((FunctionEntryNode)pEdge.getPredecessor());
        }
    }
}

