/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.datarace;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.cpa.datarace.LockRelease;
import org.sosy_lab.cpachecker.cpa.datarace.MemoryAccess;
import org.sosy_lab.cpachecker.cpa.datarace.ThreadInfo;
import org.sosy_lab.cpachecker.cpa.datarace.ThreadSynchronization;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

public class DataRaceState
implements AbstractQueryableState {
    private static final String PROPERTY_DATA_RACE = "data-race";
    private final ImmutableSet<MemoryAccess> memoryAccesses;
    private final ImmutableSet<MemoryAccess> accessesWithSubsequentWrites;
    private final ImmutableMap<String, ThreadInfo> threadInfo;
    private final ImmutableSet<ThreadSynchronization> threadSynchronizations;
    private final ImmutableSetMultimap<String, String> heldLocks;
    private final ImmutableSet<LockRelease> lastReleases;
    private final boolean hasDataRace;

    DataRaceState(Map<String, ThreadInfo> pThreadInfo, boolean pHasDataRace) {
        this((Set<MemoryAccess>)ImmutableSet.of(), (Set<MemoryAccess>)ImmutableSet.of(), pThreadInfo, (Set<ThreadSynchronization>)ImmutableSet.of(), (SetMultimap<String, String>)ImmutableSetMultimap.of(), (Set<LockRelease>)ImmutableSet.of(), pHasDataRace);
    }

    DataRaceState(Set<MemoryAccess> pMemoryAccesses, Set<MemoryAccess> pAccessesWithSubsequentWrites, Map<String, ThreadInfo> pThreadInfo, Set<ThreadSynchronization> pThreadSynchronizations, SetMultimap<String, String> pHeldLocks, Set<LockRelease> pLastReleases, boolean pHasDataRace) {
        this.memoryAccesses = ImmutableSet.copyOf(pMemoryAccesses);
        this.accessesWithSubsequentWrites = ImmutableSet.copyOf(pAccessesWithSubsequentWrites);
        this.threadInfo = ImmutableMap.copyOf(pThreadInfo);
        this.threadSynchronizations = ImmutableSet.copyOf(pThreadSynchronizations);
        this.heldLocks = ImmutableSetMultimap.copyOf(pHeldLocks);
        this.lastReleases = ImmutableSet.copyOf(pLastReleases);
        this.hasDataRace = pHasDataRace;
    }

    ImmutableSet<MemoryAccess> getMemoryAccesses() {
        return this.memoryAccesses;
    }

    Set<MemoryAccess> getAccessesWithSubsequentWrites() {
        return this.accessesWithSubsequentWrites;
    }

    Map<String, ThreadInfo> getThreadInfo() {
        return this.threadInfo;
    }

    Set<ThreadSynchronization> getThreadSynchronizations() {
        return this.threadSynchronizations;
    }

    public ImmutableSetMultimap<String, String> getHeldLocks() {
        return this.heldLocks;
    }

    public Set<LockRelease> getLastReleases() {
        return this.lastReleases;
    }

    Set<String> getLocksForThread(String threadId) {
        return this.heldLocks.get((Object)threadId);
    }

    @Nullable LockRelease getLastReleaseForLock(String lock) {
        for (LockRelease release : this.lastReleases) {
            if (!release.getLockId().equals(lock)) continue;
            return release;
        }
        return null;
    }

    boolean hasDataRace() {
        return this.hasDataRace;
    }

    @Override
    public String getCPAName() {
        return "DataRaceCPA";
    }

    @Override
    public boolean checkProperty(String property) throws InvalidQueryException {
        if (property.equals(PROPERTY_DATA_RACE)) {
            return this.hasDataRace();
        }
        throw new InvalidQueryException("Invalid query: " + property);
    }

    @Override
    public String toString() {
        return this.memoryAccesses.size() + " memory access" + (this.memoryAccesses.size() == 1 ? "" : "es") + ", " + this.threadSynchronizations.size() + " thread synchronization" + (this.threadSynchronizations.size() == 1 ? "" : "s");
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (!(pO instanceof DataRaceState)) {
            return false;
        }
        DataRaceState that = (DataRaceState)pO;
        return this.hasDataRace == that.hasDataRace && this.memoryAccesses.equals(that.memoryAccesses) && this.accessesWithSubsequentWrites.equals(that.accessesWithSubsequentWrites) && this.threadInfo.equals(that.threadInfo) && this.threadSynchronizations.equals(that.threadSynchronizations) && this.heldLocks.equals(that.heldLocks) && this.lastReleases.equals(that.lastReleases);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.memoryAccesses, this.accessesWithSubsequentWrites, this.threadInfo, this.threadSynchronizations, this.heldLocks, this.lastReleases, this.hasDataRace);
    }
}

