/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.datarace;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.datarace.DataRaceState;
import org.sosy_lab.cpachecker.cpa.datarace.LockRelease;
import org.sosy_lab.cpachecker.cpa.datarace.MemoryAccess;
import org.sosy_lab.cpachecker.cpa.datarace.MemoryAccessExtractor;
import org.sosy_lab.cpachecker.cpa.datarace.ThreadInfo;
import org.sosy_lab.cpachecker.cpa.datarace.ThreadSynchronization;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class DataRaceTransferRelation
extends SingleEdgeTransferRelation {
    private final MemoryAccessExtractor memoryAccessExtractor = new MemoryAccessExtractor();

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        return ImmutableSet.of((Object)pState);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, Iterable<AbstractState> otherStates, @Nullable CFAEdge cfaEdge, Precision precision) throws CPATransferException, InterruptedException {
        if (cfaEdge == null) {
            return ImmutableSet.of((Object)pState);
        }
        DataRaceState state = (DataRaceState)pState;
        Map<String, ThreadInfo> threadInfo = state.getThreadInfo();
        ImmutableSet.Builder strengthenedStates = ImmutableSet.builder();
        ImmutableSet.Builder synchronizationBuilder = ImmutableSet.builder();
        synchronizationBuilder.addAll(state.getThreadSynchronizations());
        for (ThreadingState threadingState : AbstractStates.projectToType(otherStates, ThreadingState.class)) {
            Object lock2;
            Set<String> threadIds = threadingState.getThreadIds();
            String activeThread = this.getActiveThread(cfaEdge, threadingState);
            assert (Objects.equals(activeThread, threadInfo.get(activeThread).getThreadId()));
            ImmutableMap<String, ThreadInfo> newThreadInfo = this.updateThreadInfo(threadInfo, threadIds, activeThread, (ImmutableSet.Builder<ThreadSynchronization>)synchronizationBuilder);
            if (newThreadInfo.values().stream().filter(i -> i.isRunning()).count() == 1L) {
                strengthenedStates.add((Object)new DataRaceState((Map<String, ThreadInfo>)newThreadInfo, state.hasDataRace()));
                continue;
            }
            Set<String> activeThreadLocks = threadingState.getLocksForThread(activeThread);
            ImmutableSetMultimap<String, String> heldLocks = this.updateHeldLocks(state, activeThread, activeThreadLocks);
            ImmutableSet<LockRelease> lastReleases = this.updateLastReleases(state, activeThread, activeThreadLocks, threadInfo);
            for (Object lock2 : activeThreadLocks) {
                LockRelease lastRelease;
                if (state.getLocksForThread(activeThread).contains(lock2) || (lastRelease = state.getLastReleaseForLock((String)lock2)) == null || lastRelease.getThreadId().equals(activeThread)) continue;
                synchronizationBuilder.add((Object)new ThreadSynchronization(lastRelease.getThreadId(), activeThread, lastRelease.getAccessEpoch(), threadInfo.get(activeThread).getEpoch()));
            }
            Set<MemoryAccess> newMemoryAccesses = this.memoryAccessExtractor.getNewAccesses(threadInfo.get(activeThread), cfaEdge, activeThreadLocks);
            lock2 = newMemoryAccesses.iterator();
            while (lock2.hasNext()) {
                MemoryAccess newAccess = (MemoryAccess)lock2.next();
                if (!newAccess.isOverapproximating()) continue;
                throw new CPATransferException("DataRaceCPA does not support pointer analysis");
            }
            ImmutableSet.Builder memoryAccessBuilder = ImmutableSet.builder();
            ImmutableSet.Builder<MemoryAccess> subsequentWritesBuilder = this.prepareSubsequentWritesBuilder(state, threadIds);
            for (MemoryAccess access : state.getMemoryAccesses()) {
                if (!threadIds.contains(access.getThreadId())) continue;
                memoryAccessBuilder.add((Object)access);
                if (!access.isWrite() || state.getAccessesWithSubsequentWrites().contains(access)) continue;
                for (MemoryAccess newAccess : newMemoryAccesses) {
                    if (!access.mightAccessSameLocationAs(newAccess)) continue;
                    if (newAccess.isWrite()) {
                        subsequentWritesBuilder.add((Object)access);
                        continue;
                    }
                    if (access.getThreadId().equals(newAccess.getThreadId()) || Sets.intersection(access.getLocks(), newAccess.getLocks()).isEmpty()) continue;
                    synchronizationBuilder.add((Object)new ThreadSynchronization(access.getThreadId(), newAccess.getThreadId(), access.getAccessEpoch(), newAccess.getAccessEpoch()));
                }
            }
            boolean hasDataRace = state.hasDataRace();
            ImmutableSet threadSynchronizations = synchronizationBuilder.build();
            block5: for (MemoryAccess access : memoryAccessBuilder.build()) {
                if (hasDataRace) break;
                if (access.getThreadId().equals(activeThread)) continue;
                for (MemoryAccess newAccess : newMemoryAccesses) {
                    if (!access.mightAccessSameLocationAs(newAccess) || !access.isWrite() && !newAccess.isWrite() || !Sets.intersection(access.getLocks(), newAccess.getLocks()).isEmpty() || access.happensBefore(newAccess, (Set<ThreadSynchronization>)threadSynchronizations)) continue;
                    hasDataRace = true;
                    continue block5;
                }
            }
            strengthenedStates.add((Object)new DataRaceState((Set<MemoryAccess>)memoryAccessBuilder.addAll(newMemoryAccesses).build(), (Set<MemoryAccess>)subsequentWritesBuilder.build(), (Map<String, ThreadInfo>)newThreadInfo, (Set<ThreadSynchronization>)threadSynchronizations, (SetMultimap<String, String>)heldLocks, (Set<LockRelease>)lastReleases, hasDataRace));
        }
        return strengthenedStates.build();
    }

    private ImmutableSet.Builder<MemoryAccess> prepareSubsequentWritesBuilder(DataRaceState current, Set<String> threadIds) {
        ImmutableSet.Builder subsequentWritesBuilder = ImmutableSet.builder();
        for (MemoryAccess access : current.getAccessesWithSubsequentWrites()) {
            if (!threadIds.contains(access.getThreadId())) continue;
            subsequentWritesBuilder.add((Object)access);
        }
        return subsequentWritesBuilder;
    }

    private ImmutableSetMultimap<String, String> updateHeldLocks(DataRaceState state, String activeThread, Set<String> activeThreadLocks) {
        ImmutableSetMultimap.Builder newHeldLocks = ImmutableSetMultimap.builder();
        for (String lock : activeThreadLocks) {
            newHeldLocks.put((Object)activeThread, (Object)lock);
        }
        for (Map.Entry entry : state.getHeldLocks().entries()) {
            if (((String)entry.getKey()).equals(activeThread)) continue;
            newHeldLocks.put(entry);
        }
        return newHeldLocks.build();
    }

    private ImmutableSet<LockRelease> updateLastReleases(DataRaceState state, String activeThread, Set<String> activeThreadLocks, Map<String, ThreadInfo> threadInfo) {
        ImmutableSet.Builder newReleases = ImmutableSet.builder();
        for (String lock : state.getLocksForThread(activeThread)) {
            if (activeThreadLocks.contains(lock) || lock.equals("__CPAchecker_local_access_lock__")) continue;
            newReleases.add((Object)new LockRelease(lock, activeThread, threadInfo.get(activeThread).getEpoch()));
        }
        for (LockRelease release : state.getLastReleases()) {
            if (Sets.symmetricDifference(activeThreadLocks, state.getLocksForThread(activeThread)).contains((Object)release.getLockId())) continue;
            newReleases.add((Object)release);
        }
        return newReleases.build();
    }

    private ImmutableMap<String, ThreadInfo> updateThreadInfo(Map<String, ThreadInfo> threadInfo, Set<String> threadIds, String activeThread, ImmutableSet.Builder<ThreadSynchronization> threadSynchronizations) {
        Sets.SetView added = Sets.difference(threadIds, threadInfo.keySet());
        assert (added.size() < 2) : "Multiple thread creations in same step not supported";
        Sets.SetView removed = Sets.difference(threadInfo.keySet(), threadIds);
        assert (!removed.contains(activeThread)) : "Thread active after join";
        ImmutableMap.Builder threadsBuilder = ImmutableMap.builder();
        if (!added.isEmpty()) {
            String threadId = (String)added.iterator().next();
            ThreadInfo addedThreadInfo = threadInfo.containsKey(threadId) ? new ThreadInfo(threadId, threadInfo.get(threadId).getEpoch() + 1, true) : new ThreadInfo(threadId, 0, true);
            threadsBuilder.put((Object)threadId, (Object)addedThreadInfo);
            threadSynchronizations.add((Object)new ThreadSynchronization(activeThread, threadId, threadInfo.get(activeThread).getEpoch() + 1, addedThreadInfo.getEpoch()));
        }
        for (Map.Entry<String, ThreadInfo> entry : threadInfo.entrySet()) {
            if (entry.getKey().equals(activeThread)) {
                threadsBuilder.put((Object)activeThread, (Object)new ThreadInfo(activeThread, entry.getValue().getEpoch() + 1, true));
                continue;
            }
            if (removed.contains(entry.getKey())) {
                threadsBuilder.put((Object)entry.getKey(), (Object)new ThreadInfo(entry.getKey(), entry.getValue().getEpoch(), false));
                continue;
            }
            if (added.contains(entry.getKey())) continue;
            threadsBuilder.put(entry);
        }
        return threadsBuilder.buildOrThrow();
    }

    private String getActiveThread(CFAEdge cfaEdge, ThreadingState threadingState) {
        for (String id : threadingState.getThreadIds()) {
            if (!Iterables.contains(threadingState.getThreadLocation(id).getIngoingEdges(), (Object)cfaEdge)) continue;
            return id;
        }
        throw new AssertionError((Object)"Unable to determine active thread");
    }
}

