/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.datarace;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.datarace.OverapproximatingMemoryLocation;
import org.sosy_lab.cpachecker.cpa.datarace.ThreadSynchronization;

class MemoryAccess {
    private final String threadId;
    private final OverapproximatingMemoryLocation memoryLocation;
    private final boolean isWrite;
    private final ImmutableSet<String> locks;
    private final CFAEdge edge;
    private final int accessEpoch;

    MemoryAccess(String pThreadId, OverapproximatingMemoryLocation pMemoryLocation, boolean pIsWrite, Set<String> pLocks, CFAEdge pEdge, int pAccessEpoch) {
        this.threadId = pThreadId;
        this.memoryLocation = pMemoryLocation;
        this.isWrite = pIsWrite;
        this.locks = ImmutableSet.copyOf(pLocks);
        this.edge = pEdge;
        this.accessEpoch = pAccessEpoch;
    }

    String getThreadId() {
        return this.threadId;
    }

    boolean isWrite() {
        return this.isWrite;
    }

    Set<String> getLocks() {
        return this.locks;
    }

    int getAccessEpoch() {
        return this.accessEpoch;
    }

    boolean isOverapproximating() {
        return this.memoryLocation.isAmbiguous() || !this.memoryLocation.isPrecise();
    }

    boolean mightAccessSameLocationAs(MemoryAccess other) {
        return !Sets.intersection(this.memoryLocation.getMemoryLocations(), other.memoryLocation.getMemoryLocations()).isEmpty();
    }

    boolean happensBefore(MemoryAccess other, Set<ThreadSynchronization> threadSynchronizations) {
        if (this.threadId.equals(other.threadId)) {
            return this.accessEpoch <= other.accessEpoch;
        }
        HashSet<ThreadSynchronization> relevantSynchronizations = new HashSet<ThreadSynchronization>();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (ThreadSynchronization synchronization : threadSynchronizations) {
                if (relevantSynchronizations.contains(synchronization) || !this.isRelevant(synchronization, relevantSynchronizations)) continue;
                relevantSynchronizations.add(synchronization);
                changed = true;
            }
        }
        for (ThreadSynchronization synchronization : relevantSynchronizations) {
            if (!synchronization.getReadThread().equals(other.threadId) || synchronization.getReadEpoch() > other.accessEpoch) continue;
            return true;
        }
        return false;
    }

    private boolean isRelevant(ThreadSynchronization threadSynchronization, Set<ThreadSynchronization> relevantSynchronizations) {
        if (threadSynchronization.getWriteThread().equals(this.threadId)) {
            return threadSynchronization.getWriteEpoch() >= this.accessEpoch;
        }
        for (ThreadSynchronization relevantSynchronization : relevantSynchronizations) {
            if (!relevantSynchronization.getReadThread().equals(threadSynchronization.getWriteThread()) || relevantSynchronization.getReadEpoch() > threadSynchronization.getWriteEpoch()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "MemoryAccess{threadId='" + this.threadId + "', memoryLocation=" + this.memoryLocation + ", isWrite=" + this.isWrite + ", edge=" + this.edge + "}";
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (!(pO instanceof MemoryAccess)) {
            return false;
        }
        MemoryAccess access = (MemoryAccess)pO;
        return this.isWrite == access.isWrite && this.accessEpoch == access.accessEpoch && this.threadId.equals(access.threadId) && this.memoryLocation.equals(access.memoryLocation) && this.locks.equals(access.locks) && this.edge.equals(access.edge);
    }

    public int hashCode() {
        return Objects.hash(this.threadId, this.memoryLocation, this.isWrite, this.locks, this.edge, this.accessEpoch);
    }
}

