/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.datarace;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.APointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.datarace.MemoryAccess;
import org.sosy_lab.cpachecker.cpa.datarace.MemoryLocationExtractingVisitor;
import org.sosy_lab.cpachecker.cpa.datarace.OverapproximatingMemoryLocation;
import org.sosy_lab.cpachecker.cpa.datarace.ThreadInfo;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class MemoryAccessExtractor {
    private static final ImmutableSet<String> UNSUPPORTED_FUNCTIONS = ImmutableSet.of((Object)"pthread_mutex_trylock", (Object)"pthread_rwlock_rdlock", (Object)"pthread_rwlock_timedrdlock", (Object)"pthread_rwlock_timedwrlock", (Object)"pthread_rwlock_wrlock");

    /*
     * WARNING - void declaration
     */
    Set<MemoryAccess> getNewAccesses(ThreadInfo activeThreadInfo, CFAEdge edge, Set<String> locks) throws CPATransferException {
        String activeThread = activeThreadInfo.getThreadId();
        int epoch = activeThreadInfo.getEpoch();
        HashSet<OverapproximatingMemoryLocation> readLocationBuilder = new HashSet<OverapproximatingMemoryLocation>();
        HashSet<OverapproximatingMemoryLocation> writeLocationBuilder = new HashSet<OverapproximatingMemoryLocation>();
        ImmutableSet.Builder newAccessBuilder = ImmutableSet.builder();
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)edge;
                readLocationBuilder.addAll(this.getInvolvedVariableTypes(assumeEdge.getExpression(), (CFAEdge)assumeEdge));
                break;
            }
            case DeclarationEdge: {
                void var16_23;
                ADeclarationEdge declarationEdge = (ADeclarationEdge)edge;
                ADeclaration declaration = declarationEdge.getDeclaration();
                if (!(declaration instanceof CVariableDeclaration)) break;
                CVariableDeclaration variableDeclaration = (CVariableDeclaration)declaration;
                CInitializer initializer = variableDeclaration.getInitializer();
                CType type = variableDeclaration.getType();
                MemoryLocation memoryLocation = MemoryLocation.fromQualifiedName(variableDeclaration.getQualifiedName());
                if (type instanceof CPointerType) {
                    OverapproximatingMemoryLocation overapproximatingMemoryLocation = new OverapproximatingMemoryLocation(type);
                } else {
                    OverapproximatingMemoryLocation overapproximatingMemoryLocation = new OverapproximatingMemoryLocation((Set<MemoryLocation>)ImmutableSet.of((Object)memoryLocation), type, false, true);
                }
                newAccessBuilder.add((Object)new MemoryAccess(activeThread, (OverapproximatingMemoryLocation)var16_23, initializer != null, locks, edge, epoch));
                if (initializer == null) break;
                readLocationBuilder.addAll(this.getInvolvedVariableTypes(initializer, (CFAEdge)declarationEdge));
                break;
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)edge;
                String functionName = this.getFunctionName(functionCallEdge.getFunctionCall());
                if (UNSUPPORTED_FUNCTIONS.contains((Object)functionName)) {
                    throw new CPATransferException("DataRaceCPA does not support function " + functionName);
                }
                if (functionCallEdge.getFunctionCall() instanceof AFunctionCallAssignmentStatement) {
                    AFunctionCallAssignmentStatement functionCallAssignmentStatement = (AFunctionCallAssignmentStatement)functionCallEdge.getFunctionCall();
                    readLocationBuilder.addAll(this.getInvolvedVariableTypes(functionCallAssignmentStatement.getLeftHandSide(), (CFAEdge)functionCallEdge));
                    for (AExpression aExpression : functionCallAssignmentStatement.getFunctionCallExpression().getParameterExpressions()) {
                        readLocationBuilder.addAll(this.getInvolvedVariableTypes(aExpression, (CFAEdge)functionCallEdge));
                    }
                } else {
                    for (AExpression aExpression : functionCallEdge.getArguments()) {
                        readLocationBuilder.addAll(this.getInvolvedVariableTypes(aExpression, (CFAEdge)functionCallEdge));
                    }
                }
                break;
            }
            case ReturnStatementEdge: {
                AReturnStatementEdge returnStatementEdge = (AReturnStatementEdge)edge;
                if (!returnStatementEdge.getExpression().isPresent()) break;
                AExpression aExpression = returnStatementEdge.getExpression().get();
                readLocationBuilder.addAll(this.getInvolvedVariableTypes(aExpression, (CFAEdge)returnStatementEdge));
                break;
            }
            case StatementEdge: {
                String functionName;
                AStatementEdge aStatementEdge = (AStatementEdge)edge;
                AStatement aStatement = aStatementEdge.getStatement();
                if (aStatement instanceof AExpressionAssignmentStatement) {
                    AExpressionAssignmentStatement expressionAssignmentStatement = (AExpressionAssignmentStatement)aStatement;
                    writeLocationBuilder.addAll(this.getInvolvedVariableTypes(expressionAssignmentStatement.getLeftHandSide(), (CFAEdge)aStatementEdge));
                    readLocationBuilder.addAll(this.getInvolvedVariableTypes(expressionAssignmentStatement.getRightHandSide(), (CFAEdge)aStatementEdge));
                    break;
                }
                if (aStatement instanceof AExpressionStatement) {
                    readLocationBuilder.addAll(this.getInvolvedVariableTypes(((AExpressionStatement)aStatement).getExpression(), (CFAEdge)aStatementEdge));
                    break;
                }
                if (aStatement instanceof AFunctionCallAssignmentStatement) {
                    AFunctionCallAssignmentStatement functionCallAssignmentStatement = (AFunctionCallAssignmentStatement)aStatement;
                    functionName = this.getFunctionName(functionCallAssignmentStatement);
                    if (UNSUPPORTED_FUNCTIONS.contains((Object)functionName)) {
                        throw new CPATransferException("DataRaceCPA does not support function " + functionName);
                    }
                    writeLocationBuilder.addAll(this.getInvolvedVariableTypes(functionCallAssignmentStatement.getLeftHandSide(), (CFAEdge)aStatementEdge));
                    AFunctionCallExpression functionCallExpression = functionCallAssignmentStatement.getFunctionCallExpression();
                    for (AExpression aExpression : functionCallExpression.getParameterExpressions()) {
                        readLocationBuilder.addAll(this.getInvolvedVariableTypes(aExpression, (CFAEdge)aStatementEdge));
                    }
                } else {
                    if (!(aStatement instanceof AFunctionCallStatement)) break;
                    AFunctionCallStatement functionCallStatement = (AFunctionCallStatement)aStatement;
                    functionName = this.getFunctionName(functionCallStatement);
                    if (UNSUPPORTED_FUNCTIONS.contains((Object)functionName)) {
                        throw new CPATransferException("DataRaceCPA does not support function " + functionName);
                    }
                    for (AExpression aExpression : functionCallStatement.getFunctionCallExpression().getParameterExpressions()) {
                        readLocationBuilder.addAll(this.getInvolvedVariableTypes(aExpression, (CFAEdge)aStatementEdge));
                    }
                }
                break;
            }
            case FunctionReturnEdge: 
            case BlankEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled edge type: " + edge.getEdgeType()));
            }
        }
        for (OverapproximatingMemoryLocation possibleLocations : readLocationBuilder) {
            newAccessBuilder.add((Object)new MemoryAccess(activeThread, possibleLocations, false, locks, edge, epoch));
        }
        for (OverapproximatingMemoryLocation possibleLocations : writeLocationBuilder) {
            newAccessBuilder.add((Object)new MemoryAccess(activeThread, possibleLocations, true, locks, edge, epoch));
        }
        return newAccessBuilder.build();
    }

    private Set<OverapproximatingMemoryLocation> getInvolvedVariableTypes(AExpression pExpression, CFAEdge pEdge) {
        if (!(pExpression instanceof CExpression)) {
            return ImmutableSet.of();
        }
        if (this.isAddressAccess(pExpression)) {
            return ImmutableSet.of();
        }
        CExpression expression = (CExpression)pExpression;
        MemoryLocationExtractingVisitor visitor = new MemoryLocationExtractingVisitor(pEdge.getSuccessor().getFunctionName());
        return expression.accept(visitor);
    }

    private Set<OverapproximatingMemoryLocation> getInvolvedVariableTypes(CInitializer pCInitializer, CFAEdge pCfaEdge) {
        if (pCInitializer instanceof CDesignatedInitializer) {
            return this.getInvolvedVariableTypes(((CDesignatedInitializer)pCInitializer).getRightHandSide(), pCfaEdge);
        }
        if (pCInitializer instanceof CInitializerExpression) {
            return this.getInvolvedVariableTypes(((CInitializerExpression)pCInitializer).getExpression(), pCfaEdge);
        }
        if (pCInitializer instanceof CInitializerList) {
            ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
            for (CInitializer initializer : ((CInitializerList)pCInitializer).getInitializers()) {
                resultBuilder.addAll(this.getInvolvedVariableTypes(initializer, pCfaEdge));
            }
            return resultBuilder.build();
        }
        throw new AssertionError((Object)("Unhandled C initializer:" + pCInitializer));
    }

    private boolean isAddressAccess(AExpression pExpression) {
        if (pExpression instanceof AUnaryExpression && ((AUnaryExpression)pExpression).getOperator().equals(CUnaryExpression.UnaryOperator.AMPER)) {
            return true;
        }
        return pExpression instanceof AIdExpression && pExpression.getExpressionType() instanceof CPointerType;
    }

    private String getFunctionName(AFunctionCall pFunctionCall) {
        APointerExpression pointerExpression;
        AFunctionCallExpression functionCallExpression = pFunctionCall.getFunctionCallExpression();
        if (functionCallExpression.getDeclaration() != null) {
            return functionCallExpression.getDeclaration().getName();
        }
        AExpression functionNameExpression = functionCallExpression.getFunctionNameExpression();
        if (functionNameExpression instanceof AIdExpression) {
            return ((AIdExpression)functionNameExpression).getName();
        }
        if (functionNameExpression instanceof AUnaryExpression) {
            AUnaryExpression unaryFunctionNameExpression = (AUnaryExpression)functionNameExpression;
            if (unaryFunctionNameExpression.getOperand() instanceof AIdExpression) {
                return ((AIdExpression)unaryFunctionNameExpression.getOperand()).getName();
            }
        } else if (functionNameExpression instanceof APointerExpression && (pointerExpression = (APointerExpression)functionNameExpression).getOperand() instanceof AIdExpression) {
            return ((AIdExpression)pointerExpression.getOperand()).getName();
        }
        throw new AssertionError((Object)"Unable to determine function name.");
    }
}

