/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.datarace;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.datarace.OverapproximatingMemoryLocation;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class MemoryLocationExtractingVisitor
implements CExpressionVisitor<Set<OverapproximatingMemoryLocation>, NoException> {
    private final String functionName;

    public MemoryLocationExtractingVisitor(String pFunctionName) {
        this.functionName = pFunctionName;
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CBinaryExpression pBinaryExpression) {
        return ImmutableSet.builder().addAll((Iterable)pBinaryExpression.getOperand1().accept(this)).addAll((Iterable)pBinaryExpression.getOperand2().accept(this)).build();
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CCastExpression pCastExpression) {
        return pCastExpression.getOperand().accept(this);
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CCharLiteralExpression pCharLiteralExpression) {
        return ImmutableSet.of();
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CFloatLiteralExpression pFloatLiteralExpression) throws NoException {
        return ImmutableSet.of();
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CIntegerLiteralExpression pIntegerLiteralExpression) {
        return ImmutableSet.of();
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CStringLiteralExpression pStringLiteralExpression) {
        return ImmutableSet.of();
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CTypeIdExpression pTypeIdExpression) {
        return ImmutableSet.of();
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CUnaryExpression pUnaryExpression) {
        return pUnaryExpression.getOperand().accept(this);
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CImaginaryLiteralExpression pImaginaryLiteralExpression) {
        return pImaginaryLiteralExpression.getValue().accept(this);
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CAddressOfLabelExpression pAddressOfLabelExpression) {
        return ImmutableSet.of();
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CArraySubscriptExpression pArraySubscriptExpression) {
        return ImmutableSet.of((Object)this.getMemoryLocation(pArraySubscriptExpression));
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CFieldReference pFieldReference) {
        return ImmutableSet.of((Object)this.getMemoryLocation(pFieldReference));
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CIdExpression pIdExpression) {
        return ImmutableSet.of((Object)this.getMemoryLocation(pIdExpression));
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CPointerExpression pPointerExpression) {
        return ImmutableSet.of((Object)this.getMemoryLocation(pPointerExpression));
    }

    @Override
    public Set<OverapproximatingMemoryLocation> visit(CComplexCastExpression pComplexCastExpression) {
        return pComplexCastExpression.getOperand().accept(this);
    }

    public OverapproximatingMemoryLocation getMemoryLocation(AExpression pExpression) {
        if (!(pExpression instanceof CExpression)) {
            throw new AssertionError((Object)"Only C expressions are supported");
        }
        CExpression expression = (CExpression)pExpression;
        CType type = expression.getExpressionType();
        HashSet<MemoryLocation> potentialLocations = new HashSet<MemoryLocation>();
        if (pExpression instanceof CIdExpression) {
            CSimpleDeclaration decl;
            CIdExpression var = (CIdExpression)pExpression;
            String varName = var.getName();
            boolean isLocal = false;
            if (!(var.getDeclaration() == null || (decl = var.getDeclaration()) instanceof CDeclaration && ((CDeclaration)decl).isGlobal() || decl instanceof CEnumType.CEnumerator)) {
                isLocal = true;
            }
            if (isLocal) {
                potentialLocations.add(MemoryLocation.forLocalVariable(this.functionName, varName));
            } else {
                potentialLocations.add(MemoryLocation.parseExtendedQualifiedName(varName));
            }
        } else if (pExpression instanceof CFieldReference) {
            CFieldReference fieldRef = (CFieldReference)pExpression;
            Object varName = fieldRef.getFieldName();
            CExpression owner = fieldRef.getFieldOwner();
            if (fieldRef.isPointerDereference()) {
                return new OverapproximatingMemoryLocation(type);
            }
            OverapproximatingMemoryLocation ownerLocation = this.getMemoryLocation(owner);
            if (ownerLocation.isAmbiguous()) {
                return new OverapproximatingMemoryLocation(type);
            }
            varName = ownerLocation.getMemoryLocations().iterator().next() + "." + (String)varName;
            potentialLocations.add(MemoryLocation.fromQualifiedName((String)varName));
        } else {
            if (pExpression instanceof CArraySubscriptExpression) {
                return new OverapproximatingMemoryLocation(type);
            }
            if (pExpression instanceof CPointerExpression) {
                CPointerExpression pointerExpression = (CPointerExpression)pExpression;
                if (pointerExpression.getOperand() instanceof CIdExpression) {
                    type = ((CIdExpression)pointerExpression.getOperand()).getDeclaration().getType();
                }
                return new OverapproximatingMemoryLocation(type);
            }
            if (pExpression instanceof CCastExpression) {
                CCastExpression cast = (CCastExpression)pExpression;
                return this.getMemoryLocation(cast.getOperand());
            }
            potentialLocations.add(MemoryLocation.forLocalVariable(this.functionName, pExpression.toString()));
        }
        if (type instanceof CPointerType) {
            return new OverapproximatingMemoryLocation(type);
        }
        assert (!potentialLocations.isEmpty());
        return new OverapproximatingMemoryLocation(potentialLocations, type, potentialLocations.size() > 1, true);
    }
}

