/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dca;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.dca.DCAState;
import org.sosy_lab.cpachecker.cpa.dca.DCATransferRelation;

public class DCACPA
extends AbstractSingleWrapperCPA {
    private final ControlAutomatonCPA automatonCPA;
    private final List<Automaton> automatonList;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(DCACPA.class);
    }

    public DCACPA(ConfigurableProgramAnalysis pCpa) {
        super(pCpa);
        Preconditions.checkArgument((boolean)(pCpa instanceof ControlAutomatonCPA));
        this.automatonCPA = (ControlAutomatonCPA)pCpa;
        this.automatonList = new ArrayList<Automaton>();
    }

    void addAutomaton(Automaton pAutomaton) {
        Preconditions.checkArgument((boolean)this.automatonList.add(pAutomaton), (Object)"The automaton is already available.");
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        ImmutableList initStates = (ImmutableList)this.automatonList.stream().map(this.automatonCPA::buildInitStateForAutomaton).collect(ImmutableList.toImmutableList());
        AutomatonState buechiState = (AutomatonState)super.getInitialState(pNode, pPartition);
        return new DCAState(buechiState, (List<AutomatonState>)initStates);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return new FlatLatticeDomain();
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new DCATransferRelation(this.automatonCPA.getTransferRelation());
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }
}

