/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dca;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.sosy_lab.common.MoreStrings;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.algorithm.termination.ClassVariables;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.LassoAnalysis;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.LassoAnalysisResult;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelation;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.RankingRelationBuilder;
import org.sosy_lab.cpachecker.core.algorithm.termination.lasso_analysis.construction.LassoBuilder;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.StronglyConnectedComponent;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.InterpolationAutomaton;
import org.sosy_lab.cpachecker.cpa.automaton.InterpolationAutomatonBuilder;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.cpa.dca.DCACPA;
import org.sosy_lab.cpachecker.cpa.dca.DCAStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.BlockFormulaStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManagerOptions;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionStatistics;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.SlicingAbstractionsUtils;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicateAbstractionsStorage;
import org.sosy_lab.cpachecker.cpa.predicate.persistence.PredicatePersistenceUtils;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.GraphUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AssignmentToPathAllocator;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.regions.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;

@Options(prefix="cpa.dca.refiner")
public class DCARefiner
implements Refiner,
StatisticsProvider,
AutoCloseable {
    private static final SolverContextFactory.Solvers SMTINTERPOL = SolverContextFactory.Solvers.SMTINTERPOL;
    private final ARGCPA argCPA;
    private final DCACPA dcaCPA;
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final DCAStatistics statistics;
    private final PathFormulaManager pathFormulaManager;
    private final ClassVariables variables;
    private final LassoAnalysis lassoAnalysis;
    private final LassoBuilder lassoBuilder;
    private final Solver solver;
    private final FormulaManagerView formulaManagerView;
    private final InterpolationManager interpolationManager;
    private final InterpolationAutomatonBuilder itpAutomatonBuilder;
    private final PredicateAbstractionManager predicateAbstractionManager;
    private final PathChecker pathChecker;
    private int curRefinementIteration = 0;
    private ReachedSet reached;
    @Option(secure=true, description="Skip the analysis (including the refinement) entirely, so that the ARG is left unmodified. This is used for debugging purposes.")
    private boolean skipAnalysis = false;
    @Option(secure=true, description="If set to true, all infeasible dummy states will be kept in the ARG.")
    private boolean keepInfeasibleStates = false;
    @Option(secure=true, description="The max amount of refinements for the trace abstraction algorithm. Setting it to 0 leads to an analysis of the ARG without executing any refinements. This is used for debugging purposes.")
    private int maxRefinementIterations = 10;
    @Option(secure=true, name="dotExport", description="Export the trace-abtraction automaton to a file in dot-format.")
    private boolean export = false;
    @Option(secure=true, name="dotExportFile", description="Filename that the interpolation automaton will be written to. %s will get replaced by the automaton name.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate dotExportFile = PathTemplate.ofFormatString((String)"%s.dot");

    private DCARefiner(ARGCPA pArgCpa, DCACPA pDcaCpa, FormulaManagerView pPredFormulaManagerView, CFA pCfa, LogManager pLogger, ShutdownNotifier pNotifier, Configuration pConfig) throws InvalidConfigurationException {
        PredicateAbstractionsStorage abstractionStorage;
        pConfig.inject((Object)this);
        this.argCPA = (ARGCPA)Preconditions.checkNotNull((Object)pArgCpa);
        this.dcaCPA = (DCACPA)Preconditions.checkNotNull((Object)pDcaCpa);
        this.cfa = (CFA)Preconditions.checkNotNull((Object)pCfa);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pNotifier);
        this.statistics = new DCAStatistics(pDcaCpa);
        this.variables = ClassVariables.collectDeclarations(this.cfa);
        SolverContext solverContext = SolverContextFactory.createSolverContext((Configuration)pConfig, (LogManager)pLogger, (ShutdownNotifier)pNotifier, (SolverContextFactory.Solvers)SMTINTERPOL);
        AbstractFormulaManager formulaManager = (AbstractFormulaManager)solverContext.getFormulaManager();
        SolverContextFactory solverContextFactory = new SolverContextFactory(pConfig, pLogger, pNotifier);
        this.solver = Solver.create(solverContextFactory, SMTINTERPOL, solverContext, pConfig, pLogger);
        this.formulaManagerView = this.solver.getFormulaManager();
        this.pathFormulaManager = new PathFormulaManagerImpl(this.formulaManagerView, pConfig, pLogger, pNotifier, pCfa, AnalysisDirection.FORWARD);
        Supplier<ProverEnvironment> proverEnvironmentSupplier = () -> this.solver.newProverEnvironment(new SolverContext.ProverOptions[0]);
        this.lassoBuilder = new LassoBuilder(pConfig, pLogger, pNotifier, formulaManager, this.formulaManagerView, proverEnvironmentSupplier, this.pathFormulaManager, this.statistics);
        RankingRelationBuilder rankingRelationBuilder = new RankingRelationBuilder(pCfa.getMachineModel(), pLogger, this.formulaManagerView, formulaManager.getFormulaCreator());
        this.lassoAnalysis = LassoAnalysis.create(this.lassoBuilder, rankingRelationBuilder, solverContext, pLogger, pConfig, pNotifier, this.statistics);
        this.interpolationManager = new InterpolationManager(this.pathFormulaManager, this.solver, this.cfa.getLoopStructure(), this.cfa.getVarClassification(), pConfig, pNotifier, pLogger);
        SymbolicRegionManager regionManager = new SymbolicRegionManager(this.solver);
        AbstractionManager abstractionManager = new AbstractionManager(regionManager, pConfig, pLogger, this.solver);
        PredicateAbstractionManagerOptions abstractionOptions = new PredicateAbstractionManagerOptions(pConfig);
        try {
            abstractionStorage = new PredicateAbstractionsStorage(abstractionOptions.getReuseAbstractionsFrom(), this.logger, this.solver.getFormulaManager(), null);
        }
        catch (PredicatePersistenceUtils.PredicateParsingFailedException e) {
            throw new InvalidConfigurationException(e.getMessage(), (Throwable)e);
        }
        this.predicateAbstractionManager = new PredicateAbstractionManager(abstractionManager, this.pathFormulaManager, this.solver, abstractionOptions, new WeakeningOptions(pConfig), abstractionStorage, pLogger, pNotifier, new PredicateAbstractionStatistics(), InvariantSupplier.TrivialInvariantSupplier.INSTANCE);
        this.itpAutomatonBuilder = new InterpolationAutomatonBuilder(this.formulaManagerView, this.logger, pPredFormulaManagerView, this.predicateAbstractionManager, false);
        AssignmentToPathAllocator pathAllocator = new AssignmentToPathAllocator(pConfig, this.shutdownNotifier, this.logger, this.cfa.getMachineModel());
        this.pathChecker = new PathChecker(pConfig, this.logger, this.pathFormulaManager, this.solver, pathAllocator);
    }

    public static Refiner create(ConfigurableProgramAnalysis pCpa, LogManager pLogger, ShutdownNotifier pNotifier) throws InvalidConfigurationException {
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, DCARefiner.class);
        DCACPA dcaCpa = CPAs.retrieveCPAOrFail(pCpa, DCACPA.class, DCARefiner.class);
        PredicateCPA predicateCpa = CPAs.retrieveCPAOrFail(pCpa, PredicateCPA.class, DCARefiner.class);
        CFA cfa = predicateCpa.getCfa();
        FormulaManagerView predFormulaManagerView = predicateCpa.getSolver().getFormulaManager();
        Configuration config = Configuration.builder().copyFrom(predicateCpa.getConfiguration()).setOption("solver.solver", SMTINTERPOL.name()).build();
        Configuration adjustedConfig = Solver.adjustConfigForSolver(config);
        return new DCARefiner(argCpa, dcaCpa, predFormulaManagerView, cfa, pLogger, pNotifier, adjustedConfig);
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        boolean bl;
        if (this.skipAnalysis) {
            this.logger.log(Level.INFO, new Object[]{"Received flag to skip the refinement. Aborting analysis..."});
            return false;
        }
        this.logger.log(Level.INFO, new Object[]{"Starting to analyse the reached set..."});
        this.statistics.refinementTotalTimer.start();
        try {
            bl = this.performRefinement0(pReached);
        }
        catch (Throwable throwable) {
            this.statistics.refinementTotalTimer.stop();
            this.logger.log(Level.INFO, new Object[]{"Finished analysing the reached set."});
            throw throwable;
        }
        this.statistics.refinementTotalTimer.stop();
        this.logger.log(Level.INFO, new Object[]{"Finished analysing the reached set."});
        return bl;
    }

    private boolean performRefinement0(ReachedSet pReached) throws InterruptedException, CPAException {
        this.reached = pReached;
        this.logger.logf(Level.INFO, "Current iteration: %d", new Object[]{this.curRefinementIteration});
        ImmutableList infeasibleDummyStates = FluentIterable.from((Iterable)pReached).filter(x -> AbstractStates.extractStateByType(x, PredicateAbstractState.class) instanceof PredicateAbstractState.InfeasibleDummyState).filter(ARGState.class).toList();
        if (!this.keepInfeasibleStates) {
            this.logger.logf(Level.INFO, "Found %d unsat predicates while building the ARG. Removing them from it.", new Object[]{infeasibleDummyStates.size()});
            for (ARGState state : infeasibleDummyStates) {
                this.removeInfeasibleStatesFromARG(state);
            }
        } else {
            this.logger.logf(Level.INFO, "Not removing any infeasible predicate dummy states. There are in total %d of such states", new Object[]{infeasibleDummyStates.size()});
        }
        this.shutdownNotifier.shutdownIfNecessary();
        Set SCCs = (Set)GraphUtils.retrieveSCCs(this.reached).stream().filter(x -> x.getNodes().size() > 1).filter(StronglyConnectedComponent::hasTargetStates).collect(ImmutableSet.toImmutableSet());
        this.logger.logf(Level.INFO, "Found %d SCC(s) with target-states", new Object[]{SCCs.size()});
        boolean terminationFunctionFound = false;
        for (StronglyConnectedComponent scc : SCCs) {
            this.shutdownNotifier.shutdownIfNecessary();
            List<List<ARGState>> sscCycles = GraphUtils.retrieveSimpleCycles(scc.getNodes(), this.reached);
            this.logger.logf(Level.INFO, "Found %d cycle(s) in current SCC", new Object[]{sscCycles.size()});
            for (List<ARGState> cycle : sscCycles) {
                this.logger.logf(Level.INFO, "Analyzing cycle: %s\n", new Object[]{this.lazyPrintNodes(cycle)});
                assert (cycle.stream().anyMatch(ARGState::isTarget)) : "Cycle does not contain a target";
                this.shutdownNotifier.shutdownIfNecessary();
                ARGState firstNodeInCycle = cycle.iterator().next();
                ARGPath stemPath = ARGUtils.getShortestPathTo(firstNodeInCycle);
                ARGPath loopPath = new ARGPath(cycle);
                assert (loopPath.asStatesList().equals(cycle)) : String.format("Nodes in cycle are not consistent with nodes in the ARGPath%n(Nodes in cycle: %s)%n(Nodes in loop: %s)", this.lazyPrintNodes(cycle), this.lazyPrintNodes(loopPath));
                this.logger.logf(Level.INFO, "Path to cycle: %s\n", new Object[]{this.lazyPrintNodes(stemPath)});
                try {
                    PathFormula loopPathFormula;
                    List<PathFormula> stemPathFormulaList = SlicingAbstractionsUtils.getFormulasForPath(this.pathFormulaManager, this.solver, (ARGState)this.reached.getFirstState(), stemPath.asStatesList(), SlicingAbstractionsUtils.AbstractionPosition.NONE);
                    PathFormula stemPathFormula = this.pathFormulaManager.makeConjunction(stemPathFormulaList);
                    if (this.solver.isUnsat(stemPathFormula.getFormula())) {
                        this.logger.log(Level.INFO, new Object[]{"Found unsat predicates in stem"});
                        if (!this.refineFinitePrefixes(stemPath, stemPathFormulaList)) continue;
                        return true;
                    }
                    List<PathFormula> loopPathFormulaList = SlicingAbstractionsUtils.getFormulasForPath(this.pathFormulaManager, this.solver, firstNodeInCycle, loopPath.asStatesList(), stemPathFormula.getSsa(), ((PathFormula)Iterables.getLast(stemPathFormulaList)).getPointerTargetSet(), SlicingAbstractionsUtils.AbstractionPosition.NONE);
                    PathFormula pathFormula = loopPathFormula = loopPathFormulaList.isEmpty() ? this.pathFormulaManager.makeEmptyPathFormulaWithContextFrom(stemPathFormula) : this.pathFormulaManager.makeConjunction(loopPathFormulaList);
                    if (this.solver.isUnsat(loopPathFormula.getFormula())) {
                        this.logger.log(Level.INFO, new Object[]{"Found unsat predicates in loop"});
                        if (!this.refineFinitePrefixes(loopPath, loopPathFormulaList)) continue;
                        return true;
                    }
                    ImmutableList stemAndLoopStates = ImmutableList.builder().addAll(stemPath.asStatesList()).addAll((Iterable)loopPath.asStatesList().subList(1, loopPath.asStatesList().size())).build();
                    ARGPath stemAndLoopPath = new ARGPath((List<ARGState>)stemAndLoopStates);
                    ImmutableList stemAndLoopPathFormulaList = FluentIterable.from(stemPathFormulaList).append(Iterables.skip(loopPathFormulaList, (int)1)).toList();
                    BooleanFormula stemAndLoopBF = this.pathFormulaManager.makeConjunction((List<PathFormula>)stemAndLoopPathFormulaList).getFormula();
                    if (this.solver.isUnsat(stemAndLoopBF)) {
                        this.logger.log(Level.INFO, new Object[]{"Found unsat predicates in stem concatenated with loop"});
                        if (!this.refineFinitePrefixes(stemAndLoopPath, (List<PathFormula>)stemAndLoopPathFormulaList)) continue;
                        return true;
                    }
                    LassoBuilder.StemAndLoop stemAndLoop = new LassoBuilder.StemAndLoop(stemPathFormula, loopPathFormula, stemPathFormula.getSsa());
                    LassoBuilder.Dnf stemDnf = this.lassoBuilder.toDnf(stemAndLoop.getStem());
                    LassoBuilder.Dnf loopDnf = this.lassoBuilder.toDnf(stemAndLoop.getLoop(), stemDnf.getUfEliminationResult());
                    LoopStructure loopStructure = this.cfa.getLoopStructure().orElseThrow();
                    ImmutableList cfaNodesOfCurrentCycle = AbstractStates.extractLocations(cycle).toList();
                    ImmutableList loops = FluentIterable.from(loopStructure.getAllLoops()).filter(x -> x.getLoopNodes().containsAll((Collection)cfaNodesOfCurrentCycle)).toList();
                    LoopStructure.Loop loop = (LoopStructure.Loop)loops.iterator().next();
                    Set<CVariableDeclaration> varDeclarations = this.variables.getDeclarations(loop);
                    ImmutableMap varDeclarationsForName = Maps.uniqueIndex(varDeclarations, AVariableDeclaration::getQualifiedName);
                    this.shutdownNotifier.shutdownIfNecessary();
                    Collection<Lasso> lassos = this.lassoBuilder.createLassos(stemAndLoop, stemDnf, loopDnf, (ImmutableMap<String, CVariableDeclaration>)varDeclarationsForName, false);
                    LassoAnalysisResult checkTermination = this.lassoAnalysis.checkTermination(loop, lassos, varDeclarations);
                    if (checkTermination.hasNonTerminationArgument()) {
                        NonTerminationArgument nonTerminationArgument = checkTermination.getNonTerminationArgument();
                        this.logger.logf(Level.INFO, "LassoRanker has found a non-termination argument: %s", new Object[]{nonTerminationArgument});
                        CounterexampleTraceInfo cexTraceInfo = this.interpolationManager.buildCounterexampleTrace(BlockFormulaStrategy.BlockFormulas.createFromPathFormulas((List<PathFormula>)stemAndLoopPathFormulaList), (List<AbstractState>)Collections3.transformedImmutableListCopy((Collection)stemAndLoopStates, PredicateAbstractState::getPredicateState), Optional.of(stemAndLoopPath));
                        CounterexampleInfo cexInfo = this.pathChecker.handleFeasibleCounterexample(cexTraceInfo, stemAndLoopPath);
                        stemAndLoopPath.getLastState().addCounterexampleInformation(cexInfo);
                    }
                    if (checkTermination.hasTerminationArgument()) {
                        RankingRelation terminationArgument = checkTermination.getTerminationArgument();
                        this.logger.logf(Level.INFO, "LassoRanker has found a termination argument %s", new Object[]{terminationArgument.getSupportingInvariants().isEmpty() ? "" : "\nInvariants: " + terminationArgument.getSupportingInvariants()});
                        this.logger.logf(Level.WARNING, "Refinement for termination arguments is not implemented yet. The result might be imprecise.", new Object[0]);
                        terminationFunctionFound = true;
                    }
                    if (!checkTermination.isUnknown()) continue;
                    this.logger.logf(Level.WARNING, "Argument from LassoRanker is unknown. The result might be unsound", new Object[0]);
                }
                catch (TermException | SMTLIBException | IOException | SolverException e) {
                    throw new CPAException(e.getMessage(), e);
                }
            }
        }
        if (terminationFunctionFound) {
            return false;
        }
        this.logger.log(Level.INFO, new Object[]{"No cycles left to check, continuing with simple paths (paths with loose ends)."});
        ImmutableList targetStatesWithoutChildren = AbstractStates.getTargetStates(this.reached).filter(ARGState.class).filter(x -> x.getChildren().isEmpty()).toList();
        if (targetStatesWithoutChildren.isEmpty()) {
            this.logger.log(Level.INFO, new Object[]{"Did not found any finite paths that contain target states."});
        }
        for (ARGState stateWithoutChildren : targetStatesWithoutChildren) {
            ARGPath path = ARGUtils.getShortestPathTo(stateWithoutChildren);
            this.logger.logf(Level.INFO, "Path to last node: %s\n", new Object[]{this.lazyPrintNodes(path)});
            if (path.asStatesList().stream().anyMatch(arg_0 -> ((ImmutableList)infeasibleDummyStates).contains(arg_0))) {
                Verify.verify((boolean)this.keepInfeasibleStates);
                this.logger.logf(Level.INFO, "Path contains a predicate dummy state that has already been proven infeasible. Not performing a refinement due to the option  'keepInfeasibleStates' being set.", new Object[0]);
                continue;
            }
            List<PathFormula> pathFormulaList = SlicingAbstractionsUtils.getFormulasForPath(this.pathFormulaManager, this.solver, (ARGState)this.reached.getFirstState(), path.asStatesList(), SlicingAbstractionsUtils.AbstractionPosition.NONE);
            try {
                if (!this.solver.isUnsat(this.pathFormulaManager.makeConjunction(pathFormulaList).getFormula())) {
                    continue;
                }
            }
            catch (SolverException e) {
                throw new CPAException(e.getMessage(), e);
            }
            if (this.refineFinitePrefixes(path, pathFormulaList)) {
                return true;
            }
            this.logger.log(Level.INFO, new Object[]{"Feasible errorpath with target states found."});
            CounterexampleTraceInfo cexTraceInfo = this.interpolationManager.buildCounterexampleTrace(BlockFormulaStrategy.BlockFormulas.createFromPathFormulas(pathFormulaList), (List<AbstractState>)Collections3.transformedImmutableListCopy(path.asStatesList(), PredicateAbstractState::getPredicateState), Optional.of(path));
            CounterexampleInfo cexInfo = this.pathChecker.handleFeasibleCounterexample(cexTraceInfo, path);
            path.getLastState().addCounterexampleInformation(cexInfo);
            return false;
        }
        this.logger.log(Level.INFO, new Object[]{"Finished checking the simple paths for targetstates."});
        return false;
    }

    private void removeInfeasibleStatesFromARG(ARGState pState) {
        Verify.verify((boolean)pState.getChildren().isEmpty());
        HashSet<ARGState> states = new HashSet<ARGState>();
        this.collectStatesToRemove(pState, states);
        this.logger.logf(Level.FINE, "Removing %d trailing state(s) that have ended in an infeasible state", new Object[]{states.size()});
        states.forEach(ARGState::removeFromARG);
        this.reached.removeAll(states);
    }

    private void collectStatesToRemove(ARGState pState, Collection<ARGState> pStatesToRemove) {
        Collection<ARGState> parents = pState.getParents();
        Verify.verify((!parents.isEmpty() ? 1 : 0) != 0);
        pStatesToRemove.add(pState);
        parents.stream().filter(x -> x.getChildren().size() == 1).filter(AbstractStates::isTargetState).forEach(x -> this.collectStatesToRemove((ARGState)x, pStatesToRemove));
    }

    private boolean refineFinitePrefixes(ARGPath pPath, List<PathFormula> pPathFormulaList) throws CPAException, InterruptedException {
        List interpolants = (List)this.interpolationManager.interpolate((List<BooleanFormula>)Collections3.transformedImmutableListCopy(pPathFormulaList, PathFormula::getFormula)).orElseThrow();
        this.logger.logf(Level.FINE, "Mapping of interpolants to arg-states:\n%s", new Object[]{this.lazyPrintItpToTransitionMapping(pPath, interpolants)});
        try {
            InterpolationAutomaton itpAutomaton = this.itpAutomatonBuilder.buildAutomatonFromPath(pPath, interpolants, this.curRefinementIteration);
            this.itpAutomatonBuilder.addAdditionalTransitions(itpAutomaton, pPath, interpolants);
            Automaton automaton = itpAutomaton.createAutomaton();
            if (this.export) {
                this.logger.log(Level.INFO, new Object[]{automaton});
                if (this.dotExportFile != null) {
                    try (Writer w = IO.openOutputFile((Path)this.dotExportFile.getPath(new Object[]{automaton.getName()}), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                        automaton.writeDotFile(w);
                    }
                    catch (IOException e) {
                        this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write the automaton to a DOT file");
                    }
                }
            }
            if (this.curRefinementIteration >= this.maxRefinementIterations) {
                this.logger.log(Level.WARNING, new Object[]{"Specified number of max refinements already exceeded. Skipping the refinement"});
                return false;
            }
            this.dcaCPA.addAutomaton(automaton);
            ++this.curRefinementIteration;
            this.reinitializeReachedSet();
        }
        catch (InvalidAutomatonException e) {
            throw new CPAException(e.getMessage(), e);
        }
        return true;
    }

    private Object lazyPrintItpToTransitionMapping(ARGPath pPath, List<BooleanFormula> pInterpolants) {
        return MoreStrings.lazyString(() -> Streams.zip(pPath.getStatePairs().stream(), pInterpolants.stream(), (statePair, itp) -> String.format("%d:%s -> %d:%s : %s", ((ARGState)statePair.getFirstNotNull()).getStateId(), AbstractStates.extractLocation((AbstractState)statePair.getFirstNotNull()), ((ARGState)statePair.getSecondNotNull()).getStateId(), AbstractStates.extractLocation((AbstractState)statePair.getSecondNotNull()), itp)).collect(Collectors.joining("\n")));
    }

    private void reinitializeReachedSet() throws InterruptedException {
        this.reached.clear();
        FunctionEntryNode mainFunction = this.cfa.getMainFunction();
        StateSpacePartition defaultPartition = StateSpacePartition.getDefaultPartition();
        AbstractState initialState = this.argCPA.getInitialState(mainFunction, defaultPartition);
        Precision initialPrecision = this.argCPA.getInitialPrecision(mainFunction, defaultPartition);
        this.reached.add(initialState, initialPrecision);
    }

    private Object lazyPrintNodes(ARGPath pStemPath) {
        return this.lazyPrintNodes((Collection<ARGState>)pStemPath.asStatesList());
    }

    private Object lazyPrintNodes(Collection<ARGState> pArgStates) {
        return MoreStrings.lazyString(() -> FluentIterable.from((Iterable)pArgStates).transform(x -> x.getStateId() + ":" + AbstractStates.extractLocation(x)).toString());
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    @Override
    public void close() {
        this.lassoAnalysis.close();
    }
}

