/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dca;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

public class DCAState
implements AbstractQueryableState,
Targetable,
Graphable,
Serializable,
AbstractStateWithAssumptions {
    private static final long serialVersionUID = -3454798281550882095L;
    private final AutomatonState buechiState;
    private final ImmutableList<AutomatonState> compositeStates;
    private final ImmutableList<AutomatonState> productStates;

    public DCAState(AutomatonState pBuechiState, List<AutomatonState> pCompositeStates) {
        this.buechiState = (AutomatonState)Preconditions.checkNotNull((Object)pBuechiState);
        this.compositeStates = ImmutableList.copyOf(pCompositeStates);
        this.productStates = new ImmutableList.Builder().add((Object)this.buechiState).addAll(this.compositeStates).build();
    }

    @Override
    public boolean isTarget() {
        return !this.productStates.isEmpty() && this.productStates.stream().allMatch(AutomatonState::isTarget);
    }

    @Override
    public @NonNull Set<Targetable.TargetInformation> getTargetInformation() throws IllegalStateException {
        Preconditions.checkArgument((boolean)this.isTarget());
        return (Set)this.productStates.stream().flatMap(x -> x.getTargetInformation().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public String getCPAName() {
        return "DCAState";
    }

    AutomatonState getBuechiState() {
        return this.buechiState;
    }

    List<AutomatonState> getCompositeStates() {
        return this.compositeStates;
    }

    public ImmutableList<AExpression> getAssumptions() {
        return (ImmutableList)this.productStates.stream().flatMap(x -> x.getAssumptions().stream()).distinct().collect(ImmutableList.toImmutableList());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.buechiState, this.compositeStates);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DCAState)) {
            return false;
        }
        DCAState other = (DCAState)obj;
        return Objects.equals(this.buechiState, other.buechiState) && Objects.equals(this.compositeStates, other.compositeStates);
    }

    @Override
    public String toString() {
        if (this.productStates.isEmpty()) {
            return "_empty_state_";
        }
        return FluentIterable.from(this.productStates).transform(AutomatonState::toString).filter(x -> !x.contains("init_state")).join(Joiner.on((String)"; "));
    }

    @Override
    public String toDOTLabel() {
        if (this.productStates.isEmpty()) {
            return "_empty_state_";
        }
        return FluentIterable.from(this.productStates).transform(AutomatonState::toDOTLabel).filter(x -> !x.contains("init_state")).join(Joiner.on((String)"\n"));
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        if (this.buechiState.getAssumptions().isEmpty()) {
            return true;
        }
        String predecessorStateBuechiExpressions = Joiner.on((String)"; ").join((Iterable)Collections2.transform(this.buechiState.getAssumptions(), AAstNode::toASTString));
        return predecessorStateBuechiExpressions.equals(pProperty);
    }
}

