/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dca;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferRelation;
import org.sosy_lab.cpachecker.cpa.dca.DCAState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class DCATransferRelation
extends SingleEdgeTransferRelation {
    private AutomatonTransferRelation automatonTR;

    public DCATransferRelation(AutomatonTransferRelation pAutomatonTransferRelation) {
        this.automatonTR = pAutomatonTransferRelation;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        Preconditions.checkArgument((boolean)(pState instanceof DCAState));
        DCAState state = (DCAState)pState;
        ArrayList<ImmutableSet> listOfStates = new ArrayList<ImmutableSet>();
        for (AutomatonState compositeState : state.getCompositeStates()) {
            ImmutableSet successorsStates = ImmutableSet.copyOf(this.automatonTR.getAbstractSuccessorsForEdge(compositeState, pPrecision, pCfaEdge));
            if (successorsStates.isEmpty()) {
                return ImmutableSet.of();
            }
            listOfStates.add(successorsStates);
        }
        Set cartesianProduct = Sets.cartesianProduct(listOfStates);
        ImmutableSet buechiSuccessorsStates = ImmutableSet.copyOf(this.automatonTR.getAbstractSuccessorsForEdge(state.getBuechiState(), pPrecision, pCfaEdge));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (List productStates : cartesianProduct) {
            for (AutomatonState buechiSuccessorState : buechiSuccessorsStates) {
                builder.add((Object)new DCAState(buechiSuccessorState, productStates));
            }
        }
        return builder.build();
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, Iterable<AbstractState> pOtherStates, @Nullable CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        Preconditions.checkArgument((boolean)(pState instanceof DCAState));
        ArrayList<ImmutableSet> listOfStates = new ArrayList<ImmutableSet>();
        DCAState state = (DCAState)pState;
        for (AutomatonState s : state.getCompositeStates()) {
            ImmutableSet strengthenResult = ImmutableSet.copyOf(this.automatonTR.strengthen(s, pOtherStates, pCfaEdge, pPrecision));
            if (strengthenResult.isEmpty()) {
                return ImmutableSet.of();
            }
            listOfStates.add(strengthenResult);
        }
        Set cartesianProduct = Sets.cartesianProduct(listOfStates);
        ImmutableSet buechiStrengthenResults = ImmutableSet.copyOf(this.automatonTR.strengthen(state.getBuechiState(), pOtherStates, pCfaEdge, pPrecision));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (List productStates : cartesianProduct) {
            for (AutomatonState buechiStrenghtenState : buechiStrengthenResults) {
                builder.add((Object)new DCAState(buechiStrenghtenState, productStates));
            }
        }
        return builder.build();
    }
}

