/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.defuse;

import java.util.HashSet;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseDefinition;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseDomain;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseState;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseTransferRelation;

@Options(prefix="cpa.defuse")
public class DefUseCPA
extends AbstractCPA {
    @Option(secure=true, name="merge", values={"sep", "join"}, description="which merge operator to use for DefUseCPA")
    private String mergeType = "sep";

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(DefUseCPA.class);
    }

    private DefUseCPA(Configuration config) throws InvalidConfigurationException {
        super("irrelevant", "SEP", new DefUseDomain(), new DefUseTransferRelation());
        config.inject((Object)this);
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.buildMergeOperator(this.mergeType);
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        HashSet<DefUseDefinition> defUseDefinitions = new HashSet<DefUseDefinition>();
        if (pNode instanceof CFunctionEntryNode) {
            List<String> parameterNames = ((CFunctionEntryNode)pNode).getFunctionParameterNames();
            for (String parameterName : parameterNames) {
                DefUseDefinition newDef = new DefUseDefinition(parameterName, null);
                defUseDefinitions.add(newDef);
            }
        }
        return new DefUseState(defUseDefinitions);
    }
}

