/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.defuse;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseDefinition;

public class DefUseState
implements AbstractState,
Iterable<DefUseDefinition> {
    private final Set<DefUseDefinition> definitions;

    public DefUseState(Set<DefUseDefinition> definitions) {
        this.definitions = ImmutableSet.copyOf(definitions);
    }

    public DefUseState(DefUseState definitions, DefUseDefinition newDefinition) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)newDefinition);
        for (DefUseDefinition def : definitions.definitions) {
            if (def.getVariableName().equals(newDefinition.getVariableName())) continue;
            builder.add((Object)def);
        }
        this.definitions = builder.build();
    }

    @Override
    public Iterator<DefUseDefinition> iterator() {
        return this.definitions.iterator();
    }

    public boolean containsAllOf(DefUseState other) {
        return this.definitions.containsAll(other.definitions);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefUseState)) {
            return false;
        }
        DefUseState otherDefUse = (DefUseState)other;
        return otherDefUse.definitions.equals(this.definitions);
    }

    @Override
    public int hashCode() {
        return this.definitions.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        boolean hasAny = false;
        for (DefUseDefinition def : this.definitions) {
            CFAEdge assigningEdge = def.getAssigningEdge();
            builder.append('(').append(def.getVariableName()).append(", ");
            if (assigningEdge != null) {
                builder.append(assigningEdge.getPredecessor().getNodeNumber());
            } else {
                builder.append(0);
            }
            builder.append(", ");
            if (assigningEdge != null) {
                builder.append(assigningEdge.getSuccessor().getNodeNumber());
            } else {
                builder.append(0);
            }
            builder.append("), ");
            hasAny = true;
        }
        if (hasAny) {
            builder.replace(builder.length() - 2, builder.length(), "}");
        } else {
            builder.append('}');
        }
        return builder.toString();
    }
}

