/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.defuse;

import java.util.Collection;
import java.util.Collections;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseDefinition;
import org.sosy_lab.cpachecker.cpa.defuse.DefUseState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class DefUseTransferRelation
extends SingleEdgeTransferRelation {
    private DefUseState handleExpression(DefUseState defUseState, CStatement expression, CFAEdge cfaEdge) {
        if (expression instanceof CAssignment) {
            CAssignment assignExpression = (CAssignment)expression;
            String lParam = assignExpression.getLeftHandSide().toASTString();
            DefUseDefinition definition = new DefUseDefinition(lParam, cfaEdge);
            defUseState = new DefUseState(defUseState, definition);
        }
        return defUseState;
    }

    private DefUseState handleDeclaration(DefUseState defUseState, CDeclarationEdge cfaEdge) {
        CVariableDeclaration decl;
        CInitializer initializer;
        if (cfaEdge.getDeclaration() instanceof CVariableDeclaration && (initializer = (decl = (CVariableDeclaration)cfaEdge.getDeclaration()).getInitializer()) != null) {
            String varName = decl.getName();
            DefUseDefinition definition = new DefUseDefinition(varName, cfaEdge);
            defUseState = new DefUseState(defUseState, definition);
        }
        return defUseState;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState element, Precision prec, CFAEdge cfaEdge) throws CPATransferException {
        DefUseState defUseState = (DefUseState)element;
        switch (cfaEdge.getEdgeType()) {
            case StatementEdge: {
                CStatementEdge statementEdge = (CStatementEdge)cfaEdge;
                CStatement expression = statementEdge.getStatement();
                defUseState = this.handleExpression(defUseState, expression, cfaEdge);
                break;
            }
            case DeclarationEdge: {
                CDeclarationEdge declarationEdge = (CDeclarationEdge)cfaEdge;
                defUseState = this.handleDeclaration(defUseState, declarationEdge);
                break;
            }
        }
        return Collections.singleton(defUseState);
    }
}

