/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.deterministic;

import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.LiveVariables;

public class DeterministicVariablesState
implements LatticeAbstractState<DeterministicVariablesState>,
Graphable {
    private final Set<Equivalence.Wrapper<ASimpleDeclaration>> deterministicVariables;

    DeterministicVariablesState() {
        this.deterministicVariables = new HashSet<Equivalence.Wrapper<ASimpleDeclaration>>();
    }

    DeterministicVariablesState(Set<Equivalence.Wrapper<ASimpleDeclaration>> pDeterministicVariables) {
        Preconditions.checkNotNull(pDeterministicVariables);
        this.deterministicVariables = pDeterministicVariables;
    }

    boolean isDeterministic(Equivalence.Wrapper<ASimpleDeclaration> variableName) {
        return this.deterministicVariables.contains(variableName);
    }

    DeterministicVariablesState addDeterministicVariable(Equivalence.Wrapper<ASimpleDeclaration> pDeterministicVariable) {
        Preconditions.checkNotNull(pDeterministicVariable);
        if (this.deterministicVariables.contains(pDeterministicVariable)) {
            return this;
        }
        HashSet<Equivalence.Wrapper<ASimpleDeclaration>> newState = new HashSet<Equivalence.Wrapper<ASimpleDeclaration>>(this.deterministicVariables);
        newState.add(pDeterministicVariable);
        return new DeterministicVariablesState(newState);
    }

    DeterministicVariablesState addDeterministicVariables(Collection<Equivalence.Wrapper<ASimpleDeclaration>> pDeterministicVariables) {
        Preconditions.checkNotNull(pDeterministicVariables);
        if (pDeterministicVariables.isEmpty() || this.deterministicVariables.containsAll(pDeterministicVariables)) {
            return this;
        }
        HashSet<Equivalence.Wrapper<ASimpleDeclaration>> newState = new HashSet<Equivalence.Wrapper<ASimpleDeclaration>>(this.deterministicVariables);
        newState.addAll(pDeterministicVariables);
        return new DeterministicVariablesState(newState);
    }

    DeterministicVariablesState removeDeterministicVariable(Equivalence.Wrapper<ASimpleDeclaration> pNonDeterministicVariable) {
        Preconditions.checkNotNull(pNonDeterministicVariable);
        if (!this.deterministicVariables.contains(pNonDeterministicVariable)) {
            return this;
        }
        HashSet<Equivalence.Wrapper<ASimpleDeclaration>> newState = new HashSet<Equivalence.Wrapper<ASimpleDeclaration>>(this.deterministicVariables);
        newState.remove(pNonDeterministicVariable);
        return new DeterministicVariablesState(newState);
    }

    DeterministicVariablesState removeDeterministicVariables(Collection<Equivalence.Wrapper<ASimpleDeclaration>> pNonDeterministicVariables) {
        Preconditions.checkNotNull(pNonDeterministicVariables);
        HashSet<Equivalence.Wrapper<ASimpleDeclaration>> newState = new HashSet<Equivalence.Wrapper<ASimpleDeclaration>>(this.deterministicVariables);
        newState.removeAll(pNonDeterministicVariables);
        return new DeterministicVariablesState(newState);
    }

    @Override
    public String toString() {
        return this.deterministicVariables.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.deterministicVariables);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeterministicVariablesState)) {
            return false;
        }
        DeterministicVariablesState other = (DeterministicVariablesState)obj;
        return Objects.equals(this.deterministicVariables, other.deterministicVariables);
    }

    @Override
    public DeterministicVariablesState join(DeterministicVariablesState pOther) {
        ImmutableSet deterministicVariablesInboth = Sets.intersection(this.deterministicVariables, pOther.deterministicVariables).immutableCopy();
        if (deterministicVariablesInboth.equals(pOther.deterministicVariables)) {
            return pOther;
        }
        return new DeterministicVariablesState((Set<Equivalence.Wrapper<ASimpleDeclaration>>)deterministicVariablesInboth);
    }

    @Override
    public boolean isLessOrEqual(DeterministicVariablesState pOther) throws CPAException, InterruptedException {
        if (this.deterministicVariables.size() < pOther.deterministicVariables.size()) {
            return false;
        }
        return this.deterministicVariables.containsAll(pOther.deterministicVariables);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Joiner.on((String)", ").appendTo(sb, (Iterable)FluentIterable.from(this.deterministicVariables).transform(LiveVariables.FROM_EQUIV_WRAPPER_TO_STRING));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }
}

