/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.deterministic;

import com.google.common.base.Equivalence;
import com.google.common.collect.Iterables;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.deterministic.DeterministicVariablesState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

public class DeterministicVariablesTransferRelation
extends ForwardingTransferRelation<DeterministicVariablesState, DeterministicVariablesState, Precision>
implements Statistics {
    private StatCounter numberOfAssumes = new StatCounter("Number of assume edges");
    private StatCounter numberOfNonDetAssumes = new StatCounter("Number of non-deterministic assume edges");
    private Set<CFANode> assumes = new HashSet<CFANode>();
    private Set<CFANode> nondetAssumes = new HashSet<CFANode>();

    @Override
    protected DeterministicVariablesState handleDeclarationEdge(ADeclarationEdge pCfaEdge, ADeclaration pDeclaration) throws CPATransferException {
        if (!(pDeclaration instanceof AVariableDeclaration)) {
            return (DeterministicVariablesState)this.state;
        }
        Equivalence.Wrapper varDeclaration = LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)pDeclaration);
        AInitializer initializer = ((AVariableDeclaration)pDeclaration).getInitializer();
        if (initializer == null) {
            return (DeterministicVariablesState)this.state;
        }
        if (initializer instanceof CInitializerExpression && this.areAllDeterministic(this.getVariablesUsedForInitialization(initializer))) {
            return ((DeterministicVariablesState)this.state).addDeterministicVariable((Equivalence.Wrapper<ASimpleDeclaration>)varDeclaration);
        }
        return (DeterministicVariablesState)this.state;
    }

    @Override
    protected DeterministicVariablesState handleAssumption(AssumeEdge cfaEdge, AExpression expression, boolean truthAssumption) throws CPATransferException {
        if (this.assumes.add(cfaEdge.getPredecessor())) {
            this.numberOfAssumes.inc();
        }
        if (!this.areAllDeterministic(this.handleExpression(expression)) && this.nondetAssumes.add(cfaEdge.getPredecessor())) {
            this.numberOfNonDetAssumes.inc();
        }
        return (DeterministicVariablesState)this.state;
    }

    @Override
    protected DeterministicVariablesState handleStatementEdge(AStatementEdge cfaEdge, AStatement statement) throws CPATransferException {
        if (statement instanceof AExpressionStatement) {
            return (DeterministicVariablesState)this.state;
        }
        if (statement instanceof AFunctionCallStatement) {
            return (DeterministicVariablesState)this.state;
        }
        if (statement instanceof AExpressionAssignmentStatement) {
            return this.handleAssignments((AAssignment)((Object)statement));
        }
        if (statement instanceof AFunctionCallAssignmentStatement) {
            return this.handleAssignments((AAssignment)((Object)statement));
        }
        throw new CPATransferException("Missing case for if-then-else statement.");
    }

    @Override
    protected DeterministicVariablesState handleReturnStatementEdge(AReturnStatementEdge cfaEdge) throws CPATransferException {
        if (!cfaEdge.asAssignment().isPresent()) {
            return (DeterministicVariablesState)this.state;
        }
        return this.handleAssignments(cfaEdge.asAssignment().get());
    }

    @Override
    protected DeterministicVariablesState handleFunctionCallEdge(FunctionCallEdge cfaEdge, List<? extends AExpression> arguments, List<? extends AParameterDeclaration> parameters, String calledFunctionName) throws CPATransferException {
        assert (parameters.size() == arguments.size() || cfaEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs());
        HashSet<Equivalence.Wrapper<ASimpleDeclaration>> deterministicParameters = new HashSet<Equivalence.Wrapper<ASimpleDeclaration>>(arguments.size());
        for (int i = 0; i < parameters.size(); ++i) {
            if (!this.areAllDeterministic(this.handleExpression(arguments.get(i)))) continue;
            deterministicParameters.add((Equivalence.Wrapper<ASimpleDeclaration>)LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)parameters.get(i)));
        }
        return ((DeterministicVariablesState)this.state).addDeterministicVariables(deterministicParameters);
    }

    @Override
    protected DeterministicVariablesState handleFunctionReturnEdge(FunctionReturnEdge cfaEdge, FunctionSummaryEdge fnkCall, AFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        if (cfaEdge.getFunctionEntry().getReturnVariable().isPresent()) {
            AFunctionCallAssignmentStatement assignExp;
            Collection<Equivalence.Wrapper<ASimpleDeclaration>> collection;
            ASimpleDeclaration returnVariable = cfaEdge.getFunctionEntry().getReturnVariable().get();
            if (summaryExpr instanceof AFunctionCallAssignmentStatement && (collection = this.handleLeftHandSide((assignExp = (AFunctionCallAssignmentStatement)summaryExpr).getLeftHandSide())).size() == 1) {
                this.state = this.areAllDeterministic(Collections.singleton(LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)returnVariable))) ? ((DeterministicVariablesState)this.state).addDeterministicVariable((Equivalence.Wrapper<ASimpleDeclaration>)((Equivalence.Wrapper)Iterables.getOnlyElement(collection))) : ((DeterministicVariablesState)this.state).removeDeterministicVariable((Equivalence.Wrapper<ASimpleDeclaration>)((Equivalence.Wrapper)Iterables.getOnlyElement(collection)));
            }
            this.state = ((DeterministicVariablesState)this.state).removeDeterministicVariable((Equivalence.Wrapper<ASimpleDeclaration>)LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)returnVariable));
        }
        HashSet<Equivalence.Wrapper<ASimpleDeclaration>> parameters = new HashSet<Equivalence.Wrapper<ASimpleDeclaration>>(fnkCall.getFunctionEntry().getFunctionDefinition().getParameters().size());
        for (AParameterDeclaration aParameterDeclaration : fnkCall.getFunctionEntry().getFunctionDefinition().getParameters()) {
            parameters.add((Equivalence.Wrapper<ASimpleDeclaration>)LiveVariables.LIVE_DECL_EQUIVALENCE.wrap((Object)aParameterDeclaration));
        }
        return ((DeterministicVariablesState)this.state).removeDeterministicVariables(parameters);
    }

    @Override
    protected DeterministicVariablesState handleFunctionSummaryEdge(FunctionSummaryEdge cfaEdge) throws CPATransferException {
        AFunctionCall functionCall = cfaEdge.getExpression();
        if (functionCall instanceof AFunctionCallAssignmentStatement) {
            throw new CPATransferException("Woooooot? Didn't expect to see you here, AFunctionCallAssignmentStatement!");
        }
        if (functionCall instanceof AFunctionCallStatement) {
            throw new CPATransferException("Woooooot? Didn't expect to see you here, AFunctionCallStatement!");
        }
        throw new CPATransferException("Missing case for if-then-else statement.");
    }

    private Collection<Equivalence.Wrapper<ASimpleDeclaration>> handleExpression(AExpression expression) {
        return CFAUtils.traverseRecursively(expression).filter(AIdExpression.class).transform(AIdExpression::getDeclaration).transform(LiveVariables.TO_EQUIV_WRAPPER).toSet();
    }

    private Collection<Equivalence.Wrapper<ASimpleDeclaration>> handleLeftHandSide(ALeftHandSide pLeftHandSide) {
        return CFAUtils.traverseLeftHandSideRecursively(pLeftHandSide).filter(AIdExpression.class).transform(AIdExpression::getDeclaration).transform(LiveVariables.TO_EQUIV_WRAPPER).toSet();
    }

    private DeterministicVariablesState handleAssignments(AAssignment pAssignment) {
        Collection<Equivalence.Wrapper<ASimpleDeclaration>> assignedVariables = this.handleLeftHandSide(pAssignment.getLeftHandSide());
        if (assignedVariables.size() > 1) {
            return (DeterministicVariablesState)this.state;
        }
        if (pAssignment instanceof AExpressionAssignmentStatement) {
            Equivalence.Wrapper assignedVariable = (Equivalence.Wrapper)Iterables.getOnlyElement(assignedVariables);
            return this.areAllDeterministic(this.handleExpression((AExpression)pAssignment.getRightHandSide())) ? ((DeterministicVariablesState)this.state).addDeterministicVariable((Equivalence.Wrapper<ASimpleDeclaration>)assignedVariable) : ((DeterministicVariablesState)this.state).removeDeterministicVariable((Equivalence.Wrapper<ASimpleDeclaration>)assignedVariable);
        }
        if (pAssignment instanceof AFunctionCallAssignmentStatement) {
            return ((DeterministicVariablesState)this.state).removeDeterministicVariable((Equivalence.Wrapper<ASimpleDeclaration>)((Equivalence.Wrapper)Iterables.getOnlyElement(assignedVariables)));
        }
        throw new AssertionError((Object)("Unhandled assignment type " + pAssignment.getClass()));
    }

    private boolean areAllDeterministic(Collection<Equivalence.Wrapper<ASimpleDeclaration>> variables) {
        for (Equivalence.Wrapper<ASimpleDeclaration> variable : variables) {
            if (((DeterministicVariablesState)this.state).isDeterministic(variable)) continue;
            return false;
        }
        return true;
    }

    private Collection<Equivalence.Wrapper<ASimpleDeclaration>> getVariablesUsedForInitialization(AInitializer init) throws CPATransferException {
        if (init instanceof CDesignatedInitializer) {
            return this.getVariablesUsedForInitialization(((CDesignatedInitializer)init).getRightHandSide());
        }
        if (init instanceof CInitializerList) {
            ArrayList<Equivalence.Wrapper<ASimpleDeclaration>> readVars = new ArrayList<Equivalence.Wrapper<ASimpleDeclaration>>();
            for (CInitializer inList : ((CInitializerList)init).getInitializers()) {
                readVars.addAll(this.getVariablesUsedForInitialization(inList));
            }
            return readVars;
        }
        if (init instanceof AInitializerExpression) {
            return this.handleExpression(((AInitializerExpression)init).getExpression());
        }
        throw new CPATransferException("Missing case for if-then-else statement.");
    }

    @Override
    public String getName() {
        return "DeterministicVariablesCPA";
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
        writer.put(this.numberOfAssumes).put(this.numberOfNonDetAssumes).put("Level of non-determism", this.numberOfAssumes.getValue() == 0L ? "0%" : StatisticsUtils.toPercent(this.numberOfNonDetAssumes.getValue(), this.numberOfAssumes.getValue()));
    }
}

