/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.dominator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;

public class DominatorState
extends ForwardingSet<CFANode>
implements AbstractState,
LatticeAbstractState<DominatorState>,
Graphable {
    private Set<CFANode> dominators = new HashSet<CFANode>();

    public DominatorState() {
    }

    public DominatorState(Set<CFANode> pDominators) {
        Preconditions.checkNotNull(pDominators);
        this.dominators.addAll(pDominators);
    }

    protected Set<CFANode> delegate() {
        return this.dominators;
    }

    public boolean add(CFANode pDominator) {
        Preconditions.checkNotNull((Object)pDominator);
        return this.dominators.add(pDominator);
    }

    @Override
    public boolean equals(Object pOther) {
        if (!(pOther instanceof DominatorState)) {
            return false;
        }
        DominatorState otherElement = (DominatorState)pOther;
        return this.dominators.equals(otherElement.dominators);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(": ").append("{");
        boolean first = true;
        for (CFANode dominator : this.dominators) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(dominator.toString());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dominators);
    }

    @Override
    public String toDOTLabel() {
        return this.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public DominatorState join(DominatorState pOther) {
        if (this.dominators.equals(pOther.dominators)) {
            return pOther;
        }
        return new DominatorState((Set<CFANode>)Sets.intersection(this.dominators, pOther.dominators));
    }

    @Override
    public boolean isLessOrEqual(DominatorState pOther) {
        Iterator iterator = pOther.iterator();
        while (iterator.hasNext()) {
            CFANode dominator = (CFANode)iterator.next();
            if (this.contains(dominator)) continue;
            return false;
        }
        return true;
    }
}

