/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.flowdep;

import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractSingleWrapperCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopJoinOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.flowdep.FlowDependenceDomain;
import org.sosy_lab.cpachecker.cpa.flowdep.FlowDependenceState;
import org.sosy_lab.cpachecker.cpa.flowdep.FlowDependenceTransferRelation;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerCPA;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefCPA;

public class FlowDependenceCPA
extends AbstractSingleWrapperCPA {
    private final AbstractDomain domain;
    private final FlowDependenceTransferRelation transfer;
    private final MergeOperator merge;
    private final StopOperator stop;
    private final LogManager logger;
    private final CompositeCPA delegateCpa;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(FlowDependenceCPA.class);
    }

    private FlowDependenceCPA(LogManager pLogger, CFA pCfa, ConfigurableProgramAnalysis pCpaToWrap) throws InvalidConfigurationException {
        super(pCpaToWrap);
        this.logger = pLogger;
        this.delegateCpa = (CompositeCPA)super.getWrappedCpa();
        this.domain = new FlowDependenceDomain();
        this.transfer = new FlowDependenceTransferRelation(this.delegateCpa.getTransferRelation(), pCfa.getVarClassification(), this.logger);
        this.merge = new MergeJoinOperator(this.domain);
        this.stop = new StopJoinOperator(this.domain);
        for (ConfigurableProgramAnalysis cpa : ((CompositeCPA)pCpaToWrap).getWrappedCPAs()) {
            if (cpa instanceof ReachingDefCPA || cpa instanceof PointerCPA) continue;
            throw new InvalidConfigurationException(FlowDependenceCPA.class.getSimpleName() + " requires exactly " + ReachingDefCPA.class.getSimpleName() + " and " + PointerCPA.class.getSimpleName());
        }
        if (pCfa.getLanguage() != Language.C) {
            throw new InvalidConfigurationException(FlowDependenceCPA.class.getSimpleName() + " only supports C");
        }
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.merge;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return new FlowDependenceState((CompositeState)this.delegateCpa.getInitialState(pNode, pPartition));
    }

    @Override
    public Precision getInitialPrecision(CFANode node, StateSpacePartition partition) throws InterruptedException {
        return this.getWrappedCpa().getInitialPrecision(node, partition);
    }
}

