/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.flowdep;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.flowdep.FlowDependenceState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerDomain;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Pair;

class FlowDependenceDomain
implements AbstractDomain {
    private final PointerDomain pointerDomain = PointerDomain.INSTANCE;

    FlowDependenceDomain() {
    }

    @Override
    public AbstractState join(AbstractState pState1, AbstractState pState2) throws CPAException, InterruptedException {
        assert (pState1 instanceof FlowDependenceState) : "Wrong type for first state passed: " + pState1;
        assert (pState2 instanceof FlowDependenceState) : "Wrong type for second state passed: " + pState2;
        if (this.isLessOrEqual(pState2, pState1)) {
            return pState2;
        }
        Pair<ReachingDefState, PointerState> wrapped1 = ((FlowDependenceState)pState1).unwrap();
        Pair<ReachingDefState, PointerState> wrapped2 = ((FlowDependenceState)pState2).unwrap();
        ReachingDefState joinedReachDefs = wrapped1.getFirst().join(wrapped2.getFirst());
        AbstractState joinedPointers = this.pointerDomain.join(wrapped1.getSecond(), wrapped2.getSecond());
        CompositeState joinedComposite = new CompositeState((List<AbstractState>)ImmutableList.of((Object)joinedReachDefs, (Object)joinedPointers));
        FlowDependenceState joinedFlowDeps = new FlowDependenceState(joinedComposite);
        joinedFlowDeps.addAll(((FlowDependenceState)pState1).getAll());
        for (Table.Cell e : ((FlowDependenceState)pState2).getAll().cellSet()) {
            CFAEdge g = (CFAEdge)e.getRowKey();
            Optional m = (Optional)e.getColumnKey();
            assert (g != null) : "Null value for CFA edge in flow dependences: " + ((FlowDependenceState)pState2).getAll();
            assert (m != null) : "Null value for memory location in flow dependences: " + ((FlowDependenceState)pState2).getAll();
            joinedFlowDeps.addDependence(g, m, (FlowDependenceState.FlowDependence)((Object)Preconditions.checkNotNull((Object)((Object)((FlowDependenceState.FlowDependence)((Object)e.getValue()))))));
        }
        return joinedFlowDeps;
    }

    @Override
    public boolean isLessOrEqual(AbstractState pStateLhs, AbstractState pStateRhs) throws CPAException, InterruptedException {
        assert (pStateLhs instanceof FlowDependenceState) : "Wrong type for first state passed: " + pStateLhs;
        assert (pStateRhs instanceof FlowDependenceState) : "Wrong type for second state passed: " + pStateRhs;
        FlowDependenceState state1 = (FlowDependenceState)pStateLhs;
        FlowDependenceState state2 = (FlowDependenceState)pStateRhs;
        Pair<ReachingDefState, PointerState> wrapped1 = state1.unwrap();
        Pair<ReachingDefState, PointerState> wrapped2 = state2.unwrap();
        boolean reachedLessOrEqual = wrapped1.getFirst().isLessOrEqual(wrapped2.getFirst());
        if (reachedLessOrEqual) {
            boolean pointerLessOrEqual = this.pointerDomain.isLessOrEqual(wrapped1.getSecond(), wrapped2.getSecond());
            return pointerLessOrEqual && this.containsAll(state2.getAll(), state1.getAll());
        }
        return false;
    }

    private <R, C, V> boolean containsAll(Table<R, C, V> superTable, Table<R, C, V> subTable) {
        Set superEntries = superTable.cellSet();
        for (Table.Cell e : subTable.cellSet()) {
            if (superEntries.contains(e)) continue;
            return false;
        }
        return true;
    }
}

