/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.flowdep;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public final class FlowDependenceState
implements AbstractState,
AbstractWrapperState,
Graphable {
    private final Table<CFAEdge, Optional<MemoryLocation>, FlowDependence> usedDefs = HashBasedTable.create();
    private CompositeState reachDefState;

    FlowDependenceState(CompositeState pReachDefState) {
        this.reachDefState = pReachDefState;
    }

    public Set<CFAEdge> getAllEdgesWithDependencies() {
        return this.usedDefs.rowKeySet();
    }

    public Set<Optional<MemoryLocation>> getNewDefinitionsByEdge(CFAEdge pForEdge) {
        return this.usedDefs.row((Object)pForEdge).keySet();
    }

    public FlowDependence getDependenciesOfDefinitionAtEdge(CFAEdge pEdge, Optional<MemoryLocation> pDefinition) {
        return (FlowDependence)((Object)this.usedDefs.get((Object)pEdge, pDefinition));
    }

    public void addDependence(CFAEdge pEdge, Optional<MemoryLocation> pDefines, FlowDependence pUses) {
        Preconditions.checkNotNull((Object)pEdge);
        Preconditions.checkNotNull(pDefines);
        Preconditions.checkNotNull((Object)((Object)pUses));
        if (this.usedDefs.contains((Object)pEdge, pDefines)) {
            this.usedDefs.put((Object)pEdge, pDefines, (Object)((FlowDependence)((Object)this.usedDefs.get((Object)pEdge, pDefines))).union(pUses));
        } else {
            this.usedDefs.put((Object)pEdge, pDefines, (Object)pUses);
        }
    }

    CompositeState getReachDefState() {
        return this.reachDefState;
    }

    void addAll(Table<CFAEdge, Optional<MemoryLocation>, FlowDependence> pUsedDefs) {
        this.usedDefs.putAll(pUsedDefs);
    }

    Table<CFAEdge, Optional<MemoryLocation>, FlowDependence> getAll() {
        return this.usedDefs;
    }

    public Pair<ReachingDefState, PointerState> unwrap() {
        ImmutableList<AbstractState> wrappedStates = this.reachDefState.getWrappedStates();
        ReachingDefState reachdef = null;
        PointerState pointers = null;
        assert (wrappedStates.size() == 2) : "Wrapped state has wrong size: " + wrappedStates.size();
        for (AbstractState s : wrappedStates) {
            if (s instanceof ReachingDefState) {
                reachdef = (ReachingDefState)s;
                continue;
            }
            if (s instanceof PointerState) {
                pointers = (PointerState)s;
                continue;
            }
            throw new AssertionError((Object)("Wrong state type: " + s.getClass().getSimpleName()));
        }
        return Pair.of(reachdef, pointers);
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        FlowDependenceState that = (FlowDependenceState)pO;
        return Objects.equals(this.reachDefState, that.reachDefState) && Objects.equals(this.usedDefs, that.usedDefs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.reachDefState, this.usedDefs);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (!this.usedDefs.isEmpty()) {
            sb.append("\n");
        }
        for (Table.Cell e : this.usedDefs.cellSet()) {
            sb.append("\t");
            sb.append(((CFAEdge)Preconditions.checkNotNull((Object)((CFAEdge)e.getRowKey()))).toString());
            Optional possibleDef = (Optional)Preconditions.checkNotNull((Object)((Optional)e.getColumnKey()));
            if (possibleDef.isPresent()) {
                sb.append(" + ").append(possibleDef.toString());
            }
            sb.append(":\n");
            sb.append(e.getValue());
        }
        sb.append("};\n");
        sb.append(this.reachDefState.toString());
        return sb.toString();
    }

    @Override
    public Iterable<AbstractState> getWrappedStates() {
        return ImmutableSet.of((Object)this.reachDefState);
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Table.Cell e : this.usedDefs.cellSet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            CFAEdge edge = (CFAEdge)Preconditions.checkNotNull((Object)((CFAEdge)e.getRowKey()));
            Optional possibleDef = (Optional)Preconditions.checkNotNull((Object)((Optional)e.getColumnKey()));
            Multimap uses = (Multimap)Preconditions.checkNotNull((Object)((Object)((FlowDependence)((Object)e.getValue()))));
            sb.append(edge.toString());
            if (possibleDef.isPresent()) {
                sb.append(" + ").append(possibleDef.toString());
            }
            sb.append(": [ ");
            boolean first2 = true;
            for (Map.Entry memDefs : uses.entries()) {
                if (!first2) {
                    sb.append(", ");
                }
                first2 = false;
                sb.append(memDefs.getKey()).append(" <- ").append(memDefs.getValue());
            }
            sb.append("]");
        }
        sb.append("};");
        sb.append(this.reachDefState.toDOTLabel());
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    public static class UnknownPointerDependence
    extends FlowDependence {
        private static final UnknownPointerDependence INSTANCE = new UnknownPointerDependence();

        private UnknownPointerDependence() {
            super((Multimap<MemoryLocation, CFAEdge>)ImmutableListMultimap.of());
        }

        public static UnknownPointerDependence getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isUnknownPointerDependence() {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof UnknownPointerDependence;
        }

        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return "Dependence to unknown memory location";
        }
    }

    public static class FlowDependence
    extends ForwardingMultimap<MemoryLocation, CFAEdge> {
        private Multimap<MemoryLocation, CFAEdge> useToDefinitions;

        private FlowDependence() {
            this.useToDefinitions = HashMultimap.create();
        }

        public static FlowDependence copyOf() {
            return new FlowDependence();
        }

        public static FlowDependence copyOf(Multimap<MemoryLocation, CFAEdge> pMap) {
            return new FlowDependence(pMap);
        }

        public static FlowDependence create(Multimap<MemoryLocation, ReachingDefState.ProgramDefinitionPoint> pMap) {
            HashMultimap useToDefinitions = HashMultimap.create();
            for (Map.Entry e : pMap.entries()) {
                boolean added = false;
                ReachingDefState.ProgramDefinitionPoint defPoint = (ReachingDefState.ProgramDefinitionPoint)e.getValue();
                CFANode start = defPoint.getDefinitionEntryLocation();
                CFANode stop = defPoint.getDefinitionExitLocation();
                for (CFAEdge g : CFAUtils.leavingEdges(start)) {
                    if (!g.getSuccessor().equals(stop)) continue;
                    useToDefinitions.put((Object)((MemoryLocation)e.getKey()), (Object)g);
                    added = true;
                }
                assert (added) : "No edge added for nodes " + start + " to " + stop;
            }
            return FlowDependence.copyOf((Multimap<MemoryLocation, CFAEdge>)useToDefinitions);
        }

        private FlowDependence(Multimap<MemoryLocation, CFAEdge> pMap) {
            this.useToDefinitions = pMap;
        }

        protected Multimap<MemoryLocation, CFAEdge> delegate() {
            return this.useToDefinitions;
        }

        public boolean isUnknownPointerDependence() {
            return false;
        }

        public FlowDependence union(FlowDependence pOther) {
            if (this.isUnknownPointerDependence() || pOther.isUnknownPointerDependence()) {
                return UnknownPointerDependence.getInstance();
            }
            SetMultimap union = MultimapBuilder.hashKeys().hashSetValues().build(this.useToDefinitions);
            union.putAll(pOther.useToDefinitions);
            return new FlowDependence((Multimap<MemoryLocation, CFAEdge>)union);
        }

        public boolean putAll(MemoryLocation key, Iterable<? extends CFAEdge> values) {
            throw new UnsupportedOperationException("Unsupported. Use method #union() to ensure correct handling of UnknownPointerDependence");
        }

        public boolean putAll(Multimap<? extends MemoryLocation, ? extends CFAEdge> multimap) {
            throw new UnsupportedOperationException("Unsupported. Use method #union() to ensure correct handling of UnknownPointerDependence");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry memDefs : this.useToDefinitions.entries()) {
                sb.append("\t\t");
                sb.append(((MemoryLocation)memDefs.getKey()).toString()).append(" <- ").append(memDefs.getValue());
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

