/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.flowdep;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.flowdep.FlowDependenceState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.reachingdef.ReachingDefUtils;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

class FlowDependenceTransferRelation
extends SingleEdgeTransferRelation {
    private final TransferRelation delegate;
    private final Optional<VariableClassification> varClassification;
    private final LogManagerWithoutDuplicates logger;

    FlowDependenceTransferRelation(TransferRelation pDelegate, Optional<VariableClassification> pVarClassification, LogManager pLogger) {
        this.delegate = pDelegate;
        this.varClassification = pVarClassification;
        this.logger = new LogManagerWithoutDuplicates(pLogger);
    }

    private Multimap<MemoryLocation, ReachingDefState.ProgramDefinitionPoint> normalizeReachingDefinitions(ReachingDefState pState) {
        HashMultimap normalized = HashMultimap.create();
        normalized.putAll(this.normalize(pState.getLocalReachingDefinitions()));
        normalized.putAll(this.normalize(pState.getGlobalReachingDefinitions()));
        return normalized;
    }

    private Multimap<MemoryLocation, ReachingDefState.ProgramDefinitionPoint> normalize(Map<MemoryLocation, Set<ReachingDefState.DefinitionPoint>> pDefs) {
        HashMultimap normalized = HashMultimap.create();
        for (Map.Entry<MemoryLocation, Set<ReachingDefState.DefinitionPoint>> e : pDefs.entrySet()) {
            MemoryLocation varName = e.getKey();
            Set<ReachingDefState.DefinitionPoint> points = e.getValue();
            FluentIterable defPoints = FluentIterable.from(points).filter(ReachingDefState.ProgramDefinitionPoint.class);
            normalized.putAll((Object)varName, (Iterable)defPoints);
        }
        return normalized;
    }

    private FlowDependenceState handleDeclarationEdge(CDeclarationEdge pCfaEdge, CVariableDeclaration pDecl, FlowDependenceState pNextFlowState, ReachingDefState pReachDefState, PointerState pPointerState) throws CPATransferException {
        CInitializer maybeInitializer = pDecl.getInitializer();
        if (maybeInitializer instanceof CInitializerExpression) {
            CExpression initializerExp = ((CInitializerExpression)maybeInitializer).getExpression();
            MemoryLocation def = MemoryLocation.forDeclaration(pDecl);
            return this.handleOperation(pCfaEdge, Optional.of(def), this.getUsedVars(initializerExp, pPointerState), pNextFlowState, pReachDefState);
        }
        return pNextFlowState;
    }

    private FlowDependenceState handleOperation(CFAEdge pCfaEdge, Optional<MemoryLocation> pNewDeclaration, Set<MemoryLocation> pUses, FlowDependenceState pNextState, ReachingDefState pReachDefState) {
        FlowDependenceState.FlowDependence dependences;
        Multimap<MemoryLocation, ReachingDefState.ProgramDefinitionPoint> defs = this.normalizeReachingDefinitions(pReachDefState);
        if (pUses == null) {
            dependences = FlowDependenceState.UnknownPointerDependence.getInstance();
        } else {
            defs.keySet().retainAll(pUses);
            if (defs.keySet().size() != pUses.size()) {
                this.logger.log(Level.WARNING, new Object[]{"No definition point for at least one use in edge %s: %s", pCfaEdge, pReachDefState});
            }
            dependences = FlowDependenceState.FlowDependence.create(defs);
        }
        if (((FlowDependenceState.FlowDependence)dependences).isUnknownPointerDependence() || !dependences.isEmpty()) {
            pNextState.addDependence(pCfaEdge, pNewDeclaration, dependences);
        }
        return pNextState;
    }

    private Set<MemoryLocation> getUsedVars(CAstNode pExpression, PointerState pPointerState) throws CPATransferException {
        UsesCollector usesCollector = new UsesCollector(pPointerState, this.varClassification);
        return pExpression.accept(usesCollector);
    }

    private FlowDependenceState handleReturnStatementEdge(CReturnStatementEdge pCfaEdge, FlowDependenceState pNextState, ReachingDefState pReachDefState, PointerState pPointerState) throws CPATransferException {
        Optional<CAssignment> asAssignment = pCfaEdge.asAssignment();
        if (asAssignment.isPresent()) {
            CAssignment returnAssignment = asAssignment.orElseThrow();
            CRightHandSide rhs = returnAssignment.getRightHandSide();
            Set<MemoryLocation> defs = this.getDef(returnAssignment.getLeftHandSide(), pPointerState);
            FlowDependenceState nextState = pNextState;
            for (MemoryLocation d : defs) {
                nextState = this.handleOperation(pCfaEdge, Optional.of(d), this.getUsedVars(rhs, pPointerState), nextState, pReachDefState);
            }
            return nextState;
        }
        return pNextState;
    }

    private Set<MemoryLocation> getDef(CLeftHandSide pLeftHandSide, PointerState pPointerState) throws CPATransferException {
        UsesCollector collector = new UsesCollector(pPointerState, this.varClassification);
        if (pLeftHandSide instanceof CPointerExpression) {
            return FlowDependenceTransferRelation.getPossibePointees((CPointerExpression)pLeftHandSide, pPointerState, this.varClassification);
        }
        Set<MemoryLocation> decls = pLeftHandSide instanceof CArraySubscriptExpression ? ((CArraySubscriptExpression)pLeftHandSide).getArrayExpression().accept(collector) : pLeftHandSide.accept(collector);
        return decls;
    }

    private static @Nullable Set<MemoryLocation> getPossibePointees(CPointerExpression pExp, PointerState pPointerState, Optional<VariableClassification> pVarClassification) {
        Set<MemoryLocation> pointees = ReachingDefUtils.possiblePointees(pExp, pPointerState);
        if (pointees == null) {
            pointees = new HashSet<MemoryLocation>();
            if (pVarClassification.isPresent()) {
                Set<String> addressedVars = pVarClassification.orElseThrow().getAddressedVariables();
                for (String v : addressedVars) {
                    MemoryLocation m = MemoryLocation.fromQualifiedName(v);
                    pointees.add(m);
                }
            } else {
                return null;
            }
        }
        return pointees;
    }

    protected FlowDependenceState handleAssumption(CAssumeEdge cfaEdge, CExpression expression, FlowDependenceState pNextState, ReachingDefState pReachDefState, PointerState pPointerState) throws CPATransferException {
        return this.handleOperation(cfaEdge, Optional.empty(), this.getUsedVars(expression, pPointerState), pNextState, pReachDefState);
    }

    protected FlowDependenceState handleFunctionCallEdge(CFunctionCallEdge pFunctionCallEdge, List<CExpression> pArguments, FlowDependenceState pNextState, ReachingDefState pReachDefState, PointerState pPointerState) throws CPATransferException {
        FlowDependenceState nextState = pNextState;
        List<CParameterDeclaration> params = pFunctionCallEdge.getSuccessor().getFunctionParameters();
        for (int i = 0; i < pArguments.size(); ++i) {
            if (i >= params.size()) {
                assert (pFunctionCallEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs());
                break;
            }
            MemoryLocation def = MemoryLocation.forDeclaration(params.get(i));
            CExpression argument = pArguments.get(i);
            nextState = this.handleOperation(pFunctionCallEdge, Optional.of(def), this.getUsedVars(argument, pPointerState), nextState, pReachDefState);
        }
        return nextState;
    }

    protected FlowDependenceState handleStatementEdge(CStatementEdge pCfaEdge, CStatement pStatement, FlowDependenceState pNextState, ReachingDefState pReachDefState, PointerState pPointerState) throws CPATransferException {
        FlowDependenceState nextState = pNextState;
        if (pStatement instanceof CAssignment) {
            Set<MemoryLocation> possibleDefs = this.getDef(((CAssignment)pStatement).getLeftHandSide(), pPointerState);
            if (possibleDefs != null) {
                for (MemoryLocation def : possibleDefs) {
                    nextState = this.handleOperation(pCfaEdge, Optional.ofNullable(def), this.getUsedVars(pStatement, pPointerState), nextState, pReachDefState);
                }
            } else {
                nextState = this.handleOperation(pCfaEdge, Optional.empty(), this.getUsedVars(pStatement, pPointerState), nextState, pReachDefState);
            }
        }
        return nextState;
    }

    public Collection<FlowDependenceState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        assert (pState instanceof FlowDependenceState) : "Expected state of type " + FlowDependenceState.class.getSimpleName();
        FlowDependenceState oldState = (FlowDependenceState)pState;
        CompositeState oldComposite = oldState.getReachDefState();
        Optional<CompositeState> nextComposite = this.computeReachDefState(oldComposite, pPrecision, pCfaEdge);
        if (nextComposite.isPresent()) {
            CompositeState newReachDefState = nextComposite.orElseThrow();
            Pair<ReachingDefState, PointerState> oldReachDefAndPointerState = oldState.unwrap();
            ReachingDefState oldReachDefState = oldReachDefAndPointerState.getFirst();
            PointerState oldPointerState = oldReachDefAndPointerState.getSecond();
            FlowDependenceState nextState = new FlowDependenceState(newReachDefState);
            switch (pCfaEdge.getEdgeType()) {
                case DeclarationEdge: {
                    CDeclarationEdge declEdge = (CDeclarationEdge)pCfaEdge;
                    if (!(declEdge.getDeclaration() instanceof CVariableDeclaration)) break;
                    CVariableDeclaration declaration = (CVariableDeclaration)declEdge.getDeclaration();
                    nextState = this.handleDeclarationEdge(declEdge, declaration, nextState, oldReachDefState, oldPointerState);
                    break;
                }
                case StatementEdge: {
                    CStatementEdge stmtEdge = (CStatementEdge)pCfaEdge;
                    nextState = this.handleStatementEdge(stmtEdge, stmtEdge.getStatement(), nextState, oldReachDefState, oldPointerState);
                    break;
                }
                case AssumeEdge: {
                    CAssumeEdge assumeEdge = (CAssumeEdge)pCfaEdge;
                    nextState = this.handleAssumption(assumeEdge, assumeEdge.getExpression(), nextState, oldReachDefState, oldPointerState);
                    break;
                }
                case ReturnStatementEdge: {
                    CReturnStatementEdge returnStatementEdge = (CReturnStatementEdge)pCfaEdge;
                    nextState = this.handleReturnStatementEdge(returnStatementEdge, nextState, oldReachDefState, oldPointerState);
                    break;
                }
                case FunctionCallEdge: {
                    CFunctionCallEdge callEdge = (CFunctionCallEdge)pCfaEdge;
                    nextState = this.handleFunctionCallEdge(callEdge, callEdge.getArguments(), nextState, oldReachDefState, oldPointerState);
                    break;
                }
                case FunctionReturnEdge: {
                    CFunctionReturnEdge returnEdge = (CFunctionReturnEdge)pCfaEdge;
                    nextState = this.handleFunctionReturnEdge(returnEdge, nextState, oldReachDefState, oldPointerState);
                    break;
                }
            }
            assert (nextState != null);
            return ImmutableSet.of((Object)nextState);
        }
        return ImmutableSet.of();
    }

    private FlowDependenceState handleFunctionReturnEdge(CFunctionReturnEdge pReturnEdge, FlowDependenceState pNewState, ReachingDefState pReachDefState, PointerState pPointerState) throws CPATransferException {
        FlowDependenceState nextState = pNewState;
        CFunctionSummaryEdge summaryEdge = pReturnEdge.getSummaryEdge();
        CFunctionCallExpression functionCall = summaryEdge.getExpression().getFunctionCallExpression();
        List<CExpression> outFunctionParams = functionCall.getParameterExpressions();
        List<CParameterDeclaration> inFunctionParams = functionCall.getDeclaration().getParameters();
        for (int i = 0; i < inFunctionParams.size(); ++i) {
            CParameterDeclaration inParam = inFunctionParams.get(i);
            CType parameterType = inParam.getType();
            if (!(parameterType instanceof CArrayType)) continue;
            CExpression outParam = outFunctionParams.get(i);
            if (!(outParam instanceof CLeftHandSide)) {
                throw new AssertionError((Object)("Unhandled: " + outParam));
            }
            Set<MemoryLocation> possibleDefs = this.getDef((CLeftHandSide)outParam, pPointerState);
            if (possibleDefs != null) {
                for (MemoryLocation def : possibleDefs) {
                    nextState = this.handleOperation(pReturnEdge, Optional.ofNullable(def), (Set<MemoryLocation>)ImmutableSet.of((Object)MemoryLocation.forDeclaration(inParam)), nextState, pReachDefState);
                }
                continue;
            }
            nextState = this.handleOperation(pReturnEdge, Optional.empty(), (Set<MemoryLocation>)ImmutableSet.of((Object)MemoryLocation.forDeclaration(inParam)), nextState, pReachDefState);
        }
        Optional<CVariableDeclaration> maybeReturnVar = summaryEdge.getFunctionEntry().getReturnVariable();
        if (maybeReturnVar.isPresent()) {
            Set<MemoryLocation> possibleDefs = null;
            CFunctionCall call = summaryEdge.getExpression();
            if (call instanceof CFunctionCallAssignmentStatement) {
                possibleDefs = this.getDef(((CFunctionCallAssignmentStatement)call).getLeftHandSide(), pPointerState);
            }
            if (possibleDefs != null) {
                for (MemoryLocation def : possibleDefs) {
                    nextState = this.handleOperation(pReturnEdge, Optional.ofNullable(def), (Set<MemoryLocation>)ImmutableSet.of((Object)MemoryLocation.forDeclaration(maybeReturnVar.orElseThrow())), nextState, pReachDefState);
                }
            } else {
                nextState = this.handleOperation(pReturnEdge, Optional.empty(), (Set<MemoryLocation>)ImmutableSet.of((Object)MemoryLocation.forDeclaration(maybeReturnVar.orElseThrow())), nextState, pReachDefState);
            }
        }
        return nextState;
    }

    private Optional<CompositeState> computeReachDefState(CompositeState pOldState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        Collection<? extends AbstractState> computedReachDefStates;
        try {
            computedReachDefStates = this.delegate.getAbstractSuccessorsForEdge(pOldState, pPrecision, pCfaEdge);
        }
        catch (InterruptedException pE) {
            throw new CPATransferException("Exception in reaching definitions transfer", pE);
        }
        if (computedReachDefStates.isEmpty()) {
            return Optional.empty();
        }
        CompositeState composite = (CompositeState)Iterables.getOnlyElement(computedReachDefStates);
        return Optional.of(composite);
    }

    private static class UsesCollector
    implements CAstNodeVisitor<Set<MemoryLocation>, CPATransferException> {
        private final PointerState pointerState;
        private final Optional<VariableClassification> varClassification;

        public UsesCollector(PointerState pPointerState, Optional<VariableClassification> pVarClassification) {
            this.pointerState = pPointerState;
            this.varClassification = pVarClassification;
        }

        private Set<MemoryLocation> combine(Set<MemoryLocation> pLhs, Set<MemoryLocation> pRhs) {
            if (pLhs == null || pRhs == null) {
                return null;
            }
            HashSet<MemoryLocation> combined = new HashSet<MemoryLocation>(pLhs);
            combined.addAll(pRhs);
            return combined;
        }

        @Override
        public Set<MemoryLocation> visit(CExpressionStatement pStmt) throws CPATransferException {
            return pStmt.getExpression().accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CExpressionAssignmentStatement pStmt) throws CPATransferException {
            Set<MemoryLocation> lhs = this.handleLeftHandSide(pStmt.getLeftHandSide());
            Set<MemoryLocation> rhs = pStmt.getRightHandSide().accept(this);
            return this.combine(lhs, rhs);
        }

        @Override
        public Set<MemoryLocation> visit(CFunctionCallAssignmentStatement pStmt) throws CPATransferException {
            Set<MemoryLocation> lhs = this.handleLeftHandSide(pStmt.getLeftHandSide());
            Set<MemoryLocation> rhs = pStmt.getRightHandSide().accept(this);
            return this.combine(lhs, rhs);
        }

        private Set<MemoryLocation> handleLeftHandSide(CLeftHandSide pLhs) throws CPATransferException {
            if (pLhs instanceof CPointerExpression) {
                return ((CPointerExpression)pLhs).getOperand().accept(this);
            }
            if (pLhs instanceof CArraySubscriptExpression) {
                return ((CArraySubscriptExpression)pLhs).getSubscriptExpression().accept(this);
            }
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CFunctionCallStatement pStmt) throws CPATransferException {
            Set<MemoryLocation> paramDecls = new HashSet<MemoryLocation>();
            for (CExpression p : pStmt.getFunctionCallExpression().getParameterExpressions()) {
                paramDecls = this.combine(paramDecls, p.accept(this));
            }
            return paramDecls;
        }

        @Override
        public Set<MemoryLocation> visit(CArrayDesignator pArrayDesignator) throws CPATransferException {
            return pArrayDesignator.getSubscriptExpression().accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CArrayRangeDesignator pArrayRangeDesignator) throws CPATransferException {
            Set<MemoryLocation> fst = pArrayRangeDesignator.getCeilExpression().accept(this);
            Set<MemoryLocation> snd = pArrayRangeDesignator.getFloorExpression().accept(this);
            return this.combine(fst, snd);
        }

        @Override
        public Set<MemoryLocation> visit(CFieldDesignator pFieldDesignator) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CArraySubscriptExpression pExp) throws CPATransferException {
            Set<MemoryLocation> fst = pExp.getArrayExpression().accept(this);
            Set<MemoryLocation> snd = pExp.getSubscriptExpression().accept(this);
            return this.combine(fst, snd);
        }

        @Override
        public Set<MemoryLocation> visit(CFieldReference pExp) throws CPATransferException {
            return pExp.getFieldOwner().accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CIdExpression pExp) throws CPATransferException {
            CSimpleDeclaration idDeclaration = pExp.getDeclaration();
            if (idDeclaration instanceof CVariableDeclaration || idDeclaration instanceof CParameterDeclaration) {
                return ImmutableSet.of((Object)MemoryLocation.forDeclaration(idDeclaration));
            }
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CPointerExpression pExp) throws CPATransferException {
            Set<MemoryLocation> uses = pExp.getOperand().accept(this);
            Set<MemoryLocation> pointees = FlowDependenceTransferRelation.getPossibePointees(pExp, this.pointerState, this.varClassification);
            return this.combine(uses, pointees);
        }

        @Override
        public Set<MemoryLocation> visit(CComplexCastExpression pExp) throws CPATransferException {
            return pExp.getOperand().accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CInitializerExpression pExp) throws CPATransferException {
            return pExp.accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CInitializerList pInitializerList) throws CPATransferException {
            Set<MemoryLocation> uses = new HashSet<MemoryLocation>();
            for (CInitializer i : pInitializerList.getInitializers()) {
                uses = this.combine(uses, i.accept(this));
            }
            return uses;
        }

        @Override
        public Set<MemoryLocation> visit(CDesignatedInitializer pExp) throws CPATransferException {
            Set<MemoryLocation> used = pExp.getRightHandSide().accept(this);
            for (CDesignator d : pExp.getDesignators()) {
                used = this.combine(used, d.accept(this));
            }
            return used;
        }

        @Override
        public Set<MemoryLocation> visit(CFunctionCallExpression pExp) throws CPATransferException {
            Set<MemoryLocation> uses = pExp.getFunctionNameExpression().accept(this);
            for (CExpression p : pExp.getParameterExpressions()) {
                uses = this.combine(uses, p.accept(this));
            }
            return uses;
        }

        @Override
        public Set<MemoryLocation> visit(CBinaryExpression pExp) throws CPATransferException {
            return this.combine(pExp.getOperand1().accept(this), pExp.getOperand2().accept(this));
        }

        @Override
        public Set<MemoryLocation> visit(CCastExpression pExp) throws CPATransferException {
            return pExp.getOperand().accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CCharLiteralExpression pExp) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CFloatLiteralExpression pExp) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CIntegerLiteralExpression pExp) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CStringLiteralExpression pExp) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CTypeIdExpression pExp) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CUnaryExpression pExp) throws CPATransferException {
            return pExp.getOperand().accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CImaginaryLiteralExpression pExp) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CAddressOfLabelExpression pExp) throws CPATransferException {
            return pExp.accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CFunctionDeclaration pDecl) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CComplexTypeDeclaration pDecl) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CTypeDefDeclaration pDecl) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CVariableDeclaration pDecl) throws CPATransferException {
            CInitializer init = pDecl.getInitializer();
            if (init != null) {
                return init.accept(this);
            }
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CParameterDeclaration pDecl) throws CPATransferException {
            return pDecl.asVariableDeclaration().accept(this);
        }

        @Override
        public Set<MemoryLocation> visit(CEnumType.CEnumerator pDecl) throws CPATransferException {
            return ImmutableSet.of();
        }

        @Override
        public Set<MemoryLocation> visit(CReturnStatement pNode) throws CPATransferException {
            Optional<CExpression> ret = pNode.getReturnValue();
            if (ret.isPresent()) {
                return ret.orElseThrow().accept(this);
            }
            return ImmutableSet.of();
        }
    }
}

