/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.formulaslicing;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Optional;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.formulaslicing.FormulaSlicingManager;
import org.sosy_lab.cpachecker.cpa.formulaslicing.SlicingState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.RCNFManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.cpachecker.util.predicates.weakening.WeakeningOptions;

public class FormulaSlicingCPA
extends SingleEdgeTransferRelation
implements ConfigurableProgramAnalysis,
AbstractDomain,
PrecisionAdjustment,
StatisticsProvider,
MergeOperator,
AutoCloseable {
    private final StopOperator stopOperator;
    private final FormulaSlicingManager manager;
    private final MergeOperator mergeOperator;
    private final InductiveWeakeningManager inductiveWeakeningManager;
    private final RCNFManager rcnfManager;
    private final Solver solver;

    private FormulaSlicingCPA(Configuration pConfiguration, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA cfa) throws InvalidConfigurationException {
        this.solver = Solver.create(pConfiguration, pLogger, pShutdownNotifier);
        FormulaManagerView formulaManager = this.solver.getFormulaManager();
        PathFormulaManagerImpl origPathFormulaManager = new PathFormulaManagerImpl(formulaManager, pConfiguration, pLogger, pShutdownNotifier, cfa, AnalysisDirection.FORWARD);
        CachingPathFormulaManager pathFormulaManager = new CachingPathFormulaManager(origPathFormulaManager);
        this.inductiveWeakeningManager = new InductiveWeakeningManager(new WeakeningOptions(pConfiguration), this.solver, pLogger, pShutdownNotifier);
        this.rcnfManager = new RCNFManager(pConfiguration);
        this.manager = new FormulaSlicingManager(pConfiguration, pathFormulaManager, formulaManager, cfa, this.inductiveWeakeningManager, this.rcnfManager, this.solver, pLogger);
        this.stopOperator = new StopSepOperator(this);
        this.mergeOperator = this;
    }

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(FormulaSlicingCPA.class);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this;
    }

    @Override
    public AbstractState getInitialState(CFANode node, StateSpacePartition partition) {
        return this.manager.getInitialState(node);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState state, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        return this.manager.getAbstractSuccessors((SlicingState)state, cfaEdge);
    }

    @Override
    public AbstractState join(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        throw new UnsupportedOperationException("FormulaSlicingCPA should be used with its own merge operator");
    }

    @Override
    public boolean isLessOrEqual(AbstractState state1, AbstractState state2) throws CPAException, InterruptedException {
        return this.manager.isLessOrEqual((SlicingState)state1, (SlicingState)state2);
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState state, Precision precision, UnmodifiableReachedSet states, Function<AbstractState, AbstractState> stateProjection, AbstractState fullState) throws CPAException, InterruptedException {
        return this.manager.prec((SlicingState)state, states, fullState);
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        this.manager.collectStatistics(statsCollection);
        this.inductiveWeakeningManager.collectStatistics(statsCollection);
        this.rcnfManager.collectStatistics(statsCollection);
    }

    @Override
    public AbstractState merge(AbstractState state1, AbstractState state2, Precision precision) throws CPAException, InterruptedException {
        return this.manager.merge((SlicingState)state1, (SlicingState)state2);
    }

    @Override
    public void close() {
        this.solver.close();
    }
}

