/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.formulaslicing;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.formulaslicing.FormulaSlicingStatistics;
import org.sosy_lab.cpachecker.cpa.formulaslicing.PathFormulaWithStartSSA;
import org.sosy_lab.cpachecker.cpa.formulaslicing.SlicingAbstractedState;
import org.sosy_lab.cpachecker.cpa.formulaslicing.SlicingIntermediateState;
import org.sosy_lab.cpachecker.cpa.formulaslicing.SlicingState;
import org.sosy_lab.cpachecker.cpa.loopbound.LoopBoundState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.RCNFManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.slicing")
public class FormulaSlicingManager
implements StatisticsProvider {
    @Option(secure=true, description="Check target states reachability")
    private boolean checkTargetStates = true;
    @Option(secure=true, description="Filter lemmas by liveness")
    private boolean filterByLiveness = true;
    private final PathFormulaManager pfmgr;
    private final BooleanFormulaManager bfmgr;
    private final FormulaManagerView fmgr;
    private final InductiveWeakeningManager inductiveWeakeningManager;
    private final Solver solver;
    private final FormulaSlicingStatistics statistics;
    private final RCNFManager rcnfManager;
    private final LiveVariables liveVariables;
    private final LoopStructure loopStructure;
    private final LogManager logger;
    private final Map<Pair<SlicingIntermediateState, SlicingAbstractedState>, SlicingAbstractedState> slicingCache = new HashMap<Pair<SlicingIntermediateState, SlicingAbstractedState>, SlicingAbstractedState>();

    FormulaSlicingManager(Configuration config, CachingPathFormulaManager pPathFormulaManager, FormulaManagerView pFormulaManager, CFA pCfa, InductiveWeakeningManager pInductiveWeakeningManager, RCNFManager pRcnfManager, Solver pSolver, LogManager pLogger) throws InvalidConfigurationException {
        this.logger = pLogger;
        config.inject((Object)this);
        this.fmgr = pFormulaManager;
        this.pfmgr = pPathFormulaManager;
        this.inductiveWeakeningManager = pInductiveWeakeningManager;
        this.solver = pSolver;
        this.bfmgr = pFormulaManager.getBooleanFormulaManager();
        this.rcnfManager = pRcnfManager;
        this.statistics = new FormulaSlicingStatistics(pPathFormulaManager, pSolver);
        Preconditions.checkState((pCfa.getLiveVariables().isPresent() && pCfa.getLoopStructure().isPresent() ? 1 : 0) != 0);
        this.liveVariables = pCfa.getLiveVariables().orElseThrow();
        this.loopStructure = pCfa.getLoopStructure().orElseThrow();
    }

    public Collection<? extends SlicingState> getAbstractSuccessors(SlicingState oldState, CFAEdge edge) throws CPATransferException, InterruptedException {
        this.statistics.propagation.start();
        SlicingIntermediateState iOldState = oldState.isAbstracted() ? this.abstractStateToIntermediate(oldState.asAbstracted()) : oldState.asIntermediate();
        PathFormula outPath = this.pfmgr.makeAnd(iOldState.getPathFormula(), edge);
        SlicingIntermediateState out = SlicingIntermediateState.of(edge.getSuccessor(), outPath, iOldState.getAbstractParent());
        this.statistics.propagation.stop();
        return Collections.singleton(out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<PrecisionAdjustmentResult> prec(SlicingState pState, UnmodifiableReachedSet pStates, AbstractState pFullState) throws CPAException, InterruptedException {
        SlicingAbstractedState out;
        if (pState.isAbstracted()) {
            return Optional.of(PrecisionAdjustmentResult.create(pState, SingletonPrecision.getInstance(), PrecisionAdjustmentResult.Action.CONTINUE));
        }
        SlicingIntermediateState iState = pState.asIntermediate();
        if (this.checkTargetStates && AbstractStates.isTargetState(pFullState) && this.isUnreachableTarget(iState)) {
            return Optional.empty();
        }
        boolean shouldPerformAbstraction = this.shouldPerformAbstraction(iState.getNode(), pFullState);
        if (!shouldPerformAbstraction) return Optional.of(PrecisionAdjustmentResult.create(pState, SingletonPrecision.getInstance(), PrecisionAdjustmentResult.Action.CONTINUE));
        Optional<SlicingAbstractedState> oldState = this.findOldToMerge(pStates, pFullState, pState);
        if (oldState.isPresent()) {
            Optional<SlicingAbstractedState> slicingOut = this.performSlicing(iState, oldState.orElseThrow());
            if (!slicingOut.isPresent()) return Optional.empty();
            out = slicingOut.orElseThrow();
            return Optional.of(PrecisionAdjustmentResult.create(out, SingletonPrecision.getInstance(), PrecisionAdjustmentResult.Action.CONTINUE));
        } else {
            if (this.isUnreachableAbstraction(iState)) {
                return Optional.empty();
            }
            out = SlicingAbstractedState.ofClauses(this.toRcnf(iState), iState.getPathFormula().getSsa(), iState.getPathFormula().getPointerTargetSet(), this.fmgr, iState.getNode(), Optional.of(iState));
        }
        return Optional.of(PrecisionAdjustmentResult.create(out, SingletonPrecision.getInstance(), PrecisionAdjustmentResult.Action.CONTINUE));
    }

    private Set<BooleanFormula> toRcnf(SlicingIntermediateState iState) throws InterruptedException {
        PathFormula pf = iState.getPathFormula();
        CFANode node = iState.getNode();
        SlicingAbstractedState abstractParent = iState.getAbstractParent();
        BooleanFormula transition = this.bfmgr.and(this.fmgr.simplify(pf.getFormula()), this.bfmgr.and(abstractParent.getInstantiatedAbstraction()));
        Set<BooleanFormula> lemmas = this.rcnfManager.toLemmasInstantiated(pf.withFormula(transition), this.fmgr);
        HashSet<BooleanFormula> finalLemmas = new HashSet<BooleanFormula>();
        for (BooleanFormula lemma : lemmas) {
            if (this.filterByLiveness && !this.containsLiveVariables(lemma, node)) continue;
            finalLemmas.add(this.fmgr.uninstantiate(lemma));
        }
        return finalLemmas;
    }

    private boolean containsLiveVariables(BooleanFormula lemma, CFANode node) {
        Set<String> functionNames = this.fmgr.extractFunctionNames((Formula)this.fmgr.uninstantiate(lemma));
        for (ASimpleDeclaration variable : this.liveVariables.getLiveVariablesForNode(node)) {
            String name = variable.getQualifiedName();
            if (name == null || !functionNames.contains(name)) continue;
            return true;
        }
        return false;
    }

    private Optional<SlicingAbstractedState> performSlicing(SlicingIntermediateState iState, SlicingAbstractedState prevToMerge) throws CPAException, InterruptedException {
        Object inductiveUnder;
        Set<BooleanFormula> finalClauses;
        SlicingAbstractedState out = this.slicingCache.get(Pair.of(iState, prevToMerge));
        if (out != null) {
            ++this.statistics.cachedInductiveWeakenings;
            return Optional.of(out);
        }
        this.statistics.inductiveWeakeningLocations.add((Object)iState.getNode());
        SlicingAbstractedState parentState = iState.getAbstractParent();
        ImmutableSet candidateLemmas = FluentIterable.from(prevToMerge.getAbstraction()).filter(input -> this.allVarsInSSAMap((BooleanFormula)input, prevToMerge.getSSA(), iState.getPathFormula().getSsa())).toSet();
        PathFormulaWithStartSSA path = new PathFormulaWithStartSSA(iState.getPathFormula(), iState.getAbstractParent().getSSA());
        if (prevToMerge == parentState && parentState.getInductiveUnder().contains(path)) {
            return Optional.of(SlicingAbstractedState.copyOf(parentState));
        }
        if (this.isUnreachableAbstraction(iState)) {
            return Optional.empty();
        }
        try {
            this.statistics.inductiveWeakening.start();
            if (parentState != prevToMerge) {
                finalClauses = this.inductiveWeakeningManager.findInductiveWeakeningForRCNF(parentState.getSSA(), parentState.getAbstraction(), iState.getPathFormula(), (Set<BooleanFormula>)candidateLemmas);
                inductiveUnder = ImmutableSet.of();
            } else {
                finalClauses = this.inductiveWeakeningManager.findInductiveWeakeningForRCNF(parentState.getSSA(), iState.getPathFormula(), (Set<BooleanFormula>)candidateLemmas);
                inductiveUnder = finalClauses.equals(candidateLemmas) ? Sets.union(prevToMerge.getInductiveUnder(), (Set)ImmutableSet.of((Object)path)) : ImmutableSet.of((Object)path);
            }
        }
        catch (SolverException pE) {
            throw new CPAException("Solver call failed", pE);
        }
        finally {
            this.statistics.inductiveWeakening.stop();
        }
        out = SlicingAbstractedState.makeSliced(finalClauses, prevToMerge.getSSA(), iState.getPathFormula().getPointerTargetSet(), this.fmgr, iState.getNode(), Optional.of(iState), (Iterable<PathFormulaWithStartSSA>)inductiveUnder);
        this.slicingCache.put(Pair.of(iState, prevToMerge), out);
        return Optional.of(out);
    }

    private boolean isUnreachableTarget(SlicingIntermediateState iState) throws InterruptedException, CPAException {
        try {
            this.statistics.reachabilityTargetTimer.start();
            boolean bl = this.isUnreachable(iState);
            return bl;
        }
        finally {
            this.statistics.reachabilityTargetTimer.stop();
        }
    }

    private boolean isUnreachableAbstraction(SlicingIntermediateState iState) throws CPAException, InterruptedException {
        try {
            this.statistics.reachabilityAbstractionTimer.start();
            boolean bl = this.isUnreachable(iState);
            return bl;
        }
        finally {
            this.statistics.reachabilityAbstractionTimer.stop();
        }
    }

    private boolean isUnreachable(SlicingIntermediateState iState) throws InterruptedException, CPAException {
        BooleanFormula prevSlice = this.bfmgr.and(iState.getAbstractParent().getAbstraction());
        BooleanFormula instantiatedParent = this.fmgr.instantiate(prevSlice, iState.getAbstractParent().getSSA());
        BooleanFormula reachabilityQuery = this.bfmgr.and(iState.getPathFormula().getFormula(), instantiatedParent);
        ImmutableSet constraints = ImmutableSet.copyOf((Collection)this.bfmgr.toConjunctionArgs(reachabilityQuery, true));
        CFANode node = iState.getNode();
        this.statistics.satChecksLocations.add((Object)node);
        try {
            return this.solver.isUnsat((Set<BooleanFormula>)constraints, node);
        }
        catch (SolverException pE) {
            this.logger.log(Level.FINE, new Object[]{"Got solver exception while obtaining unsat core;Re-trying without unsat core extraction", pE});
            try {
                return this.solver.isUnsat(reachabilityQuery);
            }
            catch (SolverException pE1) {
                throw new CPAException("Solver error occurred", pE1);
            }
        }
    }

    public SlicingState getInitialState(CFANode node) {
        return SlicingAbstractedState.empty(this.fmgr, node);
    }

    public boolean isLessOrEqual(SlicingState pState1, SlicingState pState2) {
        Preconditions.checkState((pState1.isAbstracted() == pState2.isAbstracted() ? 1 : 0) != 0);
        if (pState1.isAbstracted()) {
            return this.isLessOrEqualAbstracted(pState1.asAbstracted(), pState2.asAbstracted());
        }
        return this.isLessOrEqualIntermediate(pState1.asIntermediate(), pState2.asIntermediate());
    }

    private boolean isLessOrEqualIntermediate(SlicingIntermediateState pState1, SlicingIntermediateState pState2) {
        SlicingIntermediateState iState2;
        SlicingIntermediateState iState1 = pState1.asIntermediate();
        return (iState1.isMergedInto(iState2 = pState2.asIntermediate()) || iState1.getPathFormula().getFormula().equals(iState2.getPathFormula().getFormula())) && this.isLessOrEqualAbstracted(iState1.getAbstractParent(), iState2.getAbstractParent());
    }

    private boolean isLessOrEqualAbstracted(SlicingAbstractedState pState1, SlicingAbstractedState pState2) {
        return pState1.getAbstraction().containsAll(pState2.getAbstraction());
    }

    private SlicingIntermediateState joinIntermediateStates(SlicingIntermediateState newState, SlicingIntermediateState oldState) throws InterruptedException {
        if (!newState.getAbstractParent().equals(oldState.getAbstractParent())) {
            return oldState;
        }
        if (newState.isMergedInto(oldState)) {
            return oldState;
        }
        if (oldState.isMergedInto(newState)) {
            return newState;
        }
        if (oldState.getPathFormula().equals(newState.getPathFormula())) {
            return newState;
        }
        PathFormula mergedPath = this.pfmgr.makeOr(newState.getPathFormula(), oldState.getPathFormula());
        SlicingIntermediateState out = SlicingIntermediateState.of(oldState.getNode(), mergedPath, oldState.getAbstractParent());
        newState.setMergedInto(out);
        oldState.setMergedInto(out);
        return out;
    }

    private SlicingIntermediateState abstractStateToIntermediate(SlicingAbstractedState pSlicingAbstractedState) {
        return SlicingIntermediateState.of(pSlicingAbstractedState.getNode(), this.pfmgr.makeEmptyPathFormulaWithContext(pSlicingAbstractedState.getSSA(), pSlicingAbstractedState.getPointerTargetSet()), pSlicingAbstractedState);
    }

    private boolean shouldPerformAbstraction(CFANode node, AbstractState pFullState) {
        LoopBoundState loopState = AbstractStates.extractStateByType(pFullState, LoopBoundState.class);
        return this.loopStructure.getAllLoopHeads().contains((Object)node) && (loopState == null || loopState.isLoopCounterAbstracted());
    }

    public SlicingState merge(SlicingState pState1, SlicingState pState2) throws InterruptedException {
        Preconditions.checkState((pState1.isAbstracted() == pState2.isAbstracted() ? 1 : 0) != 0);
        if (pState1.isAbstracted()) {
            return pState2;
        }
        SlicingIntermediateState iState1 = pState1.asIntermediate();
        SlicingIntermediateState iState2 = pState2.asIntermediate();
        return this.joinIntermediateStates(iState1, iState2);
    }

    private boolean allVarsInSSAMap(BooleanFormula lemma, SSAMap oldSsa, SSAMap newSsa) {
        for (String var : this.fmgr.extractVariableNames((Formula)lemma)) {
            if (oldSsa.containsVariable(var) == newSsa.containsVariable(var)) continue;
            return false;
        }
        return true;
    }

    private Optional<SlicingAbstractedState> findOldToMerge(UnmodifiableReachedSet states, AbstractState pArgState, SlicingState state) {
        ImmutableSet filteredSiblings = ImmutableSet.copyOf(AbstractStates.projectToType(states.getReached(pArgState), SlicingAbstractedState.class));
        if (filteredSiblings.isEmpty()) {
            return Optional.empty();
        }
        SlicingState a = state;
        while (true) {
            if (a.isAbstracted()) {
                SlicingAbstractedState aState = a.asAbstracted();
                if (filteredSiblings.contains(aState)) {
                    return Optional.of(aState);
                }
                if (!aState.getGeneratingState().isPresent()) {
                    return Optional.empty();
                }
                a = aState.getGeneratingState().orElseThrow().getAbstractParent();
                continue;
            }
            SlicingIntermediateState iState = a.asIntermediate();
            a = iState.getAbstractParent();
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }
}

