/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.formulaslicing;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;

class FormulaSlicingStatistics
implements Statistics {
    private final CachingPathFormulaManager cachingPathFormulaManager;
    private final Solver solver;
    final Timer propagation = new Timer();
    final Timer inductiveWeakening = new Timer();
    final Multiset<CFANode> inductiveWeakeningLocations = HashMultiset.create();
    int cachedInductiveWeakenings = 0;
    final Multiset<CFANode> satChecksLocations = HashMultiset.create();
    final Timer reachabilityTargetTimer = new Timer();
    final Timer reachabilityAbstractionTimer = new Timer();

    FormulaSlicingStatistics(CachingPathFormulaManager pFmgr, Solver pSolver) {
        this.cachingPathFormulaManager = pFmgr;
        this.solver = pSolver;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        this.printTimer(out, this.propagation, "propagating formulas", this.cachingPathFormulaManager.pathFormulaCacheHits);
        this.printTimer(out, this.inductiveWeakening, "inductive weakening", this.cachedInductiveWeakenings);
        this.printTimer(out, this.solver.solverTime, "checking reachability", this.solver.cachedSatChecks);
        this.printTimer(out, this.reachabilityTargetTimer, "checking reachability for target states", "?");
        this.printTimer(out, this.reachabilityAbstractionTimer, "checking reachability for abstraction states", "?");
        out.printf("Locations for checking reachability: %s%n", this.satChecksLocations);
    }

    @Override
    public String getName() {
        return "Formula Slicing Manager";
    }

    private void printTimer(PrintStream out, Timer t, String name, Object cacheHits) {
        out.printf("Time spent in %s: %s (Max: %s), (Avg: %s), (#calls = %s), (#cached = %s) %n", name, t.getSumTime().formatAs(TimeUnit.SECONDS), t.getMaxTime().formatAs(TimeUnit.SECONDS), t.getAvgTime().formatAs(TimeUnit.SECONDS), t.getNumberOfIntervals(), cacheHits);
    }
}

