/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.formulaslicing;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.TruthJUnit;
import java.nio.file.Path;
import java.util.Map;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.predicates.weakening.InductiveWeakeningManager;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

@RunWith(value=Parameterized.class)
public class FormulaSlicingTest {
    @Parameterized.Parameter
    public InductiveWeakeningManager.WEAKENING_STRATEGY weakeningStrategy;
    private static final String TEST_DIR_PATH = "test/programs/formulaslicing/";

    @Parameterized.Parameters(name="{0}")
    public static Object[] getWeakeningStrategies() {
        return InductiveWeakeningManager.WEAKENING_STRATEGY.values();
    }

    @Test
    public void expand_equality_true_assert() throws Exception {
        TruthJUnit.assume().that((Comparable)((Object)this.weakeningStrategy)).isNotEqualTo((Object)InductiveWeakeningManager.WEAKENING_STRATEGY.SYNTACTIC);
        this.check("expand_equality-1.c", CPATestRunner.ExpectedVerdict.TRUE, (Map<String, String>)ImmutableMap.of((Object)"rcnf.expandEquality", (Object)"true", (Object)"cpa.predicate.encodeBitvectorAs", (Object)"integer"));
    }

    @Test
    public void expand_equality_false_assert() throws Exception {
        this.check("expand_equality-2.c", CPATestRunner.ExpectedVerdict.FALSE, (Map<String, String>)ImmutableMap.of((Object)"rcnf.expandEquality", (Object)"true"));
    }

    @Test
    public void simplest_true_assert() throws Exception {
        this.check("simplest-1.c", CPATestRunner.ExpectedVerdict.TRUE);
    }

    @Test
    public void simplest_false_assert() throws Exception {
        this.check("simplest-2.c", CPATestRunner.ExpectedVerdict.FALSE);
    }

    @Test
    public void bad_slice_false_assert() throws Exception {
        this.check("bad_slice.c", CPATestRunner.ExpectedVerdict.FALSE);
    }

    @Test
    public void slice_with_branches_true_assert() throws Exception {
        this.check("slice_with_branches-1.c", CPATestRunner.ExpectedVerdict.TRUE);
    }

    @Test
    public void slice_with_branches_false_assert() throws Exception {
        this.check("slice_with_branches-2.c", CPATestRunner.ExpectedVerdict.FALSE);
    }

    @Ignore(value="With the SYNTACTIC weakening strategy, the analysis is not precise enough and raises a false alarm for this task.")
    @Test
    public void slicing_nested_true_assert() throws Exception {
        this.check("slicing_nested-1.c", CPATestRunner.ExpectedVerdict.TRUE);
    }

    @Test
    public void slicing_nested_false_assert() throws Exception {
        this.check("slicing_nested-2.c", CPATestRunner.ExpectedVerdict.FALSE);
    }

    @Test
    public void slicing_nested_fail_false_assert() throws Exception {
        this.check("slicing_nested_fail.c", CPATestRunner.ExpectedVerdict.FALSE);
    }

    private void check(String filename, CPATestRunner.ExpectedVerdict pExpected) throws Exception {
        this.check(filename, pExpected, (Map<String, String>)ImmutableMap.of());
    }

    private void check(String filename, CPATestRunner.ExpectedVerdict pExpected, Map<String, String> extra) throws Exception {
        String fullPath = Path.of(TEST_DIR_PATH, filename).toString();
        Configuration config = this.getProperties(extra);
        try {
            Solver.create(config, LogManager.createNullLogManager(), ShutdownNotifier.createDummy()).close();
        }
        catch (InvalidConfigurationException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof UnsatisfiedLinkError) {
                TruthJUnit.assume().withMessage("Z3 requires newer libc than Ubuntu 18.04 provides").that(cause).hasMessageThat().doesNotContain((CharSequence)"version `GLIBCXX_3.4.26' not found");
            }
            throw e;
        }
        TestResults results = CPATestRunner.run(config, fullPath);
        if (pExpected == CPATestRunner.ExpectedVerdict.TRUE) {
            results.assertIsSafe();
        } else if (pExpected == CPATestRunner.ExpectedVerdict.FALSE) {
            results.assertIsUnsafe();
        }
    }

    private Configuration getProperties(Map<String, String> extra) throws InvalidConfigurationException {
        return TestDataTools.configurationForTest().loadFromResource(FormulaSlicingTest.class, "formula-slicing.properties").setOption("cpa.slicing.weakeningStrategy", this.weakeningStrategy.toString()).setOptions(extra).build();
    }
}

