/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.formulaslicing;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.resources.WalltimeLimit;

@Options(prefix="cpa.slicing")
public class LoopTransitionFinder
implements StatisticsProvider {
    @Option(secure=true, description="Apply AND- LBE transformation to loop transition relation.")
    private boolean applyLBETransformation = true;
    @Option(secure=true, description="Time for loop generation before aborting.\n(Use seconds or specify a unit; 0 for infinite)")
    @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=0L)
    private TimeSpan timeForLoopGeneration = TimeSpan.ofSeconds((long)0L);
    private final PathFormulaManager pfmgr;
    private final LogManager logger;
    private final LoopStructure loopStructure;
    private final Stats statistics;
    private final ShutdownNotifier shutdownNotifier;
    private final Map<CFANode, Table<CFANode, CFANode, EdgeWrapper>> LBEcache;

    public LoopTransitionFinder(Configuration config, LoopStructure pLoopStructure, PathFormulaManager pPathFormulaManager, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.shutdownNotifier = pShutdownNotifier;
        config.inject((Object)this);
        this.statistics = new Stats();
        this.pfmgr = pPathFormulaManager;
        this.logger = pLogger;
        this.loopStructure = pLoopStructure;
        this.LBEcache = new HashMap<CFANode, Table<CFANode, CFANode, EdgeWrapper>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathFormula generateLoopTransition(SSAMap start, PointerTargetSet pts, CFANode loopHead) throws CPATransferException, InterruptedException {
        PathFormula out;
        Preconditions.checkState((boolean)this.loopStructure.getAllLoopHeads().contains((Object)loopHead));
        ShutdownManager loopGenerationShutdown = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
        ResourceLimitChecker limits = null;
        if (!this.timeForLoopGeneration.isEmpty()) {
            WalltimeLimit l = WalltimeLimit.fromNowOn(this.timeForLoopGeneration);
            limits = new ResourceLimitChecker(loopGenerationShutdown, Collections.singletonList(l));
            limits.start();
        }
        this.statistics.LBEencodingTimer.start();
        try {
            out = this.performLargeBlockEncoding(loopHead, start, pts);
        }
        finally {
            this.statistics.LBEencodingTimer.stop();
        }
        if (limits != null && !this.timeForLoopGeneration.isEmpty()) {
            limits.cancel();
        }
        return out;
    }

    private List<CFAEdge> getEdgesInSCC(CFANode node) {
        SummarizingVisitorForward forwardVisitor = new SummarizingVisitorForward();
        SummarizingVisitorBackwards backwardsVisitor = new SummarizingVisitorBackwards();
        CFATraversal.dfs().traverse(node, forwardVisitor);
        CFATraversal.dfs().backwards().traverse(node, backwardsVisitor);
        ImmutableSet forwardsReachable = ImmutableSet.copyOf(forwardVisitor.getVisitedEdges());
        ImmutableSet backwardsReachable = ImmutableSet.copyOf(backwardsVisitor.getVisitedEdges());
        Sets.SetView intersection = Sets.intersection((Set)forwardsReachable, (Set)backwardsReachable);
        return ImmutableList.copyOf((Collection)intersection);
    }

    private PathFormula performLargeBlockEncoding(CFANode loopHead, SSAMap start, PointerTargetSet pts) throws CPATransferException, InterruptedException {
        Table<CFANode, CFANode, EdgeWrapper> out;
        if (this.LBEcache.containsKey(loopHead)) {
            out = this.LBEcache.get(loopHead);
        } else {
            boolean changed;
            List<CFAEdge> edgesInLoop = this.getEdgesInSCC(loopHead);
            out = this.convert(edgesInLoop);
            Preconditions.checkState((!edgesInLoop.isEmpty() ? 1 : 0) != 0);
            do {
                this.shutdownNotifier.shutdownIfNecessary();
                changed = false;
                if (!this.applyLBETransformation || !this.applyLargeBlockEncodingTransformationPass(out)) continue;
                changed = true;
            } while (changed);
            this.LBEcache.put(loopHead, out);
        }
        PathFormula empty = this.pfmgr.makeEmptyPathFormulaWithContext(start, pts);
        EdgeWrapper outEdge = out.size() == 1 ? (EdgeWrapper)out.values().iterator().next() : new OrEdge((List<EdgeWrapper>)ImmutableList.copyOf((Collection)out.values()));
        return outEdge.toPathFormula(empty);
    }

    private boolean applyLargeBlockEncodingTransformationPass(Table<CFANode, CFANode, EdgeWrapper> out) {
        for (Table.Cell cell : out.cellSet()) {
            Collection candidates;
            EdgeWrapper e = (EdgeWrapper)Preconditions.checkNotNull((Object)((EdgeWrapper)cell.getValue()));
            CFANode predecessor = e.getPredecessor();
            if (this.loopStructure.getAllLoopHeads().contains((Object)predecessor) || e.getPredecessor().equals(e.getSuccessor()) || (candidates = out.row((Object)predecessor).values()).size() < 1) continue;
            out.remove((Object)e.getSuccessor(), (Object)e.getPredecessor());
            this.logger.log(Level.ALL, new Object[]{"Removing", e});
            for (EdgeWrapper candidate : ImmutableList.copyOf(candidates)) {
                this.logger.log(Level.ALL, new Object[]{"Removing", candidate});
                out.remove((Object)candidate.getSuccessor(), (Object)candidate.getPredecessor());
                EdgeWrapper added = new AndEdge((List<EdgeWrapper>)ImmutableList.of((Object)candidate, (Object)e));
                EdgeWrapper alternative = (EdgeWrapper)out.get((Object)added.getSuccessor(), (Object)added.getPredecessor());
                if (alternative != null) {
                    added = new OrEdge((List<EdgeWrapper>)ImmutableList.of((Object)added, (Object)alternative));
                    this.logger.log(Level.ALL, new Object[]{"Removing", alternative});
                    out.remove((Object)alternative.getSuccessor(), (Object)alternative.getPredecessor());
                }
                this.logger.log(Level.ALL, new Object[]{"Adding", added});
                out.put((Object)added.getSuccessor(), (Object)added.getPredecessor(), (Object)added);
            }
            return true;
        }
        return false;
    }

    private Table<CFANode, CFANode, EdgeWrapper> convert(Collection<CFAEdge> edges) {
        HashBasedTable out = HashBasedTable.create();
        for (CFAEdge e : edges) {
            out.put((Object)e.getSuccessor(), (Object)e.getPredecessor(), (Object)new SingleEdge(e));
        }
        return out;
    }

    private String prettyPrintHelper(Iterable<EdgeWrapper> edges, String prefix, String funcName) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(funcName).append("(\n");
        for (EdgeWrapper w : edges) {
            sb.append(w.prettyPrint(prefix + "\t")).append(",\n");
        }
        sb.append(prefix).append(")");
        return sb.toString();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    private class OrEdge
    implements EdgeWrapper {
        private final List<EdgeWrapper> edges;
        private final CFANode predecessor;
        private final CFANode successor;

        OrEdge(List<EdgeWrapper> pEdges) {
            Preconditions.checkState((!pEdges.isEmpty() ? 1 : 0) != 0);
            this.edges = ImmutableList.copyOf(pEdges);
            this.predecessor = this.edges.iterator().next().getPredecessor();
            this.successor = this.edges.iterator().next().getSuccessor();
        }

        @Override
        public CFANode getPredecessor() {
            return this.predecessor;
        }

        @Override
        public CFANode getSuccessor() {
            return this.successor;
        }

        @Override
        public PathFormula toPathFormula(PathFormula prev) throws CPATransferException, InterruptedException {
            Preconditions.checkState((!this.edges.isEmpty() ? 1 : 0) != 0);
            EdgeWrapper first = this.edges.iterator().next();
            PathFormula out = first.toPathFormula(prev);
            for (EdgeWrapper edge : this.edges) {
                if (edge == first) continue;
                out = LoopTransitionFinder.this.pfmgr.makeOr(out, edge.toPathFormula(prev));
            }
            return out;
        }

        public String toString() {
            return this.prettyPrint("");
        }

        @Override
        public String prettyPrint(String prefix) {
            return LoopTransitionFinder.this.prettyPrintHelper(this.edges, prefix, "OR");
        }
    }

    private class AndEdge
    implements EdgeWrapper {
        private final List<EdgeWrapper> edges;
        private final CFANode predecessor;
        private final CFANode successor;

        AndEdge(List<EdgeWrapper> pEdges) {
            Preconditions.checkState((!pEdges.isEmpty() ? 1 : 0) != 0);
            ArrayList<EdgeWrapper> l = new ArrayList<EdgeWrapper>();
            for (EdgeWrapper w : pEdges) {
                if (w instanceof AndEdge) {
                    l.addAll(((AndEdge)w).edges);
                    continue;
                }
                l.add(w);
            }
            this.edges = ImmutableList.copyOf(l);
            this.predecessor = this.edges.iterator().next().getPredecessor();
            this.successor = ((EdgeWrapper)Iterables.getLast(this.edges)).getSuccessor();
        }

        @Override
        public CFANode getPredecessor() {
            return this.predecessor;
        }

        @Override
        public CFANode getSuccessor() {
            return this.successor;
        }

        @Override
        public PathFormula toPathFormula(PathFormula prev) throws CPATransferException, InterruptedException {
            for (EdgeWrapper edge : this.edges) {
                prev = edge.toPathFormula(prev);
            }
            return prev;
        }

        public String toString() {
            return this.prettyPrint("");
        }

        @Override
        public String prettyPrint(String prefix) {
            return LoopTransitionFinder.this.prettyPrintHelper(this.edges, prefix, "AND");
        }
    }

    private class SingleEdge
    implements EdgeWrapper {
        private final CFAEdge edge;

        SingleEdge(CFAEdge e) {
            this.edge = e;
        }

        @Override
        public CFANode getPredecessor() {
            return this.edge.getPredecessor();
        }

        @Override
        public CFANode getSuccessor() {
            return this.edge.getSuccessor();
        }

        @Override
        public PathFormula toPathFormula(PathFormula prev) throws CPATransferException, InterruptedException {
            return LoopTransitionFinder.this.pfmgr.makeAnd(prev, this.edge);
        }

        public String toString() {
            return this.prettyPrint("");
        }

        @Override
        public String prettyPrint(String prefix) {
            return String.format("%s%s->%s(%s)", prefix, this.getPredecessor(), this.getSuccessor(), this.edge.getCode());
        }
    }

    private static interface EdgeWrapper {
        public CFANode getPredecessor();

        public CFANode getSuccessor();

        public PathFormula toPathFormula(PathFormula var1) throws CPATransferException, InterruptedException;

        public String prettyPrint(String var1);
    }

    private static final class SummarizingVisitorBackwards
    extends SummarizingVisitor {
        private final Set<CFANode> expectedCallsites = new HashSet<CFANode>();

        private SummarizingVisitorBackwards() {
        }

        @Override
        CFATraversal.TraversalProcess onReturnEdge(CFAEdge edge) {
            CFANode callsite = edge.getSuccessor().getEnteringSummaryEdge().getPredecessor();
            this.expectedCallsites.add(callsite);
            this.visitedEdges.add(edge);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        CFATraversal.TraversalProcess onCallEdge(CFAEdge edge) {
            if (this.expectedCallsites.contains(edge.getPredecessor())) {
                this.visitedEdges.add(edge);
                return CFATraversal.TraversalProcess.CONTINUE;
            }
            return CFATraversal.TraversalProcess.SKIP;
        }
    }

    private static class SummarizingVisitorForward
    extends SummarizingVisitor {
        private final Set<CFANode> expectedJoinNodes = new HashSet<CFANode>();

        private SummarizingVisitorForward() {
        }

        @Override
        CFATraversal.TraversalProcess onCallEdge(CFAEdge callEdge) {
            this.visitedEdges.add(callEdge);
            this.expectedJoinNodes.add(callEdge.getPredecessor().getLeavingSummaryEdge().getSuccessor());
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        CFATraversal.TraversalProcess onReturnEdge(CFAEdge returnEdge) {
            if (this.expectedJoinNodes.contains(returnEdge.getSuccessor())) {
                this.visitedEdges.add(returnEdge);
                return CFATraversal.TraversalProcess.CONTINUE;
            }
            return CFATraversal.TraversalProcess.SKIP;
        }
    }

    private static abstract class SummarizingVisitor
    implements CFATraversal.CFAVisitor {
        final Set<CFAEdge> visitedEdges = new HashSet<CFAEdge>();

        private SummarizingVisitor() {
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            if (this.visitedEdges.contains(edge)) {
                return CFATraversal.TraversalProcess.SKIP;
            }
            if (edge instanceof FunctionCallEdge) {
                return this.onCallEdge(edge);
            }
            if (edge instanceof FunctionReturnEdge) {
                return this.onReturnEdge(edge);
            }
            if (edge instanceof FunctionSummaryEdge) {
                return CFATraversal.TraversalProcess.SKIP;
            }
            this.visitedEdges.add(edge);
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        abstract CFATraversal.TraversalProcess onCallEdge(CFAEdge var1);

        abstract CFATraversal.TraversalProcess onReturnEdge(CFAEdge var1);

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode node) {
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        private ImmutableSet<CFAEdge> getVisitedEdges() {
            return ImmutableSet.copyOf(this.visitedEdges);
        }
    }

    private static class Stats
    implements Statistics {
        final Timer LBEencodingTimer = new Timer();

        private Stats() {
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            out.printf("Time spent in LBE Encoding: %s (Max: %s), (Avg: %s)%n", this.LBEencodingTimer, this.LBEencodingTimer.getMaxTime().formatAs(TimeUnit.SECONDS), this.LBEencodingTimer.getAvgTime().formatAs(TimeUnit.SECONDS));
        }

        @Override
        public String getName() {
            return "LBE Encoding of Loops";
        }
    }
}

