/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.formulaslicing;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.Map;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.cpa.formulaslicing.LoopTransitionFinder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

public class LoopTransitionFinderTest {
    private CFACreator creator;
    private LogManager logger;
    private PathFormulaManager pfmgr;
    private FormulaManagerView fmgr;
    private Configuration config;
    private ShutdownNotifier notifier;
    private Solver solver;
    private BooleanFormulaManager bfmgr;

    @Before
    public void setUp() throws Exception {
        this.config = TestDataTools.configurationForTest().setOptions((Map)ImmutableMap.of((Object)"solver.solver", (Object)"z3")).build();
        this.notifier = ShutdownNotifier.createDummy();
        this.logger = LogManager.createTestLogManager();
        try {
            this.solver = Solver.create(this.config, this.logger, this.notifier);
        }
        catch (InvalidConfigurationException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (cause instanceof UnsatisfiedLinkError) {
                TruthJUnit.assume().withMessage("Z3 requires newer libc than Ubuntu 18.04 provides").that(cause).hasMessageThat().doesNotContain((CharSequence)"version `GLIBCXX_3.4.26' not found");
            }
            throw e;
        }
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pfmgr = new PathFormulaManagerImpl(this.fmgr, this.config, this.logger, this.notifier, MachineModel.LINUX32, Optional.empty(), AnalysisDirection.FORWARD);
        this.creator = new CFACreator(this.config, this.logger, this.notifier);
    }

    @Test
    public void testGetEdgesInLoop() throws Exception {
        CFA cfa = TestDataTools.toSingleFunctionCFA(this.creator, "int x = 0; int y = 0;", "while (1) {", "x += 1; y += 1;", "}");
        CFANode loopHead = (CFANode)cfa.getAllLoopHeads().orElseThrow().iterator().next();
        LoopTransitionFinder loopTransitionFinder = new LoopTransitionFinder(this.config, cfa.getLoopStructure().orElseThrow(), this.pfmgr, this.logger, this.notifier);
        PathFormula loopTransition = loopTransitionFinder.generateLoopTransition(SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), loopHead);
        PathFormula expected = this.fromLine("int x, y; x += 1; y += 1;");
        this.assertEquivalent(loopTransition.getFormula(), expected.getFormula());
    }

    @Test
    public void testWithConditional() throws Exception {
        CFA cfa = TestDataTools.toSingleFunctionCFA(this.creator, "int x = 0; int y = 0; int p = 1;", "while (1) {", "if (p) { x += 1; } else { y += 1; }", "}");
        CFANode loopHead = (CFANode)cfa.getAllLoopHeads().orElseThrow().iterator().next();
        LoopTransitionFinder loopTransitionFinder = new LoopTransitionFinder(this.config, cfa.getLoopStructure().orElseThrow(), this.pfmgr, this.logger, this.notifier);
        PathFormula summary = loopTransitionFinder.generateLoopTransition(SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), loopHead);
        PathFormula expected = this.fromLine("int x, y, p; if (p) { x += 1; } else { y += 1; }; ");
        this.assertEquivalent(summary.getFormula(), expected.getFormula());
    }

    @Test
    public void testInterproceduralSummary() throws Exception {
        CFA cfa = TestDataTools.toMultiFunctionCFA(this.creator, "void log() {}", "int main() {", "int x;", "while (__VERIFIER_nondet_int()) {", "log();", "x += 1;", "log();", "}", "while (__VERIFIER_nondet_int()) {", "log();", "x += 2;", "log();", "}", "}");
        CFANode loopHead = (CFANode)cfa.getAllLoopHeads().orElseThrow().iterator().next();
        LoopTransitionFinder loopTransitionFinder = new LoopTransitionFinder(this.config, cfa.getLoopStructure().orElseThrow(), this.pfmgr, this.logger, this.notifier);
        PathFormula summary = loopTransitionFinder.generateLoopTransition(SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), loopHead);
        PathFormula expected = this.fromLine("int x; x += 1;");
        this.assertEquivalent(summary.getFormula(), expected.getFormula());
    }

    private PathFormula fromLine(String line) throws Exception {
        return TestDataTools.toPathFormula(TestDataTools.toSingleFunctionCFA(this.creator, line), SSAMap.emptySSAMap(), this.pfmgr, true);
    }

    private void assertEquivalent(BooleanFormula output, BooleanFormula expected) throws SolverException, InterruptedException {
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfmgr.and(output, this.bfmgr.not(expected)))).isTrue();
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfmgr.and(this.bfmgr.not(output), expected))).isTrue();
    }
}

