/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.formulaslicing;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.formulaslicing.PathFormulaWithStartSSA;
import org.sosy_lab.cpachecker.cpa.formulaslicing.SlicingIntermediateState;
import org.sosy_lab.cpachecker.cpa.formulaslicing.SlicingState;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

final class SlicingAbstractedState
extends SlicingState
implements FormulaReportingState,
Graphable {
    private final ImmutableSet<BooleanFormula> lemmas;
    private final SSAMap ssaMap;
    private final PointerTargetSet pointerTargetSet;
    private final FormulaManagerView fmgr;
    private final Optional<SlicingIntermediateState> generatingState;
    private final CFANode node;
    private final ImmutableSet<PathFormulaWithStartSSA> inductiveUnder;
    private transient int hashCache = 0;

    private SlicingAbstractedState(Set<BooleanFormula> pSlice, SSAMap pSsaMap, PointerTargetSet pPointerTargetSet, FormulaManagerView pFmgr, Optional<SlicingIntermediateState> pGeneratingState, CFANode pNode, Iterable<PathFormulaWithStartSSA> pInductiveUnder) {
        this.inductiveUnder = ImmutableSet.copyOf(pInductiveUnder);
        this.lemmas = ImmutableSet.copyOf(pSlice);
        this.ssaMap = pSsaMap;
        this.pointerTargetSet = pPointerTargetSet;
        this.fmgr = pFmgr;
        this.generatingState = pGeneratingState;
        this.node = pNode;
    }

    public Set<PathFormulaWithStartSSA> getInductiveUnder() {
        return this.inductiveUnder;
    }

    public static SlicingAbstractedState ofClauses(Set<BooleanFormula> pSlice, SSAMap pSsaMap, PointerTargetSet pPointerTargetSet, FormulaManagerView pFmgr, CFANode pNode, Optional<SlicingIntermediateState> pGeneratingState) {
        return new SlicingAbstractedState(pSlice, pSsaMap, pPointerTargetSet, pFmgr, pGeneratingState, pNode, (Iterable<PathFormulaWithStartSSA>)ImmutableSet.of());
    }

    public static SlicingAbstractedState makeSliced(Set<BooleanFormula> pSlice, SSAMap pSsaMap, PointerTargetSet pPointerTargetSet, FormulaManagerView pFmgr, CFANode pNode, Optional<SlicingIntermediateState> pGeneratingState, Iterable<PathFormulaWithStartSSA> trace) {
        return new SlicingAbstractedState(pSlice, pSsaMap, pPointerTargetSet, pFmgr, pGeneratingState, pNode, trace);
    }

    public static SlicingAbstractedState copyOf(SlicingAbstractedState sliced) {
        return new SlicingAbstractedState((Set<BooleanFormula>)sliced.lemmas, sliced.ssaMap, sliced.pointerTargetSet, sliced.fmgr, sliced.generatingState, sliced.node, (Iterable<PathFormulaWithStartSSA>)sliced.inductiveUnder);
    }

    public Optional<SlicingIntermediateState> getGeneratingState() {
        return this.generatingState;
    }

    public SSAMap getSSA() {
        return this.ssaMap;
    }

    public PointerTargetSet getPointerTargetSet() {
        return this.pointerTargetSet;
    }

    public boolean isInitial() {
        return !this.generatingState.isPresent();
    }

    public CFANode getNode() {
        return this.node;
    }

    public Set<BooleanFormula> getAbstraction() {
        return this.lemmas;
    }

    public Set<BooleanFormula> getInstantiatedAbstraction() {
        HashSet<BooleanFormula> out = new HashSet<BooleanFormula>(this.lemmas.size());
        for (BooleanFormula f : this.lemmas) {
            out.add(this.fmgr.instantiate(f, this.ssaMap));
        }
        return out;
    }

    public static SlicingAbstractedState empty(FormulaManagerView pFmgr, CFANode startingNode) {
        return new SlicingAbstractedState((Set<BooleanFormula>)ImmutableSet.of(), SSAMap.emptySSAMap(), PointerTargetSet.emptyPointerTargetSet(), pFmgr, Optional.empty(), startingNode, (Iterable<PathFormulaWithStartSSA>)ImmutableSet.of());
    }

    @Override
    public boolean isAbstracted() {
        return true;
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView manager) {
        BooleanFormula constraint = this.fmgr.getBooleanFormulaManager().and((Collection<BooleanFormula>)this.lemmas);
        return manager.translateFrom(constraint, this.fmgr);
    }

    @Override
    public String toDOTLabel() {
        return Joiner.on((String)"\n---\n").join(this.lemmas);
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public String toString() {
        return this.lemmas.toString();
    }

    @Override
    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        SlicingAbstractedState that = (SlicingAbstractedState)pO;
        return Objects.equals(this.lemmas, that.lemmas) && Objects.equals(this.ssaMap, that.ssaMap) && Objects.equals(this.pointerTargetSet, that.pointerTargetSet);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Objects.hash(this.lemmas, this.ssaMap, this.pointerTargetSet);
        }
        return this.hashCache;
    }
}

