/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.functionpointer;

import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerState;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerTransferRelation;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

class ExpressionValueVisitor
extends DefaultCExpressionVisitor<FunctionPointerState.FunctionPointerTarget, UnrecognizedCodeException>
implements CRightHandSideVisitor<FunctionPointerState.FunctionPointerTarget, UnrecognizedCodeException> {
    private final FunctionPointerState.Builder state;
    private final FunctionPointerState.FunctionPointerTarget targetForInvalidPointers;

    ExpressionValueVisitor(FunctionPointerState.Builder pElement, FunctionPointerState.FunctionPointerTarget pTargetForInvalidPointers) {
        this.state = pElement;
        this.targetForInvalidPointers = pTargetForInvalidPointers;
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CArraySubscriptExpression pE) throws UnrecognizedCodeException {
        if (pE.getSubscriptExpression() instanceof CIntegerLiteralExpression && pE.getArrayExpression() instanceof CIdExpression) {
            return this.state.getTarget(FunctionPointerTransferRelation.arrayElementVariable(pE));
        }
        return (FunctionPointerState.FunctionPointerTarget)super.visit(pE);
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CUnaryExpression pE) {
        if (pE.getOperator() == CUnaryExpression.UnaryOperator.AMPER && pE.getOperand() instanceof CIdExpression) {
            return this.extractFunctionId((CIdExpression)pE.getOperand());
        }
        return this.visitDefault(pE);
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CPointerExpression pE) {
        if (pE.getOperand() instanceof CIdExpression) {
            return this.extractFunctionId((CIdExpression)pE.getOperand());
        }
        return this.visitDefault(pE);
    }

    private FunctionPointerState.FunctionPointerTarget extractFunctionId(CIdExpression operand) {
        CPointerType t;
        if (operand.getDeclaration() != null && operand.getDeclaration().getType() instanceof CFunctionType || operand.getExpressionType() instanceof CFunctionType) {
            return new FunctionPointerState.NamedFunctionTarget(operand.getName());
        }
        if (operand.getExpressionType() instanceof CPointerType && (t = (CPointerType)operand.getExpressionType()).getType() instanceof CFunctionType) {
            return this.state.getTarget(operand.getDeclaration().getQualifiedName());
        }
        return this.visitDefault(operand);
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CIdExpression pE) {
        if (pE.getDeclaration() instanceof CFunctionDeclaration || pE.getExpressionType() instanceof CFunctionType) {
            return new FunctionPointerState.NamedFunctionTarget(pE.getName());
        }
        return this.state.getTarget(pE.getDeclaration().getQualifiedName());
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CCastExpression pE) throws UnrecognizedCodeException {
        return pE.getOperand().accept(this);
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CComplexCastExpression pE) throws UnrecognizedCodeException {
        return FunctionPointerState.UnknownTarget.getInstance();
    }

    @Override
    protected FunctionPointerState.FunctionPointerTarget visitDefault(CExpression pExp) {
        return FunctionPointerState.UnknownTarget.getInstance();
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CFunctionCallExpression pIastFunctionCallExpression) {
        return FunctionPointerState.UnknownTarget.getInstance();
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CCharLiteralExpression pE) {
        return this.targetForInvalidPointers;
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CFloatLiteralExpression pE) {
        return this.targetForInvalidPointers;
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CIntegerLiteralExpression pE) {
        return this.targetForInvalidPointers;
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CStringLiteralExpression pE) {
        return this.targetForInvalidPointers;
    }

    @Override
    public FunctionPointerState.FunctionPointerTarget visit(CImaginaryLiteralExpression pE) {
        return this.targetForInvalidPointers;
    }
}

