/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.functionpointer;

import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.defaults.GenericReducer;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerState;

class FunctionPointerReducer
extends GenericReducer<FunctionPointerState, Precision> {
    FunctionPointerReducer() {
    }

    @Override
    protected FunctionPointerState getVariableReducedState0(FunctionPointerState pExpandedState, Block pContext, CFANode pCallNode) {
        FunctionPointerState.Builder builder = pExpandedState.createBuilder();
        for (String trackedVar : pExpandedState.getTrackedVariables()) {
            if (pContext.getVariables().contains(trackedVar)) continue;
            builder.setTarget(trackedVar, FunctionPointerState.UnknownTarget.getInstance());
        }
        return builder.build();
    }

    @Override
    protected FunctionPointerState getVariableExpandedState0(FunctionPointerState pRootState, Block pReducedContext, FunctionPointerState pReducedState) {
        FunctionPointerState.Builder diffElement = pReducedState.createBuilder();
        for (String trackedVar : pRootState.getTrackedVariables()) {
            if (pReducedContext.getVariables().contains(trackedVar)) continue;
            diffElement.setTarget(trackedVar, pRootState.getTarget(trackedVar));
        }
        return diffElement.build();
    }

    @Override
    protected Precision getVariableReducedPrecision0(Precision pPrecision, Block pContext) {
        return pPrecision;
    }

    @Override
    protected Precision getVariableExpandedPrecision0(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        return pRootPrecision;
    }

    @Override
    protected Object getHashCodeForState0(FunctionPointerState pState, Precision pPrecision) {
        return pState;
    }

    @Override
    protected FunctionPointerState rebuildStateAfterFunctionCall0(FunctionPointerState pCallState, FunctionPointerState entryState, FunctionPointerState pExpandedState, FunctionExitNode exitLocation) {
        FunctionPointerState.Builder rebuildState = pCallState.createBuilder();
        for (String trackedVar : pCallState.getTrackedVariables()) {
            if (FunctionPointerReducer.isOnFunctionStack(trackedVar)) continue;
            rebuildState.setTarget(trackedVar, FunctionPointerState.UnknownTarget.getInstance());
        }
        Optional<? extends AVariableDeclaration> retval = exitLocation.getEntryNode().getReturnVariable();
        for (String trackedVar : pExpandedState.getTrackedVariables()) {
            if (!FunctionPointerReducer.isOnFunctionStack(trackedVar)) {
                rebuildState.setTarget(trackedVar, pExpandedState.getTarget(trackedVar));
                continue;
            }
            if (!retval.isPresent() || !retval.get().getQualifiedName().equals(trackedVar) || pExpandedState.getTarget(trackedVar) == FunctionPointerState.UnknownTarget.getInstance()) continue;
            rebuildState.setTarget(trackedVar, pExpandedState.getTarget(trackedVar));
        }
        return rebuildState.build();
    }

    private static boolean isOnFunctionStack(String var) {
        return var.contains("::");
    }
}

