/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.functionpointer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class FunctionPointerState
implements LatticeAbstractState<FunctionPointerState>,
Serializable,
Graphable {
    private static final long serialVersionUID = -1951853216031911649L;
    private final PersistentSortedMap<String, FunctionPointerTarget> pointerVariableValues;
    private transient int hashCode;
    private static final FunctionPointerState EMPTY_STATE = new FunctionPointerState((PersistentSortedMap<String, FunctionPointerTarget>)PathCopyingPersistentTreeMap.of());

    private FunctionPointerState(PersistentSortedMap<String, FunctionPointerTarget> pValues) {
        this.pointerVariableValues = pValues;
    }

    public static FunctionPointerState createEmptyState() {
        return EMPTY_STATE;
    }

    public Builder createBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(str, this.pointerVariableValues);
        str.append("]");
        return str.toString();
    }

    @Override
    public String toDOTLabel() {
        return this.pointerVariableValues.isEmpty() ? "" : this.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    public FunctionPointerTarget getTarget(String variableName) {
        return (FunctionPointerTarget)this.pointerVariableValues.getOrDefault((Object)variableName, (Object)UnknownTarget.getInstance());
    }

    Set<String> getTrackedVariables() {
        return this.pointerVariableValues.keySet();
    }

    @Override
    public boolean isLessOrEqual(FunctionPointerState pElement) {
        if (this.pointerVariableValues.size() < pElement.pointerVariableValues.size()) {
            return false;
        }
        return this.pointerVariableValues.entrySet().containsAll(pElement.pointerVariableValues.entrySet());
    }

    @Override
    public FunctionPointerState join(FunctionPointerState other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (!(pObj instanceof FunctionPointerState)) {
            return false;
        }
        return this.pointerVariableValues.equals(((FunctionPointerState)pObj).pointerVariableValues);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.pointerVariableValues.hashCode();
        }
        return this.hashCode;
    }

    public static class Builder {
        private final FunctionPointerState oldState;
        private PersistentSortedMap<String, FunctionPointerTarget> values;

        private Builder(FunctionPointerState pOldState) {
            this.oldState = (FunctionPointerState)Preconditions.checkNotNull((Object)pOldState);
            this.values = this.oldState.pointerVariableValues;
        }

        public FunctionPointerTarget getTarget(String variableName) {
            return (FunctionPointerTarget)this.values.getOrDefault((Object)variableName, (Object)UnknownTarget.getInstance());
        }

        public Set<String> getValues() {
            return this.values.keySet();
        }

        public void setTarget(String variableName, FunctionPointerTarget target) {
            this.values = target == UnknownTarget.getInstance() ? this.values.removeAndCopy((Object)variableName) : this.values.putAndCopy((Object)variableName, (Object)target);
        }

        void clearVariablesForFunction(String function) {
            for (String var : CFAUtils.filterVariablesOfFunction(this.values.keySet(), function)) {
                this.values = this.values.removeAndCopy((Object)var);
            }
        }

        public FunctionPointerState build() {
            if (this.values == this.oldState.pointerVariableValues) {
                return this.oldState;
            }
            if (this.values.isEmpty()) {
                return EMPTY_STATE;
            }
            return new FunctionPointerState(this.values);
        }
    }

    public static final class NamedFunctionTarget
    implements FunctionPointerTarget,
    Serializable {
        private static final long serialVersionUID = 9001748459212617220L;
        private final String functionName;

        public NamedFunctionTarget(String pFunctionName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pFunctionName) ? 1 : 0) != 0);
            this.functionName = pFunctionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String toString() {
            return this.getFunctionName();
        }

        public boolean equals(Object pObj) {
            return pObj instanceof NamedFunctionTarget && ((NamedFunctionTarget)pObj).functionName.equals(this.functionName);
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }
    }

    public static final class InvalidTarget
    implements FunctionPointerTarget,
    Serializable {
        private static final long serialVersionUID = 7067934518471075538L;
        private static final InvalidTarget instance = new InvalidTarget();

        private InvalidTarget() {
        }

        public String toString() {
            return "INVALID";
        }

        public static InvalidTarget getInstance() {
            return instance;
        }

        public boolean equals(Object pObj) {
            return pObj instanceof InvalidTarget;
        }

        public int hashCode() {
            return 1;
        }
    }

    public static final class UnknownTarget
    implements FunctionPointerTarget {
        private static final UnknownTarget instance = new UnknownTarget();

        private UnknownTarget() {
        }

        public String toString() {
            return "UNKNOWN";
        }

        public static UnknownTarget getInstance() {
            return instance;
        }

        public boolean equals(Object pObj) {
            return pObj instanceof UnknownTarget;
        }

        public int hashCode() {
            return 0;
        }
    }

    static interface FunctionPointerTarget {
    }
}

