/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.functionpointer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.functionpointer.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.functionpointer.FunctionPointerState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

@Options(prefix="cpa.functionpointer")
class FunctionPointerTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, description="whether function pointers with invalid targets (e.g., 0) should be tracked in order to find calls to such pointers")
    private boolean trackInvalidFunctionPointers = false;
    private final FunctionPointerState.FunctionPointerTarget invalidFunctionPointerTarget;
    @Option(secure=true, description="When an invalid function pointer is called, do not assume all functions as possible targets and instead call no function.")
    private boolean ignoreInvalidFunctionPointerCalls = false;
    @Option(secure=true, description="When an unknown function pointer is called, do not assume all functions as possible targets and instead call no function (this is unsound).")
    private boolean ignoreUnknownFunctionPointerCalls = false;
    private final LogManagerWithoutDuplicates logger;

    FunctionPointerTransferRelation(LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        FunctionPointerState.FunctionPointerTarget functionPointerTarget = this.invalidFunctionPointerTarget = this.trackInvalidFunctionPointers ? FunctionPointerState.InvalidTarget.getInstance() : FunctionPointerState.UnknownTarget.getInstance();
        if (this.ignoreInvalidFunctionPointerCalls && !this.trackInvalidFunctionPointers) {
            throw new InvalidConfigurationException("FunctionPointerCPA cannot ignore invalid function pointer calls when such pointers are not tracked, please set cpa.functionpointer.trackInvalidFunctionPointers=true");
        }
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        FunctionPointerState oldState = (FunctionPointerState)pElement;
        if (!this.shouldGoByEdge(oldState, pCfaEdge)) {
            return ImmutableSet.of();
        }
        String functionCallVariable = FunctionPointerTransferRelation.getFunctionPointerCall(pCfaEdge);
        if (functionCallVariable != null) {
            FunctionPointerState.FunctionPointerTarget target = oldState.getTarget(functionCallVariable);
            if (target instanceof FunctionPointerState.NamedFunctionTarget) {
                String functionName = ((FunctionPointerState.NamedFunctionTarget)target).getFunctionName();
                this.logger.logfOnce(Level.WARNING, "%s: Function pointer %s points to %s, but no corresponding call edge was created during preprocessing. Ignoring function pointer call: %s", new Object[]{pCfaEdge.getFileLocation(), functionCallVariable, functionName, pCfaEdge.getDescription()});
            } else {
                this.logger.logfOnce(Level.WARNING, "%s: Ignoring call via function pointer %s for which no suitable target was found in line: %s", new Object[]{pCfaEdge.getFileLocation(), functionCallVariable, pCfaEdge.getDescription()});
            }
        }
        FunctionPointerState.Builder newState = oldState.createBuilder();
        this.handleEdge(newState, pCfaEdge);
        return ImmutableSet.of((Object)newState.build());
    }

    private boolean shouldGoByEdge(FunctionPointerState oldState, CFAEdge cfaEdge) throws UnrecognizedCodeException {
        CBinaryExpression e;
        CBinaryExpression.BinaryOperator op;
        CAssumeEdge a;
        CExpression exp;
        if (cfaEdge.getEdgeType() == CFAEdgeType.AssumeEdge && (exp = (a = (CAssumeEdge)cfaEdge).getExpression()) instanceof CBinaryExpression && (op = (e = (CBinaryExpression)exp).getOperator()) == CBinaryExpression.BinaryOperator.EQUALS) {
            FunctionPointerState.Builder newState = oldState.createBuilder();
            FunctionPointerState.FunctionPointerTarget v1 = this.getValue(e.getOperand1(), newState);
            FunctionPointerState.FunctionPointerTarget v2 = this.getValue(e.getOperand2(), newState);
            this.logger.log(Level.ALL, new Object[]{"Operand1 value is", v1});
            this.logger.log(Level.ALL, new Object[]{"Operand2 value is", v2});
            if (v1 instanceof FunctionPointerState.NamedFunctionTarget && v2 instanceof FunctionPointerState.NamedFunctionTarget) {
                boolean eq = v1.equals(v2);
                if (eq != a.getTruthAssumption()) {
                    this.logger.log(Level.FINE, new Object[]{"Should not go by the edge", a});
                    return false;
                }
                this.logger.log(Level.FINE, new Object[]{"Should go by the edge", a});
                return true;
            }
            if (a.getTruthAssumption() && (cfaEdge.getSuccessor().getNumLeavingEdges() > 0 && cfaEdge.getSuccessor().getLeavingEdge(0).getEdgeType() == CFAEdgeType.FunctionCallEdge || cfaEdge.getSuccessor().getNumLeavingEdges() > 1 && cfaEdge.getSuccessor().getLeavingEdge(1).getEdgeType() == CFAEdgeType.FunctionCallEdge)) {
                if (this.ignoreInvalidFunctionPointerCalls) {
                    if (v1 instanceof FunctionPointerState.InvalidTarget && v2 instanceof FunctionPointerState.NamedFunctionTarget) {
                        this.logger.logfOnce(Level.WARNING, "%s: Assuming function pointer %s with invalid target does not point to %s.", new Object[]{cfaEdge.getFileLocation(), e.getOperand1(), v2});
                        return false;
                    }
                    if (v2 instanceof FunctionPointerState.InvalidTarget && v1 instanceof FunctionPointerState.NamedFunctionTarget) {
                        this.logger.logfOnce(Level.WARNING, "%s: Assuming function pointer %s with invalid target does not point to %s.", new Object[]{cfaEdge.getFileLocation(), e.getOperand2(), v1});
                        return false;
                    }
                }
                if (this.ignoreUnknownFunctionPointerCalls) {
                    if (v1 instanceof FunctionPointerState.UnknownTarget && v2 instanceof FunctionPointerState.NamedFunctionTarget) {
                        this.logger.logfOnce(Level.WARNING, "%s: Assuming function pointer %s with unknown target does not point to %s.", new Object[]{cfaEdge.getFileLocation(), e.getOperand1(), v2});
                        return false;
                    }
                    if (v2 instanceof FunctionPointerState.UnknownTarget && v1 instanceof FunctionPointerState.NamedFunctionTarget) {
                        this.logger.logfOnce(Level.WARNING, "%s: Assuming function pointer %s with unknown target does not point to %s.", new Object[]{cfaEdge.getFileLocation(), e.getOperand2(), v1});
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static String getFunctionPointerCall(CFAEdge pCfaEdge) throws UnrecognizedCodeException {
        CIdExpression idExp;
        if (pCfaEdge.getEdgeType() != CFAEdgeType.StatementEdge) {
            return null;
        }
        CStatement statement = ((CStatementEdge)pCfaEdge).getStatement();
        if (!(statement instanceof CFunctionCall)) {
            return null;
        }
        CFunctionCallExpression funcCall = ((CFunctionCall)statement).getFunctionCallExpression();
        CExpression nameExp = funcCall.getFunctionNameExpression();
        if (nameExp instanceof CIdExpression && (idExp = (CIdExpression)nameExp).getExpressionType() instanceof CFunctionType) {
            return null;
        }
        if (nameExp instanceof CPointerExpression) {
            nameExp = ((CPointerExpression)nameExp).getOperand();
        }
        if (nameExp instanceof CCastExpression) {
            nameExp = ((CCastExpression)nameExp).getOperand();
        }
        if (nameExp instanceof CIdExpression) {
            return ((CIdExpression)nameExp).getDeclaration().getQualifiedName();
        }
        if (nameExp instanceof CFieldReference) {
            return null;
        }
        if (nameExp instanceof CArraySubscriptExpression) {
            return null;
        }
        if (nameExp instanceof CPointerExpression) {
            return null;
        }
        throw new UnrecognizedCodeException("unknown function call expression of type " + nameExp.getClass().getSimpleName(), pCfaEdge, nameExp);
    }

    private void handleEdge(FunctionPointerState.Builder newState, CFAEdge pCfaEdge) throws CPATransferException {
        switch (pCfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                CDeclarationEdge declEdge = (CDeclarationEdge)pCfaEdge;
                this.handleDeclaration(newState, declEdge);
                break;
            }
            case StatementEdge: {
                CStatementEdge statementEdge = (CStatementEdge)pCfaEdge;
                this.handleStatement(newState, statementEdge.getStatement(), pCfaEdge);
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge functionCallEdge = (CFunctionCallEdge)pCfaEdge;
                this.handleFunctionCall(newState, functionCallEdge);
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnStatementEdge = (CReturnStatementEdge)pCfaEdge;
                this.handleReturnStatement(newState, returnStatementEdge.asAssignment(), pCfaEdge);
                break;
            }
            case FunctionReturnEdge: {
                CFunctionReturnEdge functionReturnEdge = (CFunctionReturnEdge)pCfaEdge;
                this.handleFunctionReturn(newState, functionReturnEdge);
                break;
            }
            case AssumeEdge: {
                break;
            }
            case BlankEdge: 
            case CallToReturnEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(pCfaEdge);
            }
        }
    }

    private void handleDeclaration(FunctionPointerState.Builder pNewState, CDeclarationEdge declEdge) throws UnrecognizedCodeException {
        CInitializer init;
        if (!(declEdge.getDeclaration() instanceof CVariableDeclaration)) {
            return;
        }
        CVariableDeclaration decl = (CVariableDeclaration)declEdge.getDeclaration();
        String name = decl.getQualifiedName();
        FunctionPointerState.FunctionPointerTarget initialValue = this.invalidFunctionPointerTarget;
        if (decl.getInitializer() != null && (init = decl.getInitializer()) instanceof CInitializerExpression) {
            initialValue = this.getValue(((CInitializerExpression)init).getExpression(), pNewState);
        }
        pNewState.setTarget(name, initialValue);
    }

    private void handleStatement(FunctionPointerState.Builder pNewState, CStatement pStatement, CFAEdge pCfaEdge) throws UnrecognizedCodeException {
        if (pStatement instanceof CAssignment) {
            this.handleAssignment(pNewState, (CAssignment)pStatement, pCfaEdge);
        } else if (!(pStatement instanceof CFunctionCallStatement) && !(pStatement instanceof CExpressionStatement)) {
            throw new UnrecognizedCodeException("unknown statement", pCfaEdge, pStatement);
        }
    }

    private void handleAssignment(FunctionPointerState.Builder pNewState, CAssignment assignment, CFAEdge pCfaEdge) throws UnrecognizedCodeException {
        String varName = this.getLeftHandSide(assignment.getLeftHandSide(), pCfaEdge);
        if (varName != null) {
            FunctionPointerState.FunctionPointerTarget target = this.getValue(assignment.getRightHandSide(), pNewState);
            pNewState.setTarget(varName, target);
        }
    }

    private void handleFunctionCall(FunctionPointerState.Builder pNewState, CFunctionCallEdge callEdge) throws UnrecognizedCodeException {
        CFunctionEntryNode functionEntryNode = callEdge.getSuccessor();
        List<CParameterDeclaration> formalParams = functionEntryNode.getFunctionParameters();
        List<CExpression> arguments = callEdge.getArguments();
        if (functionEntryNode.getFunctionDefinition().getType().takesVarArgs() ? formalParams.size() > arguments.size() : formalParams.size() != arguments.size()) {
            throw new UnrecognizedCodeException("Number of parameters on function call does not match function definition", callEdge);
        }
        ExpressionValueVisitor v = new ExpressionValueVisitor(pNewState, this.invalidFunctionPointerTarget);
        for (int i = 0; i < formalParams.size(); ++i) {
            String paramName = formalParams.get(i).getQualifiedName();
            CExpression actualArgument = arguments.get(i);
            FunctionPointerState.FunctionPointerTarget target = actualArgument.accept(v);
            pNewState.setTarget(paramName, target);
        }
    }

    private void handleReturnStatement(FunctionPointerState.Builder pNewState, Optional<CAssignment> returnStatement, CFAEdge pCfaEdge) throws UnrecognizedCodeException {
        if (returnStatement.isPresent()) {
            this.handleAssignment(pNewState, returnStatement.orElseThrow(), pCfaEdge);
        }
    }

    private void handleFunctionReturn(FunctionPointerState.Builder pNewState, CFunctionReturnEdge pFunctionReturnEdge) throws UnrecognizedCodeException {
        CLeftHandSide left;
        String varName;
        CFunctionSummaryEdge summaryEdge = pFunctionReturnEdge.getSummaryEdge();
        assert (summaryEdge != null);
        CFunctionCall funcCall = summaryEdge.getExpression();
        if (funcCall instanceof CFunctionCallAssignmentStatement && (varName = this.getLeftHandSide(left = ((CFunctionCallAssignmentStatement)funcCall).getLeftHandSide(), summaryEdge)) != null) {
            Optional<CVariableDeclaration> returnValue = pFunctionReturnEdge.getFunctionEntry().getReturnVariable();
            if (returnValue.isPresent()) {
                FunctionPointerState.FunctionPointerTarget target = pNewState.getTarget(returnValue.orElseThrow().getQualifiedName());
                pNewState.setTarget(varName, target);
            } else {
                pNewState.setTarget(varName, FunctionPointerState.UnknownTarget.getInstance());
            }
        }
        String calledFunction = pFunctionReturnEdge.getPredecessor().getFunctionName();
        pNewState.clearVariablesForFunction(calledFunction);
    }

    private String getLeftHandSide(CExpression lhsExpression, CFAEdge edge) throws UnrecognizedCodeException {
        if (lhsExpression instanceof CIdExpression) {
            return ((CIdExpression)lhsExpression).getDeclaration().getQualifiedName();
        }
        if (!(lhsExpression instanceof CPointerExpression) && !(lhsExpression instanceof CFieldReference)) {
            if (lhsExpression instanceof CArraySubscriptExpression) {
                CArraySubscriptExpression arrayExp = (CArraySubscriptExpression)lhsExpression;
                if (arrayExp.getArrayExpression() instanceof CIdExpression && arrayExp.getSubscriptExpression() instanceof CIntegerLiteralExpression) {
                    return FunctionPointerTransferRelation.arrayElementVariable(arrayExp);
                }
            } else {
                throw new UnrecognizedCodeException("left operand of assignment has to be a variable", edge, lhsExpression);
            }
        }
        return null;
    }

    private FunctionPointerState.FunctionPointerTarget getValue(CRightHandSide exp, FunctionPointerState.Builder element) throws UnrecognizedCodeException {
        return exp.accept(new ExpressionValueVisitor(element, this.invalidFunctionPointerTarget));
    }

    static String arrayElementVariable(CArraySubscriptExpression exp) {
        Preconditions.checkArgument((boolean)(exp.getSubscriptExpression() instanceof CIntegerLiteralExpression));
        return ((CIdExpression)exp.getArrayExpression()).getDeclaration().getQualifiedName() + "[" + exp.getSubscriptExpression().toASTString() + "]";
    }
}

