/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.input;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.input.InputState;

public class InputTransferRelation
extends SingleEdgeTransferRelation {
    private final CFA cfa;

    public InputTransferRelation(CFA pCFA) {
        this.cfa = Objects.requireNonNull(pCFA);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pEdge) {
        return Collections.singleton(this.getAbstractSuccessorForEdge(pEdge));
    }

    private InputState getAbstractSuccessorForEdge(CFAEdge pEdge) {
        switch (pEdge.getEdgeType()) {
            case DeclarationEdge: {
                return InputTransferRelation.handleDeclarationEdge((ADeclarationEdge)pEdge);
            }
            case StatementEdge: {
                return this.handleStatementEdge((AStatementEdge)pEdge);
            }
            case FunctionCallEdge: {
                return InputTransferRelation.handleFunctionCallEdge((FunctionCallEdge)pEdge);
            }
        }
        return InputState.empty();
    }

    private static InputState handleDeclarationEdge(ADeclarationEdge pEdge) {
        AVariableDeclaration variableDeclaration;
        ADeclaration declaration = pEdge.getDeclaration();
        if (declaration instanceof AVariableDeclaration && (variableDeclaration = (AVariableDeclaration)declaration).getInitializer() == null) {
            return InputState.forInputs(Collections.singleton(variableDeclaration.getQualifiedName()));
        }
        return InputState.empty();
    }

    private InputState handleStatementEdge(AStatementEdge pEdge) {
        AStatement statement = pEdge.getStatement();
        if (statement instanceof AAssignment) {
            AFunctionCallAssignmentStatement callAssignment;
            AFunctionCallExpression callExpression;
            AExpression functionNameExpression;
            AAssignment assignment = (AAssignment)((Object)statement);
            ALeftHandSide lhs = assignment.getLeftHandSide();
            if (!(lhs instanceof AIdExpression)) {
                return InputState.empty();
            }
            String lhsVariable = ((AIdExpression)lhs).getDeclaration().getQualifiedName();
            if (assignment instanceof AFunctionCallAssignmentStatement && (functionNameExpression = (callExpression = (callAssignment = (AFunctionCallAssignmentStatement)assignment).getRightHandSide()).getFunctionNameExpression()) instanceof AIdExpression) {
                AIdExpression functionIdExpression = (AIdExpression)functionNameExpression;
                String functionName = functionIdExpression.getName();
                FunctionEntryNode functionEntryNode = (FunctionEntryNode)this.cfa.getAllFunctions().get(functionName);
                if (functionEntryNode == null) {
                    return InputState.forInputs((Set<String>)ImmutableSet.of((Object)lhsVariable, (Object)functionName));
                }
                Optional<? extends AVariableDeclaration> retVar = functionEntryNode.getReturnVariable();
                if (!retVar.isPresent()) {
                    return InputState.forInputs(Collections.singleton(lhsVariable));
                }
            }
        }
        return InputState.empty();
    }

    private static InputState handleFunctionCallEdge(FunctionCallEdge pEdge) {
        FunctionSummaryEdge summaryEdge = pEdge.getSummaryEdge();
        if (summaryEdge == null) {
            return InputState.empty();
        }
        return InputTransferRelation.handleFunctionCall(summaryEdge.getFunctionEntry().getFunctionParameters(), pEdge.getArguments());
    }

    private static InputState handleFunctionCall(List<? extends AParameterDeclaration> pFunctionParameters, List<? extends AExpression> pCallArguments) {
        Iterator<? extends AParameterDeclaration> parameterIt = pFunctionParameters.iterator();
        Iterator<? extends AExpression> argumentIt = pCallArguments.iterator();
        ImmutableSet.Builder inputs = ImmutableSet.builder();
        while (parameterIt.hasNext()) {
            AParameterDeclaration paramDecl = parameterIt.next();
            if (argumentIt.hasNext()) continue;
            inputs.add((Object)paramDecl.getQualifiedName());
        }
        return InputState.forInputs((Set<String>)inputs.build());
    }
}

