/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

class ExpressionValueVisitor
extends DefaultCExpressionVisitor<Interval, UnrecognizedCodeException>
implements CRightHandSideVisitor<Interval, UnrecognizedCodeException> {
    private final IntervalAnalysisState readableState;
    private final CFAEdge cfaEdge;

    public ExpressionValueVisitor(IntervalAnalysisState pState, CFAEdge edge) {
        this.readableState = pState;
        this.cfaEdge = edge;
    }

    @Override
    protected Interval visitDefault(CExpression expression) {
        return Interval.UNBOUND;
    }

    @Override
    public Interval visit(CBinaryExpression binaryExpression) throws UnrecognizedCodeException {
        Interval interval1 = binaryExpression.getOperand1().accept(this);
        Interval interval2 = binaryExpression.getOperand2().accept(this);
        if (interval1 == null || interval2 == null) {
            return Interval.UNBOUND;
        }
        CBinaryExpression.BinaryOperator operator = binaryExpression.getOperator();
        if (operator.isLogicalOperator()) {
            return ExpressionValueVisitor.getLogicInterval(operator, interval1, interval2);
        }
        return ExpressionValueVisitor.getArithmeticInterval(operator, interval1, interval2);
    }

    private static Interval getLogicInterval(CBinaryExpression.BinaryOperator operator, Interval interval1, Interval interval2) {
        switch (operator) {
            case EQUALS: {
                if (!interval1.intersects(interval2)) {
                    return Interval.ZERO;
                }
                if (interval1.getLow().equals(interval1.getHigh()) && interval1.equals(interval2)) {
                    return Interval.ONE;
                }
                return Interval.BOOLEAN_INTERVAL;
            }
            case NOT_EQUALS: {
                if (!interval1.intersects(interval2)) {
                    return Interval.ONE;
                }
                if (interval1.getLow().equals(interval1.getHigh()) && interval1.equals(interval2)) {
                    return Interval.ZERO;
                }
                return Interval.BOOLEAN_INTERVAL;
            }
            case GREATER_THAN: {
                if (interval1.isGreaterThan(interval2)) {
                    return Interval.ONE;
                }
                if (interval2.isGreaterOrEqualThan(interval1)) {
                    return Interval.ZERO;
                }
                return Interval.BOOLEAN_INTERVAL;
            }
            case GREATER_EQUAL: {
                return ExpressionValueVisitor.getLogicInterval(CBinaryExpression.BinaryOperator.GREATER_THAN, interval1.plus(Interval.ONE), interval2);
            }
            case LESS_THAN: {
                return ExpressionValueVisitor.getLogicInterval(CBinaryExpression.BinaryOperator.GREATER_THAN, interval2, interval1);
            }
            case LESS_EQUAL: {
                return ExpressionValueVisitor.getLogicInterval(CBinaryExpression.BinaryOperator.GREATER_THAN, interval2.plus(Interval.ONE), interval1);
            }
        }
        throw new AssertionError((Object)("unknown binary operator: " + operator));
    }

    private static Interval getArithmeticInterval(CBinaryExpression.BinaryOperator operator, Interval interval1, Interval interval2) {
        switch (operator) {
            case PLUS: {
                return interval1.plus(interval2);
            }
            case MINUS: {
                return interval1.minus(interval2);
            }
            case MULTIPLY: {
                return interval1.times(interval2);
            }
            case DIVIDE: {
                return interval1.divide(interval2);
            }
            case SHIFT_LEFT: {
                return interval1.shiftLeft(interval2);
            }
            case SHIFT_RIGHT: {
                return interval1.shiftRight(interval2);
            }
            case MODULO: {
                return interval1.modulo(interval2);
            }
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                return Interval.UNBOUND;
            }
        }
        throw new AssertionError((Object)("unknown binary operator: " + operator));
    }

    @Override
    public Interval visit(CCastExpression cast) throws UnrecognizedCodeException {
        return cast.getOperand().accept(this);
    }

    @Override
    public Interval visit(CFunctionCallExpression functionCall) {
        return Interval.UNBOUND;
    }

    @Override
    public Interval visit(CCharLiteralExpression charLiteral) {
        return new Interval(Long.valueOf(charLiteral.getCharacter()));
    }

    @Override
    public Interval visit(CImaginaryLiteralExpression exp) throws UnrecognizedCodeException {
        return exp.getValue().accept(this);
    }

    @Override
    public Interval visit(CIntegerLiteralExpression integerLiteral) {
        return new Interval(integerLiteral.asLong());
    }

    @Override
    public Interval visit(CIdExpression identifier) {
        if (identifier.getDeclaration() instanceof CEnumType.CEnumerator) {
            return new Interval(((CEnumType.CEnumerator)identifier.getDeclaration()).getValue());
        }
        String variableName = identifier.getDeclaration().getQualifiedName();
        if (this.readableState.contains(variableName)) {
            return this.readableState.getInterval(variableName);
        }
        return Interval.UNBOUND;
    }

    @Override
    public Interval visit(CUnaryExpression unaryExpression) throws UnrecognizedCodeException {
        Interval interval = unaryExpression.getOperand().accept(this);
        switch (unaryExpression.getOperator()) {
            case MINUS: {
                return interval.negate();
            }
            case AMPER: 
            case TILDE: {
                return Interval.UNBOUND;
            }
        }
        throw new UnrecognizedCodeException("unknown unary operator", this.cfaEdge, unaryExpression);
    }
}

