/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.util.Objects;

public final class Interval
implements Serializable {
    private static final long serialVersionUID = 4223098080993616295L;
    private final Long low;
    private final Long high;
    private static final Interval EMPTY = new Interval(null, null);
    public static final Interval UNBOUND = new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
    public static final Interval BOOLEAN_INTERVAL = new Interval(0L, 1L);
    public static final Interval ZERO = new Interval(0L, 0L);
    public static final Interval ONE = new Interval(1L, 1L);

    public Interval(Long value) {
        this.low = value;
        this.high = value;
        this.isSane();
    }

    public Interval(Long low, Long high) {
        this.low = low;
        this.high = high;
        this.isSane();
    }

    private boolean isSane() {
        Preconditions.checkState((this.low == null == (this.high == null) ? 1 : 0) != 0, (Object)"invalid empty interval");
        Preconditions.checkState((this.low == null || this.low <= this.high ? 1 : 0) != 0, (Object)"low cannot be larger than high");
        return true;
    }

    public Long getLow() {
        return this.low;
    }

    public Long getHigh() {
        return this.high;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass().equals(other.getClass())) {
            Interval another = (Interval)other;
            return Objects.equals(this.low, another.low) && Objects.equals(this.high, another.high);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.low, this.high);
    }

    public Interval union(Interval other) {
        if (this.isEmpty() || other.isEmpty()) {
            return EMPTY;
        }
        if (this.low <= other.low && this.high >= other.high) {
            return this;
        }
        if (this.low >= other.low && this.high <= other.high) {
            return other;
        }
        return new Interval(Math.min(this.low, other.low), Math.max(this.high, other.high));
    }

    public Interval intersect(Interval other) {
        if (this.intersects(other)) {
            return new Interval(Math.max(this.low, other.low), Math.min(this.high, other.high));
        }
        return EMPTY;
    }

    public boolean isGreaterThan(Interval other) {
        return !this.isEmpty() && !other.isEmpty() && this.low > other.high;
    }

    public boolean isGreaterOrEqualThan(Interval other) {
        return !this.isEmpty() && !other.isEmpty() && this.low >= other.high;
    }

    public boolean mayBeGreaterThan(Interval other) {
        return other.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.high > other.low;
    }

    public boolean mayBeGreaterOrEqualThan(Interval other) {
        return other.isEmpty() || !this.isEmpty() && !other.isEmpty() && this.high >= other.low;
    }

    public Interval modulo(Interval other) {
        if (other.contains(ZERO)) {
            return UNBOUND;
        }
        other = new Interval(Math.abs(other.low), Math.abs(other.high));
        long top = this.low >= 0L ? this.high : (this.low == Long.MIN_VALUE ? Long.MAX_VALUE : Math.max(Math.abs(this.low), this.high));
        long newHigh = Math.min(top, other.high - 1L);
        long newLow = this.low >= 0L ? (this.low == 0L || this.high >= other.low ? 0L : this.low) : Math.max(this.low, 1L - other.high);
        Interval out = new Interval(newLow, newHigh);
        return out;
    }

    public Interval limitLowerBoundBy(Interval other) {
        Interval interval = null;
        interval = this.isEmpty() || other.isEmpty() || this.high < other.low ? EMPTY : new Interval(Math.max(this.low, other.low), this.high);
        return interval;
    }

    public Interval limitUpperBoundBy(Interval other) {
        Interval interval = null;
        interval = this.isEmpty() || other.isEmpty() || this.low > other.high ? EMPTY : new Interval(this.low, Math.min(this.high, other.high));
        return interval;
    }

    public boolean intersects(Interval other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.low >= other.low && this.low <= other.high || this.high >= other.low && this.high <= other.high || this.low <= other.low && this.high >= other.high;
    }

    public boolean contains(Interval other) {
        return !this.isEmpty() && !other.isEmpty() && this.low <= other.low && other.high <= this.high;
    }

    public Interval plus(Interval interval) {
        if (this.isEmpty() || interval.isEmpty()) {
            return EMPTY;
        }
        return new Interval(LongMath.saturatedAdd((long)this.low, (long)interval.low), LongMath.saturatedAdd((long)this.high, (long)interval.high));
    }

    public Interval plus(Long offset) {
        return this.plus(new Interval(offset, offset));
    }

    public Interval minus(Interval other) {
        return this.plus(other.negate());
    }

    public Interval minus(Long offset) {
        return this.plus(-offset.longValue());
    }

    public Interval times(Interval other) {
        long[] values = new long[]{LongMath.saturatedMultiply((long)this.low, (long)other.low), LongMath.saturatedMultiply((long)this.low, (long)other.high), LongMath.saturatedMultiply((long)this.high, (long)other.low), LongMath.saturatedMultiply((long)this.high, (long)other.high)};
        return new Interval(Longs.min((long[])values), Longs.max((long[])values));
    }

    public Interval divide(Interval other) {
        if (other.contains(ZERO)) {
            return UNBOUND;
        }
        long[] values = new long[]{this.low / other.low, this.low / other.high, this.high / other.low, this.high / other.high};
        return new Interval(Longs.min((long[])values), Longs.max((long[])values));
    }

    public Interval shiftLeft(Interval offset) {
        if (ZERO.mayBeGreaterThan(offset)) {
            return UNBOUND;
        }
        Long newLow = this.low << (int)(this.low < 0L ? offset.high : offset.low).longValue();
        Long newHigh = this.high << (int)(this.high < 0L ? offset.low : offset.high).longValue();
        if (this.low < 0L && newLow > this.low || this.high > 0L && newHigh < this.high) {
            return UNBOUND;
        }
        return new Interval(newLow, newHigh);
    }

    public Interval shiftRight(Interval offset) {
        if (ZERO.mayBeGreaterThan(offset)) {
            return UNBOUND;
        }
        Long newLow = this.low >> (int)(this.low < 0L ? offset.low : offset.high).longValue();
        Long newHigh = this.high >> (int)(this.high < 0L ? offset.high : offset.low).longValue();
        return new Interval(newLow, newHigh);
    }

    public Interval negate() {
        return new Interval(LongMath.saturatedMultiply((long)this.high, (long)-1L), LongMath.saturatedMultiply((long)this.low, (long)-1L));
    }

    public boolean isEmpty() {
        return this.low == null && this.high == null;
    }

    public boolean isUnbound() {
        return !this.isEmpty() && this.low == Long.MIN_VALUE && this.high == Long.MAX_VALUE;
    }

    public String toString() {
        return "[" + (Serializable)(this.low == null ? "" : this.low) + "; " + (Serializable)(this.high == null ? "" : this.high) + "]";
    }

    public static Interval createLowerBoundedInterval(Long lowerBound) {
        return new Interval(lowerBound, Long.MAX_VALUE);
    }

    public static Interval createUpperBoundedInterval(Long upperBound) {
        return new Interval(Long.MIN_VALUE, upperBound);
    }
}

