/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AbstractCPA;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisReducer;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisTransferRelation;
import org.sosy_lab.cpachecker.util.StateToFormulaWriter;

@Options(prefix="cpa.interval")
public class IntervalAnalysisCPA
extends AbstractCPA
implements ConfigurableProgramAnalysisWithBAM,
StatisticsProvider,
ProofChecker.ProofCheckerCPA {
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which type of merge operator to use for IntervalAnalysisCPA")
    private String mergeType = "SEP";
    @Option(secure=true, description="decides whether one (false) or two (true) successors should be created when an inequality-check is encountered")
    private boolean splitIntervals = false;
    @Option(secure=true, description="at most that many intervals will be tracked per variable, -1 if number not restricted")
    private int threshold = -1;
    private final StateToFormulaWriter writer;
    private final LogManager logger;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(IntervalAnalysisCPA.class);
    }

    private IntervalAnalysisCPA(Configuration config, LogManager pLogger, ShutdownNotifier shutdownNotifier, CFA cfa) throws InvalidConfigurationException {
        super("irrelevant", "sep", DelegateAbstractDomain.getInstance(), null);
        config.inject((Object)this);
        this.writer = new StateToFormulaWriter(config, pLogger, shutdownNotifier, cfa);
        this.logger = pLogger;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.buildMergeOperator(this.mergeType);
    }

    @Override
    public Reducer getReducer() {
        return new IntervalAnalysisReducer();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new IntervalAnalysisState();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new IntervalAnalysisTransferRelation(this.splitIntervals, this.threshold, this.logger);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.writer.collectStatistics(pStatsCollection);
    }
}

