/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.defaults.GenericReducer;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.util.Pair;

class IntervalAnalysisReducer
extends GenericReducer<IntervalAnalysisState, Precision> {
    IntervalAnalysisReducer() {
    }

    @Override
    protected IntervalAnalysisState getVariableReducedState0(IntervalAnalysisState pExpandedState, Block pContext, CFANode pCallNode) {
        IntervalAnalysisState clonedElement = pExpandedState;
        for (String trackedVar : pExpandedState.getIntervalMap().keySet()) {
            if (pContext.getVariables().contains(trackedVar)) continue;
            clonedElement = clonedElement.removeInterval(trackedVar);
        }
        return clonedElement;
    }

    @Override
    protected IntervalAnalysisState getVariableExpandedState0(IntervalAnalysisState pRootState, Block pReducedContext, IntervalAnalysisState pReducedState) {
        IntervalAnalysisState diffElement = pReducedState;
        for (String trackedVar : pRootState.getIntervalMap().keySet()) {
            if (pReducedContext.getVariables().contains(trackedVar)) continue;
            diffElement = diffElement.addInterval(trackedVar, pRootState.getInterval(trackedVar), -1);
        }
        return diffElement;
    }

    @Override
    protected Precision getVariableReducedPrecision0(Precision pPrecision, Block pContext) {
        return pPrecision;
    }

    @Override
    protected Precision getVariableExpandedPrecision0(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        return pReducedPrecision;
    }

    @Override
    protected Object getHashCodeForState0(IntervalAnalysisState pElementKey, Precision pPrecisionKey) {
        return Pair.of(pElementKey.getIntervalMap(), pPrecisionKey);
    }

    @Override
    protected IntervalAnalysisState rebuildStateAfterFunctionCall0(IntervalAnalysisState pRootState, IntervalAnalysisState entryState, IntervalAnalysisState pExpandedState, FunctionExitNode exitLocation) {
        IntervalAnalysisState rootState = pRootState;
        IntervalAnalysisState expandedState = pExpandedState;
        return expandedState.rebuildStateAfterFunctionCall(rootState, exitLocation);
    }
}

