/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.PseudoPartitionable;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.CheckTypesOfStringsUtil;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.IntegerFormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;

public class IntervalAnalysisState
implements Serializable,
LatticeAbstractState<IntervalAnalysisState>,
AbstractQueryableState,
Graphable,
FormulaReportingState,
PseudoPartitionable {
    private static final long serialVersionUID = -2030700797958100666L;
    private static final Splitter propertySplitter = Splitter.on((String)"<=").trimResults();
    private final PersistentMap<String, Interval> intervals;
    private final PersistentMap<String, Integer> referenceCounts;

    public IntervalAnalysisState() {
        this.intervals = PathCopyingPersistentTreeMap.of();
        this.referenceCounts = PathCopyingPersistentTreeMap.of();
    }

    public IntervalAnalysisState(PersistentMap<String, Interval> intervals, PersistentMap<String, Integer> referencesMap) {
        this.intervals = intervals;
        this.referenceCounts = referencesMap;
    }

    public Interval getInterval(String variableName) {
        return (Interval)this.intervals.getOrDefault((Object)variableName, (Object)Interval.UNBOUND);
    }

    private Integer getReferenceCount(String variableName) {
        return (Integer)this.referenceCounts.getOrDefault((Object)variableName, (Object)0);
    }

    public boolean contains(String variableName) {
        return this.intervals.containsKey((Object)variableName);
    }

    public IntervalAnalysisState addInterval(String variableName, Interval interval, int pThreshold) {
        if (interval.isUnbound()) {
            return this.removeInterval(variableName);
        }
        if (!this.intervals.containsKey((Object)variableName) || !((Interval)this.intervals.get((Object)variableName)).equals(interval)) {
            int referenceCount = this.getReferenceCount(variableName);
            if (pThreshold == -1 || referenceCount < pThreshold) {
                return new IntervalAnalysisState((PersistentMap<String, Interval>)this.intervals.putAndCopy((Object)variableName, (Object)interval), (PersistentMap<String, Integer>)this.referenceCounts.putAndCopy((Object)variableName, (Object)(referenceCount + 1)));
            }
            return this.removeInterval(variableName);
        }
        return this;
    }

    public IntervalAnalysisState removeInterval(String variableName) {
        if (this.intervals.containsKey((Object)variableName)) {
            return new IntervalAnalysisState((PersistentMap<String, Interval>)this.intervals.removeAndCopy((Object)variableName), this.referenceCounts);
        }
        return this;
    }

    public IntervalAnalysisState dropFrame(String pCalledFunctionName) {
        IntervalAnalysisState tmp = this;
        for (String variableName : this.intervals.keySet()) {
            if (!variableName.startsWith(pCalledFunctionName + "::")) continue;
            tmp = tmp.removeInterval(variableName);
        }
        return tmp;
    }

    @Override
    public IntervalAnalysisState join(IntervalAnalysisState reachedState) {
        boolean changed = false;
        PersistentSortedMap newIntervals = PathCopyingPersistentTreeMap.of();
        PersistentMap newReferences = this.referenceCounts;
        for (String variableName : reachedState.intervals.keySet()) {
            Integer otherRefCount = reachedState.getReferenceCount(variableName);
            Interval otherInterval = reachedState.getInterval(variableName);
            if (this.intervals.containsKey((Object)variableName)) {
                Interval mergedInterval = this.getInterval(variableName).union(otherInterval);
                if (mergedInterval != otherInterval) {
                    changed = true;
                }
                if (!mergedInterval.isUnbound()) {
                    newIntervals = newIntervals.putAndCopy((Object)variableName, (Object)mergedInterval);
                }
                Integer thisRefCount = this.getReferenceCount(variableName);
                if (mergedInterval != otherInterval && thisRefCount > otherRefCount) {
                    changed = true;
                    newReferences = newReferences.putAndCopy((Object)variableName, (Object)thisRefCount);
                    continue;
                }
                newReferences = newReferences.putAndCopy((Object)variableName, (Object)otherRefCount);
                continue;
            }
            newReferences = newReferences.putAndCopy((Object)variableName, (Object)otherRefCount);
            changed = true;
        }
        if (changed) {
            return new IntervalAnalysisState((PersistentMap<String, Interval>)newIntervals, newReferences);
        }
        return reachedState;
    }

    @Override
    public boolean isLessOrEqual(IntervalAnalysisState reachedState) {
        if (this.intervals.equals(reachedState.intervals)) {
            return true;
        }
        if (this.intervals.size() < reachedState.intervals.size()) {
            return false;
        }
        for (String variableName : reachedState.intervals.keySet()) {
            if (this.intervals.containsKey((Object)variableName) && reachedState.getInterval(variableName).contains(this.getInterval(variableName))) continue;
            return false;
        }
        return true;
    }

    public Map<String, Interval> getIntervalMap() {
        return this.intervals;
    }

    public IntervalAnalysisState rebuildStateAfterFunctionCall(IntervalAnalysisState callState, FunctionExitNode functionExit) {
        IntervalAnalysisState rebuildState = callState;
        for (String trackedVar : callState.intervals.keySet()) {
            if (trackedVar.contains("::")) continue;
            rebuildState = rebuildState.removeInterval(trackedVar);
        }
        for (String trackedVar : this.intervals.keySet()) {
            if (!trackedVar.contains("::")) {
                rebuildState = rebuildState.addInterval(trackedVar, this.getInterval(trackedVar), -1);
                continue;
            }
            if (!functionExit.getEntryNode().getReturnVariable().isPresent() || !functionExit.getEntryNode().getReturnVariable().get().getQualifiedName().equals(trackedVar)) continue;
            assert (!rebuildState.contains(trackedVar)) : "calling function should not contain return-variable of called function: " + trackedVar;
            if (!this.contains(trackedVar)) continue;
            rebuildState = rebuildState.addInterval(trackedVar, this.getInterval(trackedVar), -1);
        }
        return rebuildState;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof IntervalAnalysisState) {
            IntervalAnalysisState otherElement = (IntervalAnalysisState)other;
            return this.intervals.equals(otherElement.intervals);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intervals.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (Map.Entry entry : this.intervals.entrySet()) {
            sb.append(String.format("  < %s = %s :: %s >%n", entry.getKey(), entry.getValue(), this.getReferenceCount((String)entry.getKey())));
        }
        return sb.append("] size -> ").append(this.intervals.size()).toString();
    }

    @Override
    public String getCPAName() {
        return "IntervalAnalysis";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        List parts = propertySplitter.splitToList((CharSequence)pProperty);
        if (parts.size() == 2) {
            if (CheckTypesOfStringsUtil.isLong((String)parts.get(0))) {
                Interval iv;
                long value = Long.parseLong((String)parts.get(0));
                return value <= (iv = this.getInterval((String)parts.get(1))).getLow();
            }
            if (CheckTypesOfStringsUtil.isLong((String)parts.get(1))) {
                long value = Long.parseLong((String)parts.get(1));
                Interval iv = this.getInterval((String)parts.get(0));
                return iv.getHigh() <= value;
            }
            Interval iv1 = this.getInterval((String)parts.get(0));
            Interval iv2 = this.getInterval((String)parts.get(1));
            return iv1.contains(iv2);
        }
        if (parts.size() == 3 && CheckTypesOfStringsUtil.isLong((String)parts.get(0)) && CheckTypesOfStringsUtil.isLong((String)parts.get(2))) {
            long value1 = Long.parseLong((String)parts.get(0));
            long value2 = Long.parseLong((String)parts.get(2));
            Interval iv = this.getInterval((String)parts.get(1));
            return value1 <= iv.getLow() && iv.getHigh() <= value2;
        }
        return false;
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry entry : this.intervals.entrySet()) {
            sb.append(String.format("%s = %s (%s), ", entry.getKey(), entry.getValue(), this.getReferenceCount((String)entry.getKey())));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView pMgr) {
        IntegerFormulaManagerView nfmgr = pMgr.getIntegerFormulaManager();
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Map.Entry entry : this.intervals.entrySet()) {
            Interval interval = (Interval)entry.getValue();
            if (interval.isEmpty()) {
                return pMgr.getBooleanFormulaManager().makeFalse();
            }
            NumeralFormula var = nfmgr.makeVariable((String)entry.getKey());
            Long low = interval.getLow();
            Long high = interval.getHigh();
            if (low != null && low != Long.MIN_VALUE) {
                result.add(pMgr.makeLessOrEqual(nfmgr.makeNumber(low), var, true));
            }
            if (high == null || high == Long.MIN_VALUE) continue;
            result.add(pMgr.makeGreaterOrEqual(nfmgr.makeNumber(high), var, true));
        }
        return pMgr.getBooleanFormulaManager().and(result);
    }

    @Override
    public Comparable<?> getPseudoPartitionKey() {
        BigInteger absDistance = BigInteger.ZERO;
        for (Interval i : this.intervals.values()) {
            long high = i.getHigh() == null ? 0L : i.getHigh();
            long low = i.getLow() == null ? 0L : i.getLow();
            Preconditions.checkArgument((low <= high ? 1 : 0) != 0, (String)"LOW greater than HIGH: %s", (Object)i);
            absDistance = absDistance.add(BigInteger.valueOf(high).subtract(BigInteger.valueOf(low)));
        }
        return new IntervalPseudoPartitionKey(this.intervals.size(), absDistance.negate());
    }

    @Override
    public Object getPseudoHashCode() {
        return this;
    }

    private static final class IntervalPseudoPartitionKey
    implements Comparable<IntervalPseudoPartitionKey> {
        private final int size;
        private final BigInteger absoluteDistance;

        public IntervalPseudoPartitionKey(int pSize, BigInteger pAbsoluteDistance) {
            this.size = pSize;
            this.absoluteDistance = pAbsoluteDistance;
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof IntervalPseudoPartitionKey)) {
                return false;
            }
            IntervalPseudoPartitionKey other = (IntervalPseudoPartitionKey)pObj;
            return this.size == other.size && this.absoluteDistance.equals(other.absoluteDistance);
        }

        public int hashCode() {
            return 137 * this.size + this.absoluteDistance.hashCode();
        }

        public String toString() {
            return "[" + this.size + ", " + this.absoluteDistance + "]";
        }

        @Override
        public int compareTo(IntervalPseudoPartitionKey other) {
            return ComparisonChain.start().compare(this.size, other.size).compare((Comparable)this.absoluteDistance, (Comparable)other.absoluteDistance).result();
        }
    }
}

