/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;

public class IntervalAnalysisStateTest {
    @Test
    public void pseudoPartiotionKey() {
        IntervalAnalysisState s = new IntervalAnalysisState();
        IntervalAnalysisState sa1 = s.addInterval("a", new Interval(1L, 1L), 10);
        IntervalAnalysisState sb2 = s.addInterval("b", new Interval(2L, 2L), 10);
        IntervalAnalysisState sa1b2 = sa1.addInterval("b", new Interval(2L, 2L), 10);
        IntervalAnalysisState sa1b3 = sa1.addInterval("b", new Interval(3L, 3L), 10);
        IntervalAnalysisState sa1b23 = sa1.addInterval("b", new Interval(2L, 3L), 10);
        Comparable<?> cs = s.getPseudoPartitionKey();
        Comparable<?> csa1 = sa1.getPseudoPartitionKey();
        Comparable<?> csb2 = sb2.getPseudoPartitionKey();
        Comparable<?> csa1b2 = sa1b2.getPseudoPartitionKey();
        Comparable<?> csa1b3 = sa1b3.getPseudoPartitionKey();
        Comparable<?> csa1b23 = sa1b23.getPseudoPartitionKey();
        this.checkEquals(cs, cs);
        this.checkEquals(csa1, csa1);
        this.checkEquals(csb2, csb2);
        this.checkEquals(csa1b2, csa1b2);
        this.checkEquals(csa1b3, csa1b3);
        this.checkEquals(csa1b23, csa1b23);
        this.checkEquals(csa1, csb2);
        this.checkEquals(csa1b2, csa1b3);
        this.checkLess(cs, csa1);
        this.checkLess(cs, csb2);
        this.checkLess(cs, csa1b2);
        this.checkLess(cs, csa1b3);
        this.checkLess(csa1, csa1b2);
        this.checkLess(csa1, csa1b3);
        this.checkLess(csb2, csa1b2);
        this.checkLess(csa1, csa1b23);
        this.checkLess(csb2, csa1b23);
        this.checkLess(csa1b23, csa1b2);
        this.checkLess(csa1b23, csa1b3);
    }

    private void checkLess(Comparable c1, Comparable c2) {
        Truth.assertThat((Boolean)(c1.compareTo(c2) < 0 ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)(c2.compareTo(c1) > 0 ? 1 : 0)).isTrue();
    }

    private void checkEquals(Comparable c1, Comparable c2) {
        Truth.assertThat((Integer)c1.compareTo(c2)).isEqualTo((Object)0);
        Truth.assertThat((Integer)c2.compareTo(c1)).isEqualTo((Object)0);
    }
}

