/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.interval;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.interval.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class IntervalAnalysisTransferRelation
extends ForwardingTransferRelation<Collection<IntervalAnalysisState>, IntervalAnalysisState, Precision> {
    private final boolean splitIntervals;
    private final int threshold;
    private final LogManager logger;

    public IntervalAnalysisTransferRelation(boolean pSplitIntervals, int pThreshold, LogManager pLogger) {
        this.splitIntervals = pSplitIntervals;
        this.threshold = pThreshold;
        this.logger = pLogger;
    }

    @Override
    protected Collection<IntervalAnalysisState> postProcessing(Collection<IntervalAnalysisState> successors, CFAEdge edge) {
        return new HashSet<IntervalAnalysisState>(successors);
    }

    @Override
    protected Collection<IntervalAnalysisState> handleBlankEdge(BlankEdge cfaEdge) {
        IntervalAnalysisState newState = (IntervalAnalysisState)this.state;
        if (cfaEdge.getSuccessor() instanceof FunctionExitNode) {
            assert ("default return".equals(cfaEdge.getDescription()) || "skipped unnecessary edges".equals(cfaEdge.getDescription()));
            newState = newState.dropFrame(this.functionName);
        }
        return this.soleSuccessor(newState);
    }

    @Override
    protected Collection<IntervalAnalysisState> handleFunctionReturnEdge(CFunctionReturnEdge cfaEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String callerFunctionName) throws UnrecognizedCodeException {
        IntervalAnalysisState newState = (IntervalAnalysisState)this.state;
        Optional<CVariableDeclaration> retVar = fnkCall.getFunctionEntry().getReturnVariable();
        if (retVar.isPresent()) {
            newState = newState.removeInterval(retVar.orElseThrow().getQualifiedName());
        }
        if (summaryExpr instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement funcExp = (CFunctionCallAssignmentStatement)summaryExpr;
            if (((IntervalAnalysisState)this.state).contains(retVar.orElseThrow().getQualifiedName())) {
                newState = this.addInterval(newState, funcExp.getLeftHandSide(), ((IntervalAnalysisState)this.state).getInterval(retVar.orElseThrow().getQualifiedName()));
            }
        } else if (!(summaryExpr instanceof CFunctionCallStatement)) {
            throw new UnrecognizedCodeException("on function return", cfaEdge, summaryExpr);
        }
        return this.soleSuccessor(newState);
    }

    @Override
    protected Collection<IntervalAnalysisState> handleFunctionCallEdge(CFunctionCallEdge callEdge, List<CExpression> arguments, List<CParameterDeclaration> parameters, String calledFunctionName) throws UnrecognizedCodeException {
        if (callEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs()) {
            assert (parameters.size() <= arguments.size());
            this.logger.log(Level.WARNING, new Object[]{"Ignoring parameters passed as varargs to function", callEdge.getSuccessor().getFunctionDefinition().toASTString()});
        } else assert (parameters.size() == arguments.size());
        IntervalAnalysisState newState = (IntervalAnalysisState)this.state;
        for (int i = 0; i < parameters.size(); ++i) {
            Interval interval = this.evaluateInterval((IntervalAnalysisState)this.state, arguments.get(i), callEdge);
            String formalParameterName = parameters.get(i).getQualifiedName();
            newState = newState.addInterval(formalParameterName, interval, this.threshold);
        }
        return this.soleSuccessor(newState);
    }

    @Override
    protected Collection<IntervalAnalysisState> handleReturnStatementEdge(CReturnStatementEdge returnEdge) throws UnrecognizedCodeException {
        IntervalAnalysisState newState = ((IntervalAnalysisState)this.state).dropFrame(this.functionName);
        if (returnEdge.asAssignment().isPresent()) {
            CAssignment ass = returnEdge.asAssignment().orElseThrow();
            newState = newState.addInterval(((CIdExpression)ass.getLeftHandSide()).getDeclaration().getQualifiedName(), this.evaluateInterval((IntervalAnalysisState)this.state, ass.getRightHandSide(), returnEdge), this.threshold);
        }
        return this.soleSuccessor(newState);
    }

    @Override
    protected Collection<IntervalAnalysisState> handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthValue) throws UnrecognizedCodeException {
        if ((truthValue ? Interval.ZERO : Interval.ONE).equals(this.evaluateInterval((IntervalAnalysisState)this.state, expression, cfaEdge))) {
            return this.noSuccessors();
        }
        CBinaryExpression.BinaryOperator operator = ((CBinaryExpression)expression).getOperator();
        CExpression operand1 = ((CBinaryExpression)expression).getOperand1();
        CExpression operand2 = ((CBinaryExpression)expression).getOperand2();
        if (!truthValue) {
            operator = operator.getOppositLogicalOperator();
        }
        IntervalAnalysisState newState = (IntervalAnalysisState)this.state;
        ExpressionValueVisitor visitor = new ExpressionValueVisitor((IntervalAnalysisState)this.state, cfaEdge);
        Interval interval1 = operand1.accept(visitor);
        Interval interval2 = operand2.accept(visitor);
        assert (!interval1.isEmpty()) : operand1;
        assert (!interval2.isEmpty()) : operand2;
        switch (operator) {
            case LESS_THAN: {
                newState = this.addInterval(newState, operand1, interval1.limitUpperBoundBy(interval2.minus(1L)));
                newState = this.addInterval(newState, operand2, interval2.limitLowerBoundBy(interval1.plus(1L)));
                return this.soleSuccessor(newState);
            }
            case LESS_EQUAL: {
                newState = this.addInterval(newState, operand1, interval1.limitUpperBoundBy(interval2));
                newState = this.addInterval(newState, operand2, interval2.limitLowerBoundBy(interval1));
                return this.soleSuccessor(newState);
            }
            case GREATER_THAN: {
                newState = this.addInterval(newState, operand1, interval1.limitLowerBoundBy(interval2.plus(1L)));
                newState = this.addInterval(newState, operand2, interval2.limitUpperBoundBy(interval1.minus(1L)));
                return this.soleSuccessor(newState);
            }
            case GREATER_EQUAL: {
                newState = this.addInterval(newState, operand1, interval1.limitLowerBoundBy(interval2));
                newState = this.addInterval(newState, operand2, interval2.limitUpperBoundBy(interval1));
                return this.soleSuccessor(newState);
            }
            case EQUALS: {
                newState = this.addInterval(newState, operand1, interval1.intersect(interval2));
                newState = this.addInterval(newState, operand2, interval2.intersect(interval1));
                return this.soleSuccessor(newState);
            }
            case NOT_EQUALS: {
                if (interval2.getLow().equals(interval2.getHigh())) {
                    return this.splitInterval(newState, operand1, interval1, interval2);
                }
                if (interval1.getLow().equals(interval1.getHigh())) {
                    return this.splitInterval(newState, operand2, interval2, interval1);
                }
                return this.soleSuccessor(newState);
            }
        }
        throw new UnrecognizedCodeException("unexpected operator in assumption", cfaEdge, expression);
    }

    private Collection<IntervalAnalysisState> splitInterval(IntervalAnalysisState newState, CExpression lhs, Interval interval, Interval splitPoint) {
        assert (splitPoint.getLow().equals(splitPoint.getHigh())) : "invalid splitpoint for interval";
        if (this.splitIntervals || interval.getLow().equals(splitPoint.getHigh()) || interval.getHigh().equals(splitPoint.getHigh())) {
            ArrayList<IntervalAnalysisState> successors = new ArrayList<IntervalAnalysisState>();
            Interval part1 = interval.intersect(Interval.createUpperBoundedInterval(splitPoint.getLow() - 1L));
            Interval part2 = interval.intersect(Interval.createLowerBoundedInterval(splitPoint.getLow() + 1L));
            if (!part1.isEmpty()) {
                successors.add(this.addInterval(newState, lhs, part1));
            }
            if (!part2.isEmpty()) {
                successors.add(this.addInterval(newState, lhs, part2));
            }
            return successors;
        }
        return this.soleSuccessor(newState);
    }

    private IntervalAnalysisState addInterval(IntervalAnalysisState newState, CExpression lhs, Interval interval) {
        if (lhs instanceof CIdExpression) {
            newState = newState.addInterval(((CIdExpression)lhs).getDeclaration().getQualifiedName(), interval, this.threshold);
        }
        return newState;
    }

    @Override
    protected Collection<IntervalAnalysisState> handleDeclarationEdge(CDeclarationEdge declarationEdge, CDeclaration declaration) throws UnrecognizedCodeException {
        IntervalAnalysisState newState = (IntervalAnalysisState)this.state;
        if (declarationEdge.getDeclaration() instanceof CVariableDeclaration) {
            Interval interval;
            CVariableDeclaration decl = (CVariableDeclaration)declarationEdge.getDeclaration();
            if (decl.getType() instanceof CPointerType) {
                return this.soleSuccessor(newState);
            }
            CInitializer init = decl.getInitializer();
            if (init instanceof CInitializerExpression) {
                CExpression exp = ((CInitializerExpression)init).getExpression();
                interval = this.evaluateInterval((IntervalAnalysisState)this.state, exp, declarationEdge);
            } else {
                interval = Interval.UNBOUND;
            }
            newState = newState.addInterval(decl.getQualifiedName(), interval, this.threshold);
        }
        return this.soleSuccessor(newState);
    }

    @Override
    protected Collection<IntervalAnalysisState> handleStatementEdge(CStatementEdge cfaEdge, CStatement expression) throws UnrecognizedCodeException {
        IntervalAnalysisState successor = (IntervalAnalysisState)this.state;
        if (expression instanceof CAssignment) {
            CAssignment assignExpression = (CAssignment)expression;
            CLeftHandSide op1 = assignExpression.getLeftHandSide();
            CRightHandSide op2 = assignExpression.getRightHandSide();
            successor = this.addInterval(successor, op1, this.evaluateInterval((IntervalAnalysisState)this.state, op2, cfaEdge));
        }
        return this.soleSuccessor(successor);
    }

    private Interval evaluateInterval(IntervalAnalysisState readableState, CRightHandSide expression, CFAEdge cfaEdge) throws UnrecognizedCodeException {
        return expression.accept(new ExpressionValueVisitor(readableState, cfaEdge));
    }

    private Collection<IntervalAnalysisState> soleSuccessor(IntervalAnalysisState successor) {
        return Collections.singleton(successor);
    }

    private Collection<IntervalAnalysisState> noSuccessors() {
        return ImmutableSet.of();
    }
}

