/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.ALiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionState;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStrategy;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStrategyFactory;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.EdgeAnalyzer;
import org.sosy_lab.cpachecker.cpa.invariants.MemoryLocationExtractor;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

enum AbstractionStrategyFactories implements AbstractionStrategyFactory
{
    ALWAYS{

        @Override
        public AbstractionStrategy createStrategy(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel) {
            return new AbstractionStrategy(){

                @Override
                public AbstractionState getSuccessorState(AbstractionState pPrevious) {
                    return BasicAbstractionStates.ALWAYS_STATE;
                }

                @Override
                public AbstractionState getAbstractionState() {
                    return this.getSuccessorState(null);
                }

                @Override
                public AbstractionState from(AbstractionState pOther) {
                    return this.getAbstractionState();
                }
            };
        }
    }
    ,
    ENTERING_EDGES{

        @Override
        public AbstractionStrategy createStrategy(final CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, final MachineModel pMachineModel) {
            final EdgeAnalyzer edgeAnalyzer = new EdgeAnalyzer(pCompoundIntervalManagerFactory, pMachineModel);
            final CompoundIntervalFormulaManager cifm = new CompoundIntervalFormulaManager(pCompoundIntervalManagerFactory);
            return new AbstractionStrategy(){

                @Override
                public AbstractionState getAbstractionState() {
                    return this.getSuccessorState(null);
                }

                @Override
                public AbstractionState from(AbstractionState pOther) {
                    return this.from(pOther, true);
                }

                @Override
                public AbstractionState getSuccessorState(AbstractionState pOther) {
                    return this.from(pOther, false);
                }

                private AbstractionState from(AbstractionState pPrevious, boolean pWithEnteringEdges) {
                    Object previousWideningHints;
                    Object previousWideningTargets;
                    if (pWithEnteringEdges && pPrevious instanceof EnteringEdgesBasedAbstractionState) {
                        return pPrevious;
                    }
                    if (pPrevious instanceof EnteringEdgesBasedAbstractionState) {
                        previousWideningTargets = ((EnteringEdgesBasedAbstractionState)pPrevious).wideningTargets;
                        previousWideningHints = ((EnteringEdgesBasedAbstractionState)pPrevious).wideningHints;
                    } else {
                        previousWideningTargets = ImmutableSet.of();
                        previousWideningHints = ImmutableSet.of();
                    }
                    /*
                     * Exception performing whole class analysis ignored.
                     */
                    class EnteringEdgesBasedAbstractionState
                    implements AbstractionState {
                        private final Set<CFAEdge> visitedEdges;
                        private final Set<MemoryLocation> wideningTargets;
                        private final Set<BooleanFormula<CompoundInterval>> wideningHints;
                        final /* synthetic */ boolean val$pWithEnteringEdges;
                        final /* synthetic */ 1 this$1;

                        private EnteringEdgesBasedAbstractionState(Set<MemoryLocation> pPreviousWideningTargets, Set<BooleanFormula<CompoundInterval>> pPreviousWideningHints) {
                            this(this$1, (Set)ImmutableSet.of(), pPreviousWideningTargets, pPreviousWideningHints, n != 0);
                        }

                        private EnteringEdgesBasedAbstractionState(Set<CFAEdge> pVisitedEdges, Set<MemoryLocation> pWideningTargets, Set<BooleanFormula<CompoundInterval>> pWideningHints) {
                            this.this$1 = this$1;
                            this.val$pWithEnteringEdges = n;
                            this.visitedEdges = pVisitedEdges;
                            this.wideningTargets = pWideningTargets;
                            this.wideningHints = pWideningHints;
                        }

                        private ImmutableSet<MemoryLocation> determineWideningTargets(CFAEdge pEdge) {
                            return this.determineWideningTargets(Collections.singleton(pEdge));
                        }

                        private ImmutableSet<MemoryLocation> determineWideningTargets(Iterable<CFAEdge> pEdges) {
                            ImmutableSet.Builder wideningTargetsBuilder = ImmutableSet.builder();
                            HashSet<CFAEdge> checkedEdges = new HashSet<CFAEdge>();
                            ArrayDeque<CFAEdge> waitlist = new ArrayDeque<CFAEdge>();
                            Iterables.addAll(waitlist, pEdges);
                            while (!waitlist.isEmpty()) {
                                AExpression expression;
                                AVariableDeclaration variableDeclaration;
                                AInitializer initializer;
                                ADeclaration declaration;
                                AExpressionStatement expressionStatement;
                                AExpressionAssignmentStatement expressionAssignmentStatement;
                                AExpression expression2;
                                AbstractCFAEdge edge;
                                CFAEdge lastEdge = (CFAEdge)waitlist.poll();
                                checkedEdges.add(lastEdge);
                                if (lastEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
                                    AFunctionCall functionCall;
                                    FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)lastEdge;
                                    HashSet<CFANode> visited = new HashSet<CFANode>();
                                    ArrayDeque<CFANode> successors = new ArrayDeque<CFANode>();
                                    successors.offer(functionReturnEdge.getPredecessor());
                                    while (!successors.isEmpty()) {
                                        CFANode current = (CFANode)successors.poll();
                                        for (CFAEdge enteringEdge : CFAUtils.allEnteringEdges(current)) {
                                            CFANode newSucc;
                                            if (enteringEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge || !visited.add(newSucc = enteringEdge.getPredecessor())) continue;
                                            if (enteringEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge) {
                                                successors.add(((FunctionReturnEdge)enteringEdge).getSummaryEdge().getPredecessor());
                                            } else {
                                                successors.offer(newSucc);
                                            }
                                            if (checkedEdges.contains(enteringEdge)) continue;
                                            waitlist.add(enteringEdge);
                                        }
                                    }
                                    FunctionSummaryEdge summaryEdge = functionReturnEdge.getSummaryEdge();
                                    if (summaryEdge != null && (functionCall = summaryEdge.getExpression()) instanceof AFunctionCallAssignmentStatement) {
                                        AFunctionCallAssignmentStatement assignmentStatement = (AFunctionCallAssignmentStatement)functionCall;
                                        wideningTargetsBuilder.addAll((Iterable)this.this$1.edgeAnalyzer.getInvolvedVariableTypes((AExpression)assignmentStatement.getLeftHandSide(), (CFAEdge)summaryEdge).keySet());
                                        continue;
                                    }
                                }
                                if (lastEdge.getEdgeType() == CFAEdgeType.StatementEdge && (!(((AStatementEdge)(edge = (AStatementEdge)lastEdge)).getStatement() instanceof AExpressionStatement) ? ((AStatementEdge)edge).getStatement() instanceof AExpressionAssignmentStatement && ((expression2 = (expressionAssignmentStatement = (AExpressionAssignmentStatement)((AStatementEdge)edge).getStatement()).getRightHandSide()) instanceof ALiteralExpression || expression2 instanceof ALeftHandSide) : (expression2 = (expressionStatement = (AExpressionStatement)((AStatementEdge)edge).getStatement()).getExpression()) instanceof ALiteralExpression || expression2 instanceof ALeftHandSide)) continue;
                                if (lastEdge.getEdgeType() == CFAEdgeType.AssumeEdge || lastEdge.getEdgeType() == CFAEdgeType.DeclarationEdge && (declaration = ((ADeclarationEdge)(edge = (ADeclarationEdge)lastEdge)).getDeclaration()) instanceof AVariableDeclaration && ((initializer = (variableDeclaration = (AVariableDeclaration)declaration).getInitializer()) == null || initializer instanceof AInitializerExpression && ((expression = ((AInitializerExpression)initializer).getExpression()) instanceof ALiteralExpression || expression instanceof ALeftHandSide))) continue;
                                wideningTargetsBuilder.addAll(this.this$1.edgeAnalyzer.getInvolvedVariableTypes(lastEdge).keySet());
                            }
                            return wideningTargetsBuilder.build();
                        }

                        @Override
                        public Set<MemoryLocation> determineWideningTargets(AbstractionState pOther) {
                            if (pOther instanceof EnteringEdgesBasedAbstractionState) {
                                EnteringEdgesBasedAbstractionState other = (EnteringEdgesBasedAbstractionState)pOther;
                                if (!this.visitedEdges.containsAll(other.visitedEdges)) {
                                    return Sets.intersection(this.wideningTargets, other.wideningTargets);
                                }
                                return AbstractionStrategyFactories.union(this.wideningTargets, other.wideningTargets);
                            }
                            return this.wideningTargets;
                        }

                        @Override
                        public AbstractionState addEnteringEdge(CFAEdge pEdge) {
                            Object newWideningTargets = this.determineWideningTargets(pEdge);
                            Set<BooleanFormula<CompoundInterval>> newWideningHints = this.determineWideningHints(pEdge);
                            if (this.visitedEdges.contains(pEdge) && this.wideningTargets.containsAll((Collection<?>)newWideningTargets) && this.wideningHints.containsAll(newWideningHints)) {
                                return this;
                            }
                            newWideningHints = AbstractionStrategyFactories.union(this.wideningHints, newWideningHints);
                            newWideningTargets = AbstractionStrategyFactories.union(this.wideningTargets, newWideningTargets);
                            return new EnteringEdgesBasedAbstractionState(this.this$1, AbstractionStrategyFactories.add(this.visitedEdges, pEdge), newWideningTargets, newWideningHints, this.val$pWithEnteringEdges);
                        }

                        private Set<BooleanFormula<CompoundInterval>> determineWideningHints(CFAEdge pEdge) {
                            if (pEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                                NumeralFormula<CompoundInterval> wideningHint;
                                block5: {
                                    AssumeEdge assumeEdge = (AssumeEdge)pEdge;
                                    AExpression expression = assumeEdge.getExpression();
                                    try {
                                        ExpressionToFormulaVisitor expressionToFormulaVisitor = new ExpressionToFormulaVisitor(this.this$1.pCompoundIntervalManagerFactory, this.this$1.pMachineModel, new MemoryLocationExtractor(this.this$1.pCompoundIntervalManagerFactory, this.this$1.pMachineModel, pEdge, this.val$pWithEnteringEdges, (Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>)ImmutableMap.of()));
                                        if (expression instanceof CExpression) {
                                            wideningHint = ((CExpression)expression).accept(expressionToFormulaVisitor);
                                            break block5;
                                        }
                                        if (expression instanceof JExpression) {
                                            wideningHint = ((JExpression)expression).accept(expressionToFormulaVisitor);
                                            break block5;
                                        }
                                        return ImmutableSet.of();
                                    }
                                    catch (UnrecognizedCodeException e) {
                                        return ImmutableSet.of();
                                    }
                                }
                                return this.normalize(Collections.singleton(this.this$1.cifm.fromNumeral(wideningHint)));
                            }
                            return ImmutableSet.of();
                        }

                        private ImmutableSet<BooleanFormula<CompoundInterval>> normalize(Set<BooleanFormula<CompoundInterval>> pToNormalize) {
                            ImmutableSet.Builder builder = ImmutableSet.builder();
                            ArrayDeque<BooleanFormula<CompoundInterval>> toNormalize = new ArrayDeque<BooleanFormula<CompoundInterval>>(pToNormalize);
                            while (!toNormalize.isEmpty()) {
                                NumeralFormula<CompoundInterval> newOp2;
                                BooleanFormula<CompoundInterval> newLT;
                                BooleanFormula hint = (BooleanFormula)toNormalize.poll();
                                if (CompoundIntervalFormulaManager.collectVariableNames(hint).isEmpty()) continue;
                                if (hint instanceof LogicalNot) {
                                    toNormalize.offer(((LogicalNot)hint).getNegated());
                                    continue;
                                }
                                if (hint instanceof LogicalAnd) {
                                    toNormalize.offer(((LogicalAnd)hint).getOperand1());
                                    toNormalize.offer(((LogicalAnd)hint).getOperand2());
                                    continue;
                                }
                                builder.add((Object)hint);
                                builder.add(this.this$1.cifm.logicalNot(hint));
                                if (hint instanceof Equal) {
                                    Equal eq = (Equal)hint;
                                    toNormalize.offer(this.this$1.cifm.lessThan(eq.getOperand1(), eq.getOperand2()));
                                    toNormalize.offer(this.this$1.cifm.greaterThan(eq.getOperand1(), eq.getOperand2()));
                                    continue;
                                }
                                if (!(hint instanceof LessThan)) continue;
                                LessThan lt = (LessThan)hint;
                                NumeralFormula<CompoundInterval> op1 = lt.getOperand1();
                                NumeralFormula<CompoundInterval> op2 = lt.getOperand2();
                                TypeInfo typeInfo = op1.getTypeInfo();
                                CompoundIntervalManager cim = this.this$1.pCompoundIntervalManagerFactory.createCompoundIntervalManager(typeInfo);
                                if (op1 instanceof Constant) {
                                    NumeralFormula<CompoundInterval> newOp1 = InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.add((CompoundInterval)((Constant)op1).getValue(), cim.negate(cim.singleton(BigInteger.ONE))));
                                    newLT = this.this$1.cifm.lessThan(newOp1, op2);
                                    if (newLT instanceof BooleanConstant) continue;
                                    builder.add(newLT);
                                    continue;
                                }
                                if (!(op2 instanceof Constant) || (newLT = this.this$1.cifm.lessThan(op1, newOp2 = InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.add((CompoundInterval)((Constant)op2).getValue(), cim.singleton(BigInteger.ONE))))) instanceof BooleanConstant) continue;
                                builder.add(newLT);
                            }
                            return builder.build();
                        }

                        @Override
                        public AbstractionState join(AbstractionState pOther) {
                            if (pOther == BasicAbstractionStates.NEVER_STATE || pOther == this) {
                                return this;
                            }
                            if (pOther instanceof EnteringEdgesBasedAbstractionState) {
                                EnteringEdgesBasedAbstractionState other = (EnteringEdgesBasedAbstractionState)pOther;
                                if (!(this.visitedEdges != other.visitedEdges && !other.visitedEdges.containsAll(this.visitedEdges) || this.wideningTargets != other.wideningTargets && !other.wideningTargets.containsAll(this.wideningTargets) || this.wideningHints != other.wideningHints && !other.wideningHints.containsAll(this.wideningHints))) {
                                    return other;
                                }
                                if (this.visitedEdges.containsAll(other.visitedEdges) && this.wideningTargets.containsAll(other.wideningTargets)) {
                                    return this;
                                }
                                Set<CFAEdge> edges = AbstractionStrategyFactories.union(this.visitedEdges, other.visitedEdges);
                                Set<MemoryLocation> lastEdges = AbstractionStrategyFactories.union(this.wideningTargets, other.wideningTargets);
                                Set<BooleanFormula<CompoundInterval>> hints = AbstractionStrategyFactories.union(this.wideningHints, other.wideningHints);
                                return new EnteringEdgesBasedAbstractionState(this.this$1, edges, lastEdges, hints, this.val$pWithEnteringEdges);
                            }
                            return BasicAbstractionStates.ALWAYS_STATE;
                        }

                        public boolean equals(Object pO) {
                            if (this == pO) {
                                return true;
                            }
                            if (pO instanceof EnteringEdgesBasedAbstractionState) {
                                EnteringEdgesBasedAbstractionState other = (EnteringEdgesBasedAbstractionState)pO;
                                return this.wideningTargets.equals(other.wideningTargets) && this.visitedEdges.equals(other.visitedEdges) && this.wideningHints.equals(other.wideningHints);
                            }
                            return false;
                        }

                        public int hashCode() {
                            return Objects.hash(this.visitedEdges, this.wideningTargets, this.wideningHints);
                        }

                        public String toString() {
                            return String.format("Widening targets: %s; Visited edges: %s", this.wideningTargets, this.visitedEdges.toString());
                        }

                        @Override
                        public boolean isLessThanOrEqualTo(AbstractionState pOther) {
                            if (pOther instanceof EnteringEdgesBasedAbstractionState) {
                                EnteringEdgesBasedAbstractionState other = (EnteringEdgesBasedAbstractionState)pOther;
                                return other.visitedEdges.containsAll(this.visitedEdges);
                            }
                            return !pOther.isLessThanOrEqualTo(this);
                        }

                        @Override
                        public Set<BooleanFormula<CompoundInterval>> getWideningHints() {
                            return this.wideningHints;
                        }
                    }
                    return new EnteringEdgesBasedAbstractionState(this, (Set)previousWideningTargets, (Set)previousWideningHints, pWithEnteringEdges);
                }
            };
        }
    }
    ,
    NEVER{

        @Override
        public AbstractionStrategy createStrategy(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel) {
            return new AbstractionStrategy(){

                @Override
                public AbstractionState getSuccessorState(AbstractionState pPrevious) {
                    return BasicAbstractionStates.NEVER_STATE;
                }

                @Override
                public AbstractionState getAbstractionState() {
                    return this.getSuccessorState(null);
                }

                @Override
                public AbstractionState from(AbstractionState pOther) {
                    return this.getAbstractionState();
                }
            };
        }
    };


    private static <T> Set<T> union(Set<T> pSet1, Set<T> pSet2) {
        if (pSet1 == pSet2 || pSet2.containsAll(pSet1)) {
            return pSet2;
        }
        if (pSet1.containsAll(pSet2)) {
            return pSet1;
        }
        return new ImmutableSet.Builder().addAll(pSet1).addAll(pSet2).build();
    }

    private static <T> Set<T> add(Set<T> pSet, T pElement) {
        return AbstractionStrategyFactories.union(pSet, Collections.singleton(pElement));
    }

    private static enum BasicAbstractionStates implements AbstractionState
    {
        ALWAYS_STATE{

            @Override
            public Set<MemoryLocation> determineWideningTargets(AbstractionState pOther) {
                return null;
            }

            @Override
            public AbstractionState addEnteringEdge(CFAEdge pEdge) {
                return this;
            }

            @Override
            public AbstractionState join(AbstractionState pOther) {
                return this;
            }

            @Override
            public boolean isLessThanOrEqualTo(AbstractionState pOther) {
                return this.equals(pOther);
            }

            @Override
            public Set<BooleanFormula<CompoundInterval>> getWideningHints() {
                return ImmutableSet.of();
            }
        }
        ,
        NEVER_STATE{

            @Override
            public Set<MemoryLocation> determineWideningTargets(AbstractionState pOther) {
                return ImmutableSet.of();
            }

            @Override
            public AbstractionState addEnteringEdge(CFAEdge pEdge) {
                return this;
            }

            @Override
            public AbstractionState join(AbstractionState pOther) {
                if (pOther == this) {
                    return this;
                }
                return pOther.join(this);
            }

            @Override
            public boolean isLessThanOrEqualTo(AbstractionState pOther) {
                return true;
            }

            @Override
            public Set<BooleanFormula<CompoundInterval>> getWideningHints() {
                return ImmutableSet.of();
            }
        };

    }
}

