/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.FloatingPointTypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;

public class BitVectorInfo
implements TypeInfo {
    private final int size;
    private final boolean signed;
    private final BigInteger minValue;
    private final BigInteger maxValue;

    private BitVectorInfo(int pSize, boolean pSigned) {
        Preconditions.checkArgument((pSize >= 0 ? 1 : 0) != 0, (Object)"bit vector size must not be negative");
        this.size = pSize;
        this.signed = pSigned;
        this.minValue = !this.signed ? BigInteger.ZERO : BigInteger.valueOf(2L).pow(this.size - 1).negate();
        this.maxValue = !this.signed ? BigInteger.valueOf(2L).pow(this.size).subtract(BigInteger.ONE) : BigInteger.valueOf(2L).pow(this.size - 1).subtract(BigInteger.ONE);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    @Override
    public BigInteger getMinValue() {
        return this.minValue;
    }

    @Override
    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    public BitVectorInterval getRange() {
        return BitVectorInterval.of(this, this.minValue, this.maxValue);
    }

    @Override
    public String abbrev() {
        return this.size + (this.signed ? "" : "U");
    }

    public String toString() {
        return String.format("Size: %d; Signed: %b", this.size, this.signed);
    }

    public int hashCode() {
        return this.signed ? -this.size : this.size;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof BitVectorInfo) {
            BitVectorInfo other = (BitVectorInfo)pOther;
            return this.size == other.size && this.signed == other.signed;
        }
        return false;
    }

    public static BitVectorInfo from(int pSize, boolean pSigned) {
        return new BitVectorInfo(pSize, pSigned);
    }

    public static TypeInfo from(MachineModel pMachineModel, Type pType) {
        boolean signed;
        int size;
        block17: {
            Type type;
            block18: {
                block16: {
                    type = pType;
                    if (type instanceof CType) {
                        type = ((CType)type).getCanonicalType();
                    }
                    if (!(type instanceof CType)) break block16;
                    boolean isBitField = false;
                    int bitFieldSize = 0;
                    if (type instanceof CBitFieldType) {
                        isBitField = true;
                        CBitFieldType bitFieldType = (CBitFieldType)type;
                        type = bitFieldType.getType();
                        bitFieldSize = bitFieldType.getBitFieldSize();
                    }
                    if (type instanceof CSimpleType) {
                        CBasicType basicType = ((CSimpleType)type).getType();
                        if (basicType == CBasicType.FLOAT) {
                            return FloatingPointTypeInfo.FLOAT;
                        }
                        if (basicType == CBasicType.DOUBLE) {
                            return FloatingPointTypeInfo.DOUBLE;
                        }
                    }
                    CType cType = (CType)type;
                    size = isBitField ? bitFieldSize : (!(cType instanceof CProblemType) && !cType.isIncomplete() ? pMachineModel.getSizeofInBits(cType).intValueExact() : pMachineModel.getSizeofPtrInBits());
                    assert (size >= 0);
                    signed = type instanceof CSimpleType && pMachineModel.isSigned((CSimpleType)type);
                    break block17;
                }
                if (!(type instanceof JSimpleType)) break block18;
                switch (((JSimpleType)type).getType()) {
                    case BOOLEAN: {
                        size = 32;
                        signed = false;
                        break block17;
                    }
                    case BYTE: {
                        size = 8;
                        signed = true;
                        break block17;
                    }
                    case CHAR: {
                        size = 16;
                        signed = false;
                        break block17;
                    }
                    case SHORT: {
                        size = 16;
                        signed = true;
                        break block17;
                    }
                    case INT: {
                        size = 32;
                        signed = true;
                        break block17;
                    }
                    case LONG: {
                        size = 64;
                        signed = true;
                        break block17;
                    }
                    case FLOAT: {
                        return FloatingPointTypeInfo.FLOAT;
                    }
                    case DOUBLE: {
                        return FloatingPointTypeInfo.DOUBLE;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type: " + type);
                    }
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return BitVectorInfo.from(size, signed);
    }

    public static boolean isSupported(Type pType) {
        Type type = pType;
        if (type instanceof CType) {
            type = ((CType)type).getCanonicalType();
        }
        if (type instanceof CType) {
            if (((CType)type).isIncomplete()) {
                return false;
            }
            if (!(type instanceof CSimpleType)) {
                return type instanceof CPointerType;
            }
            switch (((CSimpleType)type).getType()) {
                case CHAR: 
                case INT: {
                    return true;
                }
            }
            return false;
        }
        if (type instanceof JSimpleType) {
            switch (((JSimpleType)type).getType()) {
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public BitVectorInfo extend(int pExtension) {
        return new BitVectorInfo(this.size + pExtension, this.signed);
    }
}

