/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorType;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;

public class BitVectorInterval
implements BitVectorType {
    private final BigInteger lowerBound;
    private final BigInteger upperBound;
    private final BitVectorInfo info;

    private BitVectorInterval(BitVectorInfo pInfo, BigInteger pLowerBound, BigInteger pUpperBound) {
        Preconditions.checkNotNull((Object)pInfo);
        Preconditions.checkNotNull((Object)pLowerBound);
        Preconditions.checkNotNull((Object)pUpperBound);
        Preconditions.checkArgument((pLowerBound.compareTo(pUpperBound) <= 0 ? 1 : 0) != 0, (Object)"lower endpoint greater than upper end point");
        Preconditions.checkArgument((pLowerBound.compareTo(pInfo.getMinValue()) >= 0 ? 1 : 0) != 0, (Object)"lower bound must fit the bit vector");
        Preconditions.checkArgument((pUpperBound.compareTo(pInfo.getMaxValue()) <= 0 ? 1 : 0) != 0, (Object)"upper bound must fit the bit vector");
        this.info = pInfo;
        this.lowerBound = pLowerBound;
        this.upperBound = pUpperBound;
    }

    @Override
    public BitVectorInfo getTypeInfo() {
        return this.info;
    }

    public BigInteger getLowerBound() {
        return this.lowerBound;
    }

    public BigInteger getUpperBound() {
        return this.upperBound;
    }

    public boolean isTop() {
        return false;
    }

    public void checkBitVectorCompatibilityWith(BitVectorInterval pOther) {
        Preconditions.checkArgument((boolean)this.info.equals(pOther.info), (Object)"bit vectors are incompatible in size or signedness");
    }

    public BitVectorInterval intersectWith(BitVectorInterval pOther) {
        this.checkBitVectorCompatibilityWith(pOther);
        Preconditions.checkArgument((boolean)this.intersectsWith(pOther));
        if (this.isSingleton() || pOther.contains(this)) {
            return this;
        }
        if (pOther.isSingleton() || this.contains(pOther)) {
            return pOther;
        }
        BigInteger newLowerBound = this.lowerBound.max(pOther.getLowerBound());
        BigInteger newUpperBound = this.upperBound.min(pOther.getUpperBound());
        return new BitVectorInterval(this.info, newLowerBound, newUpperBound);
    }

    public BitVectorInterval getNegativePart() {
        Preconditions.checkArgument((boolean)this.containsNegative(), (Object)"This interval has no negative part.");
        return BitVectorInterval.of(this.info, this.lowerBound, BigInteger.valueOf(-1L).min(this.upperBound));
    }

    public BitVectorInterval getPositivePart() {
        Preconditions.checkArgument((boolean)this.containsPositive(), (Object)"This interval has no positive part.");
        return BitVectorInterval.of(this.info, BigInteger.ONE.max(this.lowerBound), this.upperBound);
    }

    public boolean hasLowerBound() {
        return true;
    }

    public boolean hasUpperBound() {
        return true;
    }

    public boolean containsPositive() {
        return this.upperBound.signum() == 1;
    }

    public boolean containsZero() {
        return this.upperBound.signum() >= 0 && this.lowerBound.signum() <= 0;
    }

    public boolean contains(BigInteger pValue) {
        return this.upperBound.compareTo(pValue) >= 0 && this.lowerBound.compareTo(pValue) <= 0;
    }

    public boolean containsNegative() {
        return this.lowerBound.signum() == -1;
    }

    public BigInteger size() {
        return this.upperBound.subtract(this.lowerBound).add(BigInteger.ONE);
    }

    public boolean isSingleton() {
        return this.lowerBound.equals(this.upperBound);
    }

    public BitVectorInterval negate(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        boolean ubExceedsAbove;
        BigInteger newLowerBound = this.upperBound.negate();
        BigInteger newUpperBound = this.lowerBound.negate();
        boolean lbExceedsBelow = newLowerBound.compareTo(this.info.getMinValue()) < 0;
        boolean lbExceedsAbove = !lbExceedsBelow && newLowerBound.compareTo(this.info.getMaxValue()) > 0;
        boolean ubExceedsBelow = newUpperBound.compareTo(this.info.getMinValue()) < 0;
        boolean bl = ubExceedsAbove = !ubExceedsBelow && newUpperBound.compareTo(this.info.getMaxValue()) > 0;
        if (lbExceedsBelow || lbExceedsAbove || ubExceedsBelow || ubExceedsAbove) {
            BigInteger fromUB;
            if (!pAllowSignedWrapAround && this.info.isSigned()) {
                pOverflowEventHandler.signedOverflow();
                return this.info.getRange();
            }
            BigInteger rangeLength = this.info.getRange().size();
            BigInteger fromLB = lbExceedsBelow ? rangeLength.add(newLowerBound) : (lbExceedsAbove ? newLowerBound.subtract(rangeLength) : newLowerBound);
            if (fromLB.compareTo(fromUB = ubExceedsBelow ? rangeLength.add(newUpperBound) : (ubExceedsAbove ? newUpperBound.subtract(rangeLength) : newUpperBound)) > 0) {
                return this.info.getRange();
            }
            newLowerBound = fromLB;
            newUpperBound = fromUB;
        }
        return new BitVectorInterval(this.info, newLowerBound, newUpperBound);
    }

    public static BitVectorInterval cast(BitVectorInfo pInfo, BigInteger pI, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        if (pInfo.getRange().contains(pI)) {
            return BitVectorInterval.singleton(pInfo, pI);
        }
        if (!pAllowSignedWrapAround && pInfo.isSigned()) {
            pOverflowEventHandler.signedOverflow();
            return pInfo.getRange();
        }
        BigInteger rangeLength = pInfo.getRange().size();
        BigInteger value = pI.remainder(rangeLength);
        if (value.compareTo(pInfo.getMinValue()) < 0) {
            value = value.add(rangeLength);
        } else if (value.compareTo(pInfo.getMaxValue()) > 0) {
            value = value.subtract(rangeLength);
        }
        return BitVectorInterval.singleton(pInfo, value);
    }

    public static BitVectorInterval cast(BitVectorInfo pInfo, BigInteger pLowerBound, BigInteger pUpperBound, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        boolean ubExceedsAbove;
        if (pLowerBound.equals(pUpperBound)) {
            return BitVectorInterval.cast(pInfo, pLowerBound, pAllowSignedWrapAround, pOverflowEventHandler);
        }
        BigInteger lowerBound = pLowerBound;
        BigInteger upperBound = pUpperBound;
        boolean lbExceedsBelow = lowerBound.compareTo(pInfo.getMinValue()) < 0;
        boolean lbExceedsAbove = !lbExceedsBelow && lowerBound.compareTo(pInfo.getMaxValue()) > 0;
        boolean ubExceedsBelow = upperBound.compareTo(pInfo.getMinValue()) < 0;
        boolean bl = ubExceedsAbove = !ubExceedsBelow && upperBound.compareTo(pInfo.getMaxValue()) > 0;
        if (!(lbExceedsBelow || lbExceedsAbove || ubExceedsBelow || ubExceedsAbove)) {
            return BitVectorInterval.of(pInfo, pLowerBound, pUpperBound);
        }
        if (!pAllowSignedWrapAround && pInfo.isSigned()) {
            pOverflowEventHandler.signedOverflow();
            return pInfo.getRange();
        }
        BigInteger rangeLength = pInfo.getRange().size();
        assert (rangeLength.compareTo(BigInteger.ZERO) >= 0);
        if (upperBound.subtract(lowerBound).add(BigInteger.ONE).compareTo(rangeLength) >= 0) {
            return pInfo.getRange();
        }
        if (ubExceedsBelow) {
            lowerBound = pLowerBound.remainder(rangeLength);
            if (lowerBound.compareTo(pInfo.getMinValue()) < 0) {
                lowerBound = lowerBound.add(rangeLength);
            }
            upperBound = lowerBound.add(pUpperBound.subtract(pLowerBound));
            assert (lowerBound.compareTo(pInfo.getMinValue()) >= 0);
            if (upperBound.compareTo(pInfo.getMaxValue()) > 0) {
                return pInfo.getRange();
            }
        } else if (lbExceedsAbove) {
            upperBound = pUpperBound.remainder(rangeLength);
            if (upperBound.compareTo(pInfo.getMaxValue()) > 0) {
                upperBound = upperBound.subtract(rangeLength);
            }
            lowerBound = upperBound.subtract(pUpperBound.subtract(pLowerBound));
            assert (upperBound.compareTo(pInfo.getMaxValue()) <= 0);
            if (lowerBound.compareTo(pInfo.getMinValue()) < 0) {
                return pInfo.getRange();
            }
        } else {
            if (lbExceedsBelow) {
                return pInfo.getRange();
            }
            if (ubExceedsAbove) {
                return pInfo.getRange();
            }
        }
        return BitVectorInterval.of(pInfo, lowerBound, upperBound);
    }

    public BitVectorInterval extendToMaxValue() {
        if (this.upperBound.equals(this.info.getMaxValue())) {
            return this;
        }
        return new BitVectorInterval(this.info, this.lowerBound, this.info.getMaxValue());
    }

    public BitVectorInterval extendToMinValue() {
        if (this.lowerBound.equals(this.info.getMinValue())) {
            return this;
        }
        return new BitVectorInterval(this.info, this.info.getMinValue(), this.upperBound);
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (!(pObj instanceof BitVectorInterval)) {
            return false;
        }
        BitVectorInterval other = (BitVectorInterval)pObj;
        return Objects.equals(this.lowerBound, other.lowerBound) && Objects.equals(this.upperBound, other.upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public String toString() {
        return "[" + this.lowerBound + ", " + this.upperBound + "]";
    }

    public boolean contains(BitVectorInterval pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        return this.lowerBound.compareTo(pOther.lowerBound) <= 0 && this.upperBound.compareTo(pOther.upperBound) >= 0;
    }

    public boolean touches(BitVectorInterval pOther) {
        if (pOther == null) {
            return false;
        }
        if (this.intersectsWith(pOther)) {
            return true;
        }
        return pOther.upperBound.add(BigInteger.ONE).equals(this.lowerBound) || this.upperBound.add(BigInteger.ONE).equals(pOther.lowerBound);
    }

    public boolean intersectsWith(BitVectorInterval other) {
        if (this == other) {
            return true;
        }
        boolean aLessThanOrEqB = this.lowerBound.compareTo(other.upperBound) <= 0;
        boolean bGreaterThanOrEqC = this.upperBound.compareTo(other.lowerBound) >= 0;
        return aLessThanOrEqB && bGreaterThanOrEqC;
    }

    public BigInteger closestNegativeToZero() {
        Preconditions.checkState((boolean)this.containsNegative());
        if (this.isSingleton()) {
            return this.getLowerBound();
        }
        if (this.getUpperBound().signum() < 0) {
            return this.getUpperBound();
        }
        return BigInteger.ONE.negate();
    }

    public List<BigInteger> getSplitZeroBounds() {
        ArrayList<BigInteger> divisors = new ArrayList<BigInteger>((this.containsPositive() ? (this.closestPositiveToZero().equals(this.getUpperBound()) ? 1 : 2) : 0) + (this.containsNegative() ? (this.closestNegativeToZero().equals(this.getLowerBound()) ? 1 : 2) : 0));
        if (this.containsPositive()) {
            divisors.add(this.closestPositiveToZero());
            if (!this.closestPositiveToZero().equals(this.getUpperBound())) {
                divisors.add(this.getUpperBound());
            }
        }
        if (this.containsNegative()) {
            divisors.add(this.closestNegativeToZero());
            if (!this.closestNegativeToZero().equals(this.getLowerBound())) {
                divisors.add(this.getLowerBound());
            }
        }
        return divisors;
    }

    public BigInteger closestPositiveToZero() {
        Preconditions.checkState((boolean)this.containsPositive());
        if (this.isSingleton()) {
            return this.getLowerBound();
        }
        if (this.getLowerBound().signum() > 0) {
            return this.getLowerBound();
        }
        return BigInteger.ONE;
    }

    public static BitVectorInterval singleton(BitVectorInfo pInfo, BigInteger pI) {
        return new BitVectorInterval(pInfo, pI, pI);
    }

    public static BitVectorInterval greaterOrEqual(BitVectorInfo pInfo, BigInteger pI) {
        return BitVectorInterval.singleton(pInfo, pI).extendToMaxValue();
    }

    public static BitVectorInterval lessOrEqual(BitVectorInfo pInfo, BigInteger pI) {
        return BitVectorInterval.singleton(pInfo, pI).extendToMinValue();
    }

    public static BitVectorInterval of(BitVectorInfo pInfo, BigInteger pLowerBound, BigInteger pUpperBound) {
        return new BitVectorInterval(pInfo, pLowerBound, pUpperBound);
    }

    public static BitVectorInterval span(BitVectorInterval a, BitVectorInterval b) {
        a.checkBitVectorCompatibilityWith(b);
        BigInteger lower = a.lowerBound == null || b.lowerBound == null ? null : a.lowerBound.min(b.lowerBound);
        BigInteger upper = a.upperBound == null || b.upperBound == null ? null : a.upperBound.max(b.upperBound);
        if (Objects.equals(lower, a.lowerBound) && Objects.equals(upper, a.upperBound)) {
            return a;
        }
        if (Objects.equals(lower, b.lowerBound) && Objects.equals(upper, b.upperBound)) {
            return b;
        }
        return new BitVectorInterval(a.info, lower, upper);
    }
}

