/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorType;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntegralInterval;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.ICCOperatorFactory;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.IICOperatorFactory;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.ISCOperatorFactory;

public class CompoundBitVectorInterval
implements CompoundIntegralInterval,
BitVectorType {
    private final BitVectorInfo info;
    private final BitVectorInterval[] intervals;

    private CompoundBitVectorInterval(BitVectorInfo pInfo) {
        Preconditions.checkNotNull((Object)pInfo);
        this.info = pInfo;
        this.intervals = new BitVectorInterval[0];
    }

    private CompoundBitVectorInterval(BitVectorInterval pInterval) {
        this.info = pInterval.getTypeInfo();
        this.intervals = new BitVectorInterval[]{pInterval};
    }

    private CompoundBitVectorInterval(BitVectorInfo pInfo, BitVectorInterval[] pIntervals) {
        Preconditions.checkNotNull((Object)pInfo);
        Preconditions.checkNotNull((Object)pIntervals);
        this.info = pInfo;
        this.intervals = pIntervals;
    }

    private static CompoundBitVectorInterval getInternal(BitVectorInterval pInterval) {
        return new CompoundBitVectorInterval(pInterval);
    }

    private static CompoundBitVectorInterval getInternal(BitVectorInfo pInfo, BitVectorInterval[] pIntervals) {
        if (pIntervals.length == 0) {
            return CompoundBitVectorInterval.bottom(pInfo);
        }
        return new CompoundBitVectorInterval(pInfo, pIntervals);
    }

    @Override
    public BitVectorInfo getTypeInfo() {
        return this.info;
    }

    public int getNumberOfIntervals() {
        return this.intervals.length;
    }

    public List<BitVectorInterval> getBitVectorIntervals() {
        return Collections.unmodifiableList(Arrays.asList(this.intervals));
    }

    @Override
    public List<SimpleInterval> getIntervals() {
        return Lists.transform(this.getBitVectorIntervals(), pBitVectorInterval -> SimpleInterval.of(pBitVectorInterval.getLowerBound(), pBitVectorInterval.getUpperBound()));
    }

    public List<CompoundBitVectorInterval> splitIntoIntervals() {
        return Lists.transform(Arrays.asList(this.intervals), CompoundBitVectorInterval::of);
    }

    public void checkBitVectorCompatibilityWith(BitVectorInfo pOtherInfo) {
        Preconditions.checkArgument((boolean)this.info.equals(pOtherInfo), (Object)"bit vectors are incompatible in size or signedness");
    }

    public CompoundBitVectorInterval unionWith(CompoundBitVectorInterval pOther) {
        this.checkBitVectorCompatibilityWith(pOther.info);
        if (pOther == this || this.containsAllPossibleValues() || pOther.isBottom()) {
            return this;
        }
        if (pOther.containsAllPossibleValues() || this.isBottom()) {
            return pOther;
        }
        CompoundBitVectorInterval current = this;
        for (BitVectorInterval interval : pOther.intervals) {
            current = current.unionWith(interval);
        }
        return current;
    }

    public CompoundBitVectorInterval unionWith(BitVectorInterval pOther) {
        this.checkBitVectorCompatibilityWith(pOther.getTypeInfo());
        if (this.contains(pOther)) {
            return this;
        }
        if (this.isBottom() || pOther.isTop()) {
            return CompoundBitVectorInterval.getInternal(pOther);
        }
        ArrayList<BitVectorInterval> resultIntervals = new ArrayList<BitVectorInterval>();
        int start = 0;
        BitVectorInterval lastInterval = null;
        if (pOther.hasLowerBound() && this.hasUpperBound()) {
            BigInteger pOtherLB = pOther.getLowerBound();
            BitVectorInterval currentLocal = this.intervals[start];
            while (currentLocal != null && pOtherLB.compareTo(currentLocal.getUpperBound()) > 0) {
                resultIntervals.add(currentLocal);
                lastInterval = currentLocal;
                BitVectorInterval bitVectorInterval = currentLocal = ++start < this.intervals.length ? this.intervals[start] : null;
                assert (currentLocal == null || currentLocal.hasUpperBound()) : this.toString();
            }
        }
        boolean inserted = false;
        for (int index = start; index < this.intervals.length; ++index) {
            BitVectorInterval interval = this.intervals[index];
            boolean currentInserted = false;
            if (interval.touches(lastInterval)) {
                lastInterval = CompoundBitVectorInterval.union(interval, lastInterval);
                resultIntervals.set(resultIntervals.size() - 1, lastInterval);
                currentInserted = true;
            }
            if (!inserted) {
                if (pOther.touches(lastInterval)) {
                    if ((lastInterval = CompoundBitVectorInterval.union(pOther, lastInterval)).touches(interval)) {
                        lastInterval = CompoundBitVectorInterval.union(lastInterval, interval);
                        currentInserted = true;
                    }
                    resultIntervals.set(resultIntervals.size() - 1, lastInterval);
                    inserted = true;
                } else if (pOther.touches(interval)) {
                    lastInterval = CompoundBitVectorInterval.union(pOther, interval);
                    resultIntervals.add(lastInterval);
                    inserted = true;
                    currentInserted = true;
                } else if (!pOther.hasLowerBound() || interval.hasLowerBound() && CompoundBitVectorInterval.less(pOther.getLowerBound(), interval.getLowerBound())) {
                    resultIntervals.add(pOther);
                    inserted = true;
                }
                if (currentInserted) continue;
                lastInterval = interval;
                resultIntervals.add(lastInterval);
                continue;
            }
            if (currentInserted) continue;
            lastInterval = interval;
            resultIntervals.add(lastInterval);
        }
        if (!inserted) {
            if (pOther.touches(lastInterval)) {
                resultIntervals.remove(resultIntervals.size() - 1);
                lastInterval = CompoundBitVectorInterval.union(pOther, lastInterval);
                resultIntervals.add(lastInterval);
            } else {
                resultIntervals.add(pOther);
            }
        }
        BitVectorInterval[] resultArray = new BitVectorInterval[resultIntervals.size()];
        return CompoundBitVectorInterval.getInternal(this.info, resultIntervals.toArray(resultArray));
    }

    public CompoundBitVectorInterval intersectWith(CompoundBitVectorInterval pOther) {
        this.checkBitVectorCompatibilityWith(pOther.info);
        if (this.isBottom() || pOther.containsAllPossibleValues() || this == pOther) {
            return this;
        }
        if (this.containsAllPossibleValues() || pOther.isBottom()) {
            return pOther;
        }
        if (pOther.contains(this)) {
            return this;
        }
        CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
        for (BitVectorInterval otherInterval : pOther.intervals) {
            result = result.unionWith(this.intersectWith(otherInterval));
        }
        return result;
    }

    public CompoundBitVectorInterval intersectWith(BitVectorInterval pOther) {
        int intervalIndex;
        int intervalIndex2;
        this.checkBitVectorCompatibilityWith(pOther.getTypeInfo());
        if (this.isBottom() || pOther.isTop()) {
            return this;
        }
        if (this.contains(pOther)) {
            return CompoundBitVectorInterval.of(pOther);
        }
        if (this.intervals.length == 1 && pOther.contains(this.intervals[0])) {
            return this;
        }
        CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
        int lbIndex = pOther.hasLowerBound() ? ((intervalIndex2 = this.intervalIndexOf(pOther.getLowerBound())) >= 0 ? intervalIndex2 : -intervalIndex2 - 1) : 0;
        int ubIndex = pOther.hasUpperBound() ? ((intervalIndex = this.intervalIndexOf(pOther.getUpperBound())) >= 0 ? intervalIndex : -intervalIndex - 1) : this.intervals.length - 1;
        for (int i = lbIndex; i <= ubIndex; ++i) {
            BitVectorInterval interval = this.intervals[i];
            if (!interval.intersectsWith(pOther)) continue;
            result = result.unionWith(interval.intersectWith(pOther));
        }
        return result;
    }

    public boolean intersectsWith(CompoundBitVectorInterval pOther) {
        if (this.contains(pOther)) {
            return !pOther.isBottom();
        }
        if (pOther.contains(this)) {
            return !this.isBottom();
        }
        return !this.intersectWith(pOther).isBottom();
    }

    public boolean intersectsWith(BitVectorInterval pOther) {
        if (this.contains(pOther)) {
            return true;
        }
        return !this.intersectWith(pOther).isBottom();
    }

    public boolean contains(CompoundBitVectorInterval pState) {
        if (this == pState) {
            return true;
        }
        for (BitVectorInterval interval : pState.intervals) {
            if (this.contains(interval)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(BitVectorInterval pInterval) {
        if (this.isBottom() || pInterval.isTop()) {
            return false;
        }
        if (!pInterval.hasLowerBound() && this.hasLowerBound()) {
            return false;
        }
        if (!pInterval.hasUpperBound() && this.hasUpperBound()) {
            return false;
        }
        boolean hasLowerBound = pInterval.hasLowerBound();
        boolean hasUpperBound = pInterval.hasUpperBound();
        BigInteger lb = hasLowerBound ? pInterval.getLowerBound() : null;
        BigInteger ub = hasUpperBound ? pInterval.getUpperBound() : null;
        int leftInclusive = 0;
        int rightExclusive = this.intervals.length;
        while (leftInclusive < rightExclusive) {
            boolean ubIndexGeqUb;
            int index = IntMath.mean((int)leftInclusive, (int)rightExclusive);
            BitVectorInterval intervalAtIndex = this.intervals[index];
            boolean lbIndexLeqLb = !intervalAtIndex.hasLowerBound() || hasLowerBound && intervalAtIndex.getLowerBound().compareTo(lb) <= 0;
            boolean bl = ubIndexGeqUb = !intervalAtIndex.hasUpperBound() || hasUpperBound && intervalAtIndex.getUpperBound().compareTo(ub) >= 0;
            if (lbIndexLeqLb) {
                if (ubIndexGeqUb) {
                    return true;
                }
                leftInclusive = index + 1;
                continue;
            }
            rightExclusive = index;
        }
        return false;
    }

    private int intervalIndexOf(BigInteger value) {
        if (this.isBottom()) {
            return -1;
        }
        if (this.containsAllPossibleValues()) {
            return 0;
        }
        int leftInclusive = 0;
        int rightExclusive = this.intervals.length;
        int index = rightExclusive / 2;
        while (leftInclusive < rightExclusive) {
            boolean ubIndexGeqValue;
            BitVectorInterval intervalAtIndex = this.intervals[index];
            boolean lbIndexLeqValue = !intervalAtIndex.hasLowerBound() || intervalAtIndex.getLowerBound().compareTo(value) <= 0;
            boolean bl = ubIndexGeqValue = !intervalAtIndex.hasUpperBound() || intervalAtIndex.getUpperBound().compareTo(value) >= 0;
            if (lbIndexLeqValue) {
                if (ubIndexGeqValue) {
                    return index;
                }
                leftInclusive = index + 1;
            } else {
                rightExclusive = index;
            }
            index = IntMath.mean((int)leftInclusive, (int)rightExclusive);
        }
        return index == 0 ? -1 : -index;
    }

    @Override
    public boolean contains(BigInteger pValue) {
        if (this.isBottom()) {
            return false;
        }
        if (pValue.compareTo(this.info.getMinValue()) < 0) {
            return false;
        }
        if (pValue.compareTo(this.info.getMaxValue()) > 0) {
            return false;
        }
        return this.contains(CompoundBitVectorInterval.singleton(this.info, pValue));
    }

    public boolean contains(long pValue) {
        if (this.isBottom()) {
            return false;
        }
        BigInteger value = BigInteger.valueOf(pValue);
        return this.intervalIndexOf(value) >= 0;
    }

    @Override
    public boolean isBottom() {
        return this.intervals.length == 0;
    }

    @Override
    public boolean containsAllPossibleValues() {
        return this.contains(this.info.getRange());
    }

    public String toString() {
        if (this.isBottom()) {
            return Character.toString('\u22a5');
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (!this.isBottom()) {
            Iterator<BitVectorInterval> intervalIterator = Arrays.asList(this.intervals).iterator();
            sb.append(intervalIterator.next());
            while (intervalIterator.hasNext()) {
                sb.append(", ");
                sb.append(intervalIterator.next());
            }
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean hasLowerBound() {
        return !this.isBottom();
    }

    @Override
    public boolean hasUpperBound() {
        return !this.isBottom();
    }

    @Override
    public BigInteger getLowerBound() {
        return this.intervals[0].getLowerBound();
    }

    @Override
    public BigInteger getUpperBound() {
        return this.intervals[this.intervals.length - 1].getUpperBound();
    }

    @Override
    public boolean isSingleton() {
        return !this.isBottom() && this.intervals.length == 1 && this.intervals[0].isSingleton();
    }

    @Override
    public @Nullable BigInteger getValue() {
        if (this.isBottom()) {
            return null;
        }
        if (this.containsAllPossibleValues()) {
            return BigInteger.ZERO;
        }
        for (BitVectorInterval interval : this.intervals) {
            if (interval.hasLowerBound()) {
                return interval.getLowerBound();
            }
            if (!interval.hasUpperBound()) continue;
            return interval.getUpperBound();
        }
        return null;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther instanceof CompoundBitVectorInterval) {
            CompoundBitVectorInterval other = (CompoundBitVectorInterval)pOther;
            return this.info.equals(other.info) && Arrays.equals(this.intervals, other.intervals);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.info, Arrays.hashCode(this.intervals));
    }

    public CompoundBitVectorInterval cast(BitVectorInfo pBitVectorInfo, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        if (this.info.equals(pBitVectorInfo)) {
            return this;
        }
        if (pBitVectorInfo.getRange().contains(this.info.getRange())) {
            BitVectorInterval[] castedIntervals = new BitVectorInterval[this.intervals.length];
            Lists.transform(this.getBitVectorIntervals(), pInterval -> BitVectorInterval.of(pBitVectorInfo, pInterval.getLowerBound(), pInterval.getUpperBound())).toArray(castedIntervals);
            return new CompoundBitVectorInterval(pBitVectorInfo, castedIntervals);
        }
        CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(pBitVectorInfo);
        for (BitVectorInterval interval : this.intervals) {
            result = result.unionWith(CompoundBitVectorInterval.cast(pBitVectorInfo, interval.getLowerBound(), interval.getUpperBound(), pAllowSignedWrapAround, pOverflowEventHandler));
        }
        return result;
    }

    public static CompoundBitVectorInterval cast(BitVectorInfo pInfo, BigInteger pLowerBound, BigInteger pUpperBound, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        boolean ubExceedsAbove;
        if (pLowerBound.equals(pUpperBound)) {
            return CompoundBitVectorInterval.of(BitVectorInterval.cast(pInfo, pLowerBound, pAllowSignedWrapAround, pOverflowEventHandler));
        }
        BigInteger lowerBound = pLowerBound;
        BigInteger upperBound = pUpperBound;
        boolean lbExceedsBelow = lowerBound.compareTo(pInfo.getMinValue()) < 0;
        boolean lbExceedsAbove = !lbExceedsBelow && lowerBound.compareTo(pInfo.getMaxValue()) > 0;
        boolean ubExceedsBelow = upperBound.compareTo(pInfo.getMinValue()) < 0;
        boolean bl = ubExceedsAbove = !ubExceedsBelow && upperBound.compareTo(pInfo.getMaxValue()) > 0;
        if (!(lbExceedsBelow || lbExceedsAbove || ubExceedsBelow || ubExceedsAbove)) {
            return CompoundBitVectorInterval.of(BitVectorInterval.of(pInfo, pLowerBound, pUpperBound));
        }
        if (!pAllowSignedWrapAround && pInfo.isSigned()) {
            pOverflowEventHandler.signedOverflow();
            return CompoundBitVectorInterval.of(pInfo.getRange());
        }
        BigInteger rangeLength = pInfo.getRange().size();
        assert (rangeLength.compareTo(BigInteger.ZERO) >= 0);
        if (upperBound.subtract(lowerBound).add(BigInteger.ONE).compareTo(rangeLength) >= 0) {
            return CompoundBitVectorInterval.of(pInfo.getRange());
        }
        if (ubExceedsBelow) {
            lowerBound = pLowerBound.remainder(rangeLength);
            if (lowerBound.compareTo(pInfo.getMinValue()) < 0) {
                lowerBound = lowerBound.add(rangeLength);
            }
            upperBound = lowerBound.add(pUpperBound.subtract(pLowerBound));
            assert (lowerBound.compareTo(pInfo.getMinValue()) >= 0);
            if (upperBound.compareTo(pInfo.getMaxValue()) > 0) {
                return CompoundBitVectorInterval.union(CompoundBitVectorInterval.singleton(pInfo, lowerBound).extendToMaxValue(), CompoundBitVectorInterval.cast(pInfo, pInfo.getMaxValue().add(BigInteger.ONE), upperBound, pAllowSignedWrapAround, pOverflowEventHandler));
            }
        } else if (lbExceedsAbove) {
            upperBound = pUpperBound.remainder(rangeLength);
            if (upperBound.compareTo(pInfo.getMaxValue()) > 0) {
                upperBound = upperBound.subtract(rangeLength);
            }
            lowerBound = upperBound.subtract(pUpperBound.subtract(pLowerBound));
            assert (upperBound.compareTo(pInfo.getMaxValue()) <= 0);
            if (lowerBound.compareTo(pInfo.getMinValue()) < 0) {
                return CompoundBitVectorInterval.union(CompoundBitVectorInterval.singleton(pInfo, upperBound).extendToMinValue(), CompoundBitVectorInterval.cast(pInfo, lowerBound, pInfo.getMinValue().subtract(BigInteger.ONE), pAllowSignedWrapAround, pOverflowEventHandler));
            }
        } else {
            if (lbExceedsBelow) {
                return CompoundBitVectorInterval.union(CompoundBitVectorInterval.cast(pInfo, pLowerBound, pInfo.getMinValue().subtract(BigInteger.ONE), pAllowSignedWrapAround, pOverflowEventHandler), CompoundBitVectorInterval.cast(pInfo, pInfo.getMinValue(), pUpperBound, pAllowSignedWrapAround, pOverflowEventHandler));
            }
            if (ubExceedsAbove) {
                return CompoundBitVectorInterval.union(CompoundBitVectorInterval.cast(pInfo, pLowerBound, pInfo.getMaxValue(), pAllowSignedWrapAround, pOverflowEventHandler), CompoundBitVectorInterval.cast(pInfo, pInfo.getMaxValue().add(BigInteger.ONE), pUpperBound, pAllowSignedWrapAround, pOverflowEventHandler));
            }
        }
        return CompoundBitVectorInterval.of(BitVectorInterval.of(pInfo, lowerBound, upperBound));
    }

    @Override
    public CompoundBitVectorInterval signum() {
        CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
        if (this.containsNegative()) {
            result = result.unionWith(CompoundBitVectorInterval.singleton(this.info, -1L));
        }
        if (this.containsZero()) {
            result = result.unionWith(CompoundBitVectorInterval.singleton(this.info, 0L));
        }
        if (this.containsPositive()) {
            result = result.unionWith(CompoundBitVectorInterval.singleton(this.info, 1L));
        }
        return result;
    }

    @Override
    public CompoundBitVectorInterval span() {
        BigInteger lowerBound = this.getLowerBound();
        BigInteger upperBound = this.getUpperBound();
        return CompoundBitVectorInterval.of(BitVectorInterval.of(this.info, lowerBound, upperBound));
    }

    @Override
    public CompoundBitVectorInterval invert() {
        BitVectorInterval current;
        if (this.contains(this.info.getRange())) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (this.isBottom()) {
            return CompoundBitVectorInterval.getInternal(this.info.getRange());
        }
        CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
        int index = 0;
        if (!(current = this.intervals[index++]).getLowerBound().equals(this.info.getMinValue())) {
            result = result.unionWith(BitVectorInterval.of(this.info, this.info.getMinValue(), current.getLowerBound().subtract(BigInteger.ONE)));
        }
        BigInteger lastUpperBound = current.getUpperBound();
        while (index < this.intervals.length) {
            current = this.intervals[index++];
            result = result.unionWith(BitVectorInterval.of(this.info, lastUpperBound.add(BigInteger.ONE), current.getLowerBound().subtract(BigInteger.ONE)));
            lastUpperBound = current.getUpperBound();
        }
        if (!lastUpperBound.equals(this.info.getMaxValue())) {
            result = result.unionWith(BitVectorInterval.of(this.info, lastUpperBound.add(BigInteger.ONE), this.info.getMaxValue()));
        }
        return result;
    }

    public CompoundBitVectorInterval negate(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        if (this.containsAllPossibleValues() || this.isBottom()) {
            return this;
        }
        CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
        for (BitVectorInterval simpleInterval : this.intervals) {
            result = result.unionWith(CompoundBitVectorInterval.negate(this.info, simpleInterval, pAllowSignedWrapAround, pOverflowEventHandler));
        }
        return result;
    }

    private static CompoundBitVectorInterval negate(BitVectorInfo pInfo, BitVectorInterval pInterval, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        boolean ubExceedsAbove;
        BigInteger newLowerBound = pInterval.getUpperBound().negate();
        BigInteger newUpperBound = pInterval.getLowerBound().negate();
        boolean lbExceedsBelow = newLowerBound.compareTo(pInfo.getMinValue()) < 0;
        boolean lbExceedsAbove = !lbExceedsBelow && newLowerBound.compareTo(pInfo.getMaxValue()) > 0;
        boolean ubExceedsBelow = newUpperBound.compareTo(pInfo.getMinValue()) < 0;
        boolean bl = ubExceedsAbove = !ubExceedsBelow && newUpperBound.compareTo(pInfo.getMaxValue()) > 0;
        if (lbExceedsBelow || lbExceedsAbove || ubExceedsBelow || ubExceedsAbove) {
            BigInteger fromUB;
            if (!pAllowSignedWrapAround && pInfo.isSigned()) {
                pOverflowEventHandler.signedOverflow();
                return CompoundBitVectorInterval.of(pInfo.getRange());
            }
            BigInteger rangeLength = pInfo.getRange().size();
            BigInteger fromLB = lbExceedsBelow ? rangeLength.add(newLowerBound) : (lbExceedsAbove ? newLowerBound.subtract(rangeLength) : newLowerBound);
            if (fromLB.compareTo(fromUB = ubExceedsBelow ? rangeLength.add(newUpperBound) : (ubExceedsAbove ? newUpperBound.subtract(rangeLength) : newUpperBound)) > 0) {
                if (fromUB.add(BigInteger.ONE).equals(fromLB)) {
                    return CompoundBitVectorInterval.of(pInfo.getRange());
                }
                BitVectorInterval[] intervals = new BitVectorInterval[]{BitVectorInterval.singleton(pInfo, fromUB).extendToMinValue(), BitVectorInterval.singleton(pInfo, fromLB).extendToMaxValue()};
                return CompoundBitVectorInterval.getInternal(pInfo, intervals);
            }
            newLowerBound = fromLB;
            newUpperBound = fromUB;
        }
        return CompoundBitVectorInterval.of(BitVectorInterval.of(pInfo, newLowerBound, newUpperBound));
    }

    @Override
    public boolean containsPositive() {
        if (this.isBottom()) {
            return false;
        }
        for (BitVectorInterval interval : this.intervals) {
            if (!interval.containsPositive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNegative() {
        if (this.isBottom()) {
            return false;
        }
        for (BitVectorInterval interval : this.intervals) {
            if (!interval.containsNegative()) continue;
            return true;
        }
        return false;
    }

    public boolean containsZero() {
        return this.contains(0L);
    }

    @Override
    public CompoundBitVectorInterval extendToMinValue() {
        if (!this.hasLowerBound()) {
            return this;
        }
        BitVectorInterval[] resultIntervals = new BitVectorInterval[this.intervals.length];
        resultIntervals[0] = this.intervals[0].extendToMinValue();
        System.arraycopy(this.intervals, 1, resultIntervals, 1, this.intervals.length - 1);
        return CompoundBitVectorInterval.getInternal(this.info, resultIntervals);
    }

    @Override
    public CompoundBitVectorInterval extendToMaxValue() {
        if (!this.hasUpperBound()) {
            return this;
        }
        BitVectorInterval[] resultIntervals = new BitVectorInterval[this.intervals.length];
        int index = this.intervals.length - 1;
        System.arraycopy(this.intervals, 0, resultIntervals, 0, index);
        resultIntervals[index] = this.intervals[index].extendToMaxValue();
        return CompoundBitVectorInterval.getInternal(this.info, resultIntervals);
    }

    public CompoundBitVectorInterval add(BigInteger pValue, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ISCOperatorFactory.INSTANCE.getAdd(pAllowSignedWrapAround, pOverflowEventHandler), pValue);
    }

    public CompoundBitVectorInterval add(long pValue, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.add(BigInteger.valueOf(pValue), pAllowSignedWrapAround, pOverflowEventHandler);
    }

    public CompoundBitVectorInterval add(BitVectorInterval pInterval, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(IICOperatorFactory.INSTANCE.getAdd(pAllowSignedWrapAround, pOverflowEventHandler), pInterval);
    }

    public CompoundBitVectorInterval add(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ICCOperatorFactory.INSTANCE.getAdd(pAllowSignedWrapAround, pOverflowEventHandler), pState);
    }

    public CompoundBitVectorInterval multiply(BigInteger pValue, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        if (pValue.equals(BigInteger.ZERO)) {
            return CompoundBitVectorInterval.singleton(this.info, pValue);
        }
        if (pValue.equals(BigInteger.ONE)) {
            return this;
        }
        return this.applyOperationToAllAndUnite(ISCOperatorFactory.INSTANCE.getMultiply(pAllowSignedWrapAround, pOverflowEventHandler), pValue);
    }

    public CompoundBitVectorInterval multiply(BitVectorInterval pInterval, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        if (pInterval.isSingleton()) {
            return this.multiply(pInterval.getLowerBound(), pAllowSignedWrapAround, pOverflowEventHandler);
        }
        return this.applyOperationToAllAndUnite(IICOperatorFactory.INSTANCE.getMultiply(pAllowSignedWrapAround, pOverflowEventHandler), pInterval);
    }

    public CompoundBitVectorInterval multiply(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        if (pState.intervals.length == 1) {
            return this.multiply(pState.intervals[0], pAllowSignedWrapAround, pOverflowEventHandler);
        }
        return this.applyOperationToAllAndUnite(ICCOperatorFactory.INSTANCE.getMultiply(pAllowSignedWrapAround, pOverflowEventHandler), pState);
    }

    public CompoundBitVectorInterval divide(BigInteger pValue, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ISCOperatorFactory.INSTANCE.getDivide(pAllowSignedWrapAround, pOverflowEventHandler), pValue);
    }

    public CompoundBitVectorInterval divide(BitVectorInterval pInterval, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(IICOperatorFactory.INSTANCE.getDivide(pAllowSignedWrapAround, pOverflowEventHandler), pInterval);
    }

    public CompoundBitVectorInterval divide(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ICCOperatorFactory.INSTANCE.getDivide(pAllowSignedWrapAround, pOverflowEventHandler), pState);
    }

    public CompoundBitVectorInterval modulo(BigInteger pValue, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ISCOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler), pValue);
    }

    public CompoundBitVectorInterval modulo(BitVectorInterval pInterval, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(IICOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler), pInterval);
    }

    public CompoundBitVectorInterval modulo(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ICCOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler), pState);
    }

    public CompoundBitVectorInterval shiftLeft(BigInteger pValue, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ISCOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler), pValue);
    }

    public CompoundBitVectorInterval shiftLeft(BitVectorInterval pInterval, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(IICOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler), pInterval);
    }

    public CompoundBitVectorInterval shiftLeft(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ICCOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler), pState);
    }

    public CompoundBitVectorInterval shiftRight(BigInteger pValue, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ISCOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler), pValue);
    }

    public CompoundBitVectorInterval shiftRight(BitVectorInterval pInterval, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(IICOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler), pInterval);
    }

    public CompoundBitVectorInterval shiftRight(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return this.applyOperationToAllAndUnite(ICCOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler), pState);
    }

    public CompoundBitVectorInterval logicalEquals(CompoundBitVectorInterval pState) {
        this.checkBitVectorCompatibilityWith(pState.info);
        if (this.isBottom() || pState.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (this.isSingleton() && this.equals(pState)) {
            return CompoundBitVectorInterval.logicalTrue(this.info);
        }
        if (!this.intersectsWith(pState)) {
            return CompoundBitVectorInterval.logicalFalse(this.info);
        }
        return CompoundBitVectorInterval.getInternal(this.info.getRange());
    }

    @Override
    public boolean isDefinitelyFalse() {
        return this.equals(CompoundBitVectorInterval.logicalFalse(this.info));
    }

    @Override
    public boolean isDefinitelyTrue() {
        return !this.isBottom() && !this.containsZero();
    }

    public CompoundBitVectorInterval greaterThan(CompoundBitVectorInterval pState) {
        this.checkBitVectorCompatibilityWith(pState.info);
        if (this.isBottom() || pState.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (this.hasLowerBound() && pState.hasUpperBound() && this.getLowerBound().compareTo(pState.getUpperBound()) > 0) {
            return CompoundBitVectorInterval.logicalTrue(this.info);
        }
        if (this.hasUpperBound() && pState.hasLowerBound() && this.getUpperBound().compareTo(pState.getLowerBound()) <= 0) {
            return CompoundBitVectorInterval.logicalFalse(this.info);
        }
        return CompoundBitVectorInterval.getInternal(this.info.getRange());
    }

    public CompoundBitVectorInterval greaterEqual(CompoundBitVectorInterval pState) {
        this.checkBitVectorCompatibilityWith(pState.info);
        if (this.isBottom() || pState.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (this.hasLowerBound() && pState.hasUpperBound() && this.getLowerBound().compareTo(pState.getUpperBound()) >= 0) {
            return CompoundBitVectorInterval.logicalTrue(this.info);
        }
        if (this.hasUpperBound() && pState.hasLowerBound() && this.getUpperBound().compareTo(pState.getLowerBound()) < 0) {
            return CompoundBitVectorInterval.logicalFalse(this.info);
        }
        return CompoundBitVectorInterval.getInternal(this.info.getRange());
    }

    public CompoundBitVectorInterval lessThan(CompoundBitVectorInterval pState) {
        this.checkBitVectorCompatibilityWith(pState.info);
        return this.greaterEqual(pState).logicalNot();
    }

    public CompoundBitVectorInterval lessEqual(CompoundBitVectorInterval pState) {
        this.checkBitVectorCompatibilityWith(pState.info);
        return this.greaterThan(pState).logicalNot();
    }

    public CompoundBitVectorInterval logicalAnd(CompoundBitVectorInterval pState) {
        this.checkBitVectorCompatibilityWith(pState.info);
        if (this.isBottom() || pState.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (this.isSingleton() && this.containsZero() || pState.isSingleton() && pState.containsZero()) {
            return CompoundBitVectorInterval.logicalFalse(this.info);
        }
        if (!this.containsZero() && !pState.containsZero()) {
            return CompoundBitVectorInterval.logicalTrue(this.info);
        }
        return CompoundBitVectorInterval.getInternal(this.info.getRange());
    }

    public CompoundBitVectorInterval logicalOr(CompoundBitVectorInterval pState) {
        this.checkBitVectorCompatibilityWith(pState.info);
        if (this.isBottom() || pState.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (this.isSingleton() && this.containsZero() && pState.isSingleton() && pState.containsZero()) {
            return CompoundBitVectorInterval.logicalFalse(this.info);
        }
        if (!this.containsZero() || !pState.containsZero()) {
            return CompoundBitVectorInterval.logicalTrue(this.info);
        }
        return CompoundBitVectorInterval.getInternal(this.info.getRange());
    }

    public CompoundBitVectorInterval logicalNot() {
        if (this.isBottom()) {
            return this;
        }
        if (this.isSingleton() && this.containsZero()) {
            return CompoundBitVectorInterval.logicalTrue(this.info);
        }
        if (!this.containsZero()) {
            return CompoundBitVectorInterval.logicalFalse(this.info);
        }
        return CompoundBitVectorInterval.getInternal(this.info.getRange());
    }

    public CompoundBitVectorInterval binaryAnd(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        CompoundBitVectorInterval result;
        this.checkBitVectorCompatibilityWith(pState.info);
        if (this.isBottom() || pState.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return pState;
        }
        if (this.isSingleton() && this.containsZero()) {
            return this;
        }
        if (pState.isSingleton()) {
            result = CompoundBitVectorInterval.bottom(this.info);
            for (BitVectorInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return pState.contains(1L) ? CompoundBitVectorInterval.getZeroToOne(this.info) : CompoundBitVectorInterval.getInternal(pState.info.getRange());
                }
                result = result.unionWith(BitVectorInterval.singleton(this.info, interval.getLowerBound().and(pState.getValue())));
            }
        } else {
            if (this.isSingleton()) {
                return pState.binaryAnd(this, pAllowSignedWrapAround, pOverflowEventHandler);
            }
            result = CompoundBitVectorInterval.getInternal(this.info.getRange());
        }
        if (!result.isSingleton()) {
            CompoundBitVectorInterval absThis = this.absolute(pAllowSignedWrapAround, pOverflowEventHandler);
            CompoundBitVectorInterval absOther = pState.absolute(pAllowSignedWrapAround, pOverflowEventHandler);
            BigInteger smallestUpperBound = null;
            if (absThis.hasUpperBound()) {
                smallestUpperBound = absThis.getUpperBound();
            }
            if (absOther.hasUpperBound()) {
                BigInteger bigInteger = smallestUpperBound = smallestUpperBound == null ? absOther.getUpperBound() : smallestUpperBound.min(absOther.getUpperBound());
            }
            assert (smallestUpperBound == null || smallestUpperBound.signum() >= 0);
            CompoundBitVectorInterval range = smallestUpperBound == null ? CompoundBitVectorInterval.zero(this.info).extendToMaxValue() : CompoundBitVectorInterval.of(BitVectorInterval.of(this.info, BigInteger.ZERO, smallestUpperBound));
            if (this.containsNegative() && pState.containsNegative()) {
                range = range.unionWith(range.negate(pAllowSignedWrapAround, pOverflowEventHandler));
            }
            result = result.intersectWith(range);
        }
        return result;
    }

    public CompoundBitVectorInterval absolute(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        if (!this.containsNegative()) {
            return this;
        }
        return this.intersectWith(CompoundBitVectorInterval.one(this.info).negate(pAllowSignedWrapAround, pOverflowEventHandler).extendToMinValue()).negate(pAllowSignedWrapAround, pOverflowEventHandler).unionWith(this.intersectWith(CompoundBitVectorInterval.zero(this.info).extendToMaxValue())).intersectWith(CompoundBitVectorInterval.zero(this.info).extendToMaxValue());
    }

    public CompoundBitVectorInterval binaryXor(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        this.checkBitVectorCompatibilityWith(pState.info);
        if (this.isBottom() || pState.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (this.isSingleton() && pState.isSingleton()) {
            return CompoundBitVectorInterval.of(BitVectorInterval.cast(this.info, this.getValue().xor(pState.getValue()), pAllowSignedWrapAround, pOverflowEventHandler));
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return this;
        }
        if (this.isSingleton() && this.containsZero()) {
            return pState;
        }
        if (pState.isSingleton() && pState.contains(1L) && this.equals(CompoundBitVectorInterval.getZeroToOne(this.info))) {
            return this;
        }
        if (this.isSingleton() && this.contains(1L) && pState.equals(CompoundBitVectorInterval.getZeroToOne(this.info))) {
            return CompoundBitVectorInterval.getZeroToOne(this.info);
        }
        if (pState.isSingleton()) {
            CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
            for (BitVectorInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return CompoundBitVectorInterval.getInternal(this.info.getRange());
                }
                result = result.unionWith(BitVectorInterval.cast(this.info, interval.getLowerBound().xor(pState.getValue()), pAllowSignedWrapAround, pOverflowEventHandler));
            }
            return result;
        }
        if (this.isSingleton()) {
            return pState.binaryXor(this, pAllowSignedWrapAround, pOverflowEventHandler);
        }
        return CompoundBitVectorInterval.getInternal(this.info.getRange());
    }

    public CompoundBitVectorInterval binaryNot(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        if (this.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
        for (BitVectorInterval interval : this.intervals) {
            if (!interval.isSingleton()) {
                return CompoundBitVectorInterval.getInternal(this.info.getRange());
            }
            BitVectorInterval partialResult = this.info.isSigned() ? BitVectorInterval.cast(this.info, interval.getLowerBound().not(), pAllowSignedWrapAround, pOverflowEventHandler) : BitVectorInterval.cast(this.info, new BigInteger(1, interval.getLowerBound().not().toByteArray()), pAllowSignedWrapAround, pOverflowEventHandler);
            result = result.unionWith(partialResult);
        }
        return result;
    }

    public CompoundBitVectorInterval binaryOr(CompoundBitVectorInterval pState, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        this.checkBitVectorCompatibilityWith(pState.info);
        if (this.isBottom() || pState.isBottom()) {
            return CompoundBitVectorInterval.bottom(this.info);
        }
        if (this.isSingleton() && this.containsZero()) {
            return pState;
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return this;
        }
        if (pState.isSingleton()) {
            CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
            for (BitVectorInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return CompoundBitVectorInterval.getInternal(this.info.getRange());
                }
                result = result.unionWith(BitVectorInterval.cast(this.info, interval.getLowerBound().or(pState.getValue()), pAllowSignedWrapAround, pOverflowEventHandler));
            }
            return result;
        }
        if (this.isSingleton()) {
            return pState.binaryOr(this, pAllowSignedWrapAround, pOverflowEventHandler);
        }
        return CompoundBitVectorInterval.getInternal(this.info.getRange());
    }

    public CompoundBitVectorInterval logicalXor(CompoundBitVectorInterval pState) {
        return CompoundBitVectorInterval.logicalAnd(CompoundBitVectorInterval.logicalOr(this, pState), CompoundBitVectorInterval.logicalNot(CompoundBitVectorInterval.logicalAnd(this, pState)));
    }

    public static CompoundBitVectorInterval logicalAnd(CompoundBitVectorInterval p1, CompoundBitVectorInterval p2) {
        return p1.logicalAnd(p2);
    }

    public static CompoundBitVectorInterval logicalOr(CompoundBitVectorInterval p1, CompoundBitVectorInterval p2) {
        return p1.logicalOr(p2);
    }

    public static CompoundBitVectorInterval logicalXor(CompoundBitVectorInterval p1, CompoundBitVectorInterval p2) {
        return p1.logicalXor(p2);
    }

    public static CompoundBitVectorInterval logicalNot(CompoundBitVectorInterval pState) {
        return pState.logicalNot();
    }

    private <T> CompoundBitVectorInterval applyOperationToAllAndUnite(Operator<BitVectorInterval, T, CompoundBitVectorInterval> pOperator, T pOperand) {
        CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(this.info);
        for (BitVectorInterval interval : this.intervals) {
            CompoundBitVectorInterval current = pOperator.apply(interval, pOperand);
            if (current == null || !(result = result.unionWith(current)).containsAllPossibleValues()) continue;
            return result;
        }
        return result;
    }

    private static BitVectorInterval union(BitVectorInterval pA, BitVectorInterval pB) {
        Preconditions.checkArgument((boolean)pA.getTypeInfo().equals(pB.getTypeInfo()));
        Preconditions.checkArgument((boolean)pA.touches(pB), (Object)"Cannot unite intervals that do not touch.");
        return BitVectorInterval.of(pA.getTypeInfo(), CompoundBitVectorInterval.lowestBound(pA, pB), CompoundBitVectorInterval.highestBound(pA, pB));
    }

    private static BigInteger lowestBound(BitVectorInterval pA, BitVectorInterval pB) {
        BigInteger bLowerBound;
        BigInteger aLowerBound = pA.getLowerBound();
        return CompoundBitVectorInterval.lessOrEqual(aLowerBound, bLowerBound = pB.getLowerBound()) ? aLowerBound : bLowerBound;
    }

    private static BigInteger highestBound(BitVectorInterval pA, BitVectorInterval pB) {
        BigInteger aUpperBound = pA.getUpperBound();
        BigInteger bUpperBound = pB.getUpperBound();
        return CompoundBitVectorInterval.lessOrEqual(bUpperBound, aUpperBound) ? aUpperBound : bUpperBound;
    }

    private static boolean less(BigInteger pFirst, BigInteger pSecond) {
        return pFirst.compareTo(pSecond) < 0;
    }

    private static boolean lessOrEqual(BigInteger pFirst, BigInteger pSecond) {
        return pFirst.compareTo(pSecond) <= 0;
    }

    public static CompoundBitVectorInterval of(BitVectorInterval interval) {
        return CompoundBitVectorInterval.getInternal(interval);
    }

    public static CompoundBitVectorInterval singleton(BitVectorInfo pInfo, BigInteger pValue) {
        Preconditions.checkNotNull((Object)pValue);
        return CompoundBitVectorInterval.of(BitVectorInterval.singleton(pInfo, pValue));
    }

    public static CompoundBitVectorInterval singleton(BitVectorInfo pInfo, long pValue) {
        return CompoundBitVectorInterval.singleton(pInfo, BigInteger.valueOf(pValue));
    }

    public static CompoundBitVectorInterval bottom(BitVectorInfo pInfo) {
        return new CompoundBitVectorInterval(pInfo);
    }

    public static CompoundBitVectorInterval logicalFalse(BitVectorInfo pInfo) {
        return CompoundBitVectorInterval.zero(pInfo);
    }

    public static CompoundBitVectorInterval logicalTrue(BitVectorInfo pInfo) {
        return CompoundBitVectorInterval.zero(pInfo).invert();
    }

    public static CompoundBitVectorInterval zero(BitVectorInfo pInfo) {
        return CompoundBitVectorInterval.singleton(pInfo, BigInteger.ZERO);
    }

    public static CompoundBitVectorInterval one(BitVectorInfo pInfo) {
        return CompoundBitVectorInterval.singleton(pInfo, BigInteger.ONE);
    }

    public static CompoundBitVectorInterval minusOne(BitVectorInfo pInfo) {
        return CompoundBitVectorInterval.singleton(pInfo, -1L);
    }

    public static CompoundBitVectorInterval span(CompoundBitVectorInterval pLeftValue, CompoundBitVectorInterval pRightValue) {
        return pLeftValue.span().unionWith(pRightValue.span()).span();
    }

    public static CompoundBitVectorInterval union(CompoundBitVectorInterval pLeftValue, CompoundBitVectorInterval pRightValue) {
        return pLeftValue.unionWith(pRightValue);
    }

    public static CompoundBitVectorInterval fromBoolean(BitVectorInfo pInfo, boolean value) {
        return value ? CompoundBitVectorInterval.logicalTrue(pInfo) : CompoundBitVectorInterval.logicalFalse(pInfo);
    }

    private static CompoundBitVectorInterval getZeroToOne(BitVectorInfo pInfo) {
        return CompoundBitVectorInterval.of(BitVectorInterval.of(pInfo, BigInteger.ZERO, BigInteger.ONE));
    }
}

